/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils;

public class HtmlCheckboxRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlCheckboxRendererBase.class.getName());
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String EXTERNAL_TRUE_VALUE = "true";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (uiComponent instanceof UISelectBoolean) {
            Boolean value = RendererUtils.getBooleanValue(uiComponent);
            boolean isChecked = value != null ? value : false;
            this.renderCheckbox(facesContext, uiComponent, EXTERNAL_TRUE_VALUE, false, isChecked, true, null);
        } else if (uiComponent instanceof UISelectMany) {
            this.renderCheckboxList(facesContext, (UISelectMany)uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        Converter converter;
        Set lookupSet;
        boolean useSubmittedValues;
        String layout = this.getLayout(selectMany);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.severe("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout);
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        Map behaviors = null;
        if (selectMany instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)selectMany).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", (Object)selectMany.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        }
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectMany);
        }
        boolean bl = useSubmittedValues = (lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter = this.getConverter(facesContext, (UIComponent)selectMany), selectMany)) != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        int itemNum = 0;
        for (SelectItem selectItem : RendererUtils.getSelectItemList(selectMany, facesContext)) {
            itemNum = this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, useSubmittedValues, lookupSet, converter, pageDirectionLayout, itemNum);
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        if (selectMany instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)selectMany).getLayout();
        }
        return (String)selectMany.getAttributes().get("layout");
    }

    protected int renderGroupOrItemCheckbox(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean useSubmittedValues, Set lookupSet, Converter converter, boolean pageDirectionLayout, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectMany selectMany = (UISelectMany)uiComponent;
        if (isSelectItemGroup) {
            SelectItem[] selectItems;
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.write(selectItem.getLabel());
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.startElement("table", (UIComponent)selectMany);
            writer.writeAttribute("border", (Object)"0", null);
            if (!pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            SelectItemGroup group = (SelectItemGroup)selectItem;
            for (SelectItem groupSelectItem : selectItems = group.getSelectItems()) {
                itemNum = this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, groupSelectItem, useSubmittedValues, lookupSet, converter, pageDirectionLayout, itemNum);
            }
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            Object itemValue = selectItem.getValue();
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectMany, converter, itemValue);
            boolean checked = lookupSet.contains(itemStrValue);
            if (HtmlRendererUtils.isHideNoSelectionOption(uiComponent) && selectItem.isNoSelectionOption() && lookupSet.size() != 0 && !checked) {
                return itemNum;
            }
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            boolean disabled = selectItem.isDisabled();
            String itemId = this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, disabled, checked, false, itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectMany);
            boolean itemDisabled = componentDisabled || disabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectMany, itemId, selectItem, itemDisabled, checked);
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
            Integer n = itemNum;
            Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
        }
        return itemNum;
    }

    @Deprecated
    protected void renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        this.renderCheckbox(facesContext, uiComponent, value, disabled, checked, renderId, 0);
    }

    protected String renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        Map behaviors = null;
        if (uiComponent instanceof UISelectBoolean) {
            if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
                behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
            }
        } else if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlSelectBooleanCheckbox) {
            return ((HtmlSelectBooleanCheckbox)component).isDisabled();
        }
        if (component instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            HtmlRendererUtils.decodeUISelectBoolean(facesContext, component);
        } else if (component instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            return submittedValue;
        }
        if (component instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)component, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
    }

    protected Converter getConverter(FacesContext facesContext, UIComponent component) {
        if (component instanceof UISelectMany) {
            return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, (UIComponent)((UISelectMany)component));
        }
        if (component instanceof UISelectOne) {
            return HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, component);
        }
        return null;
    }
}

