/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.resource;

import org.apache.myfaces.shared_impl.resource.ResourceMeta;

public class ResourceMetaImpl
extends ResourceMeta {
    private final String _prefix;
    private final String _libraryName;
    private final String _libraryVersion;
    private final String _resourceName;
    private final String _resourceVersion;

    public ResourceMetaImpl(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        this._prefix = prefix;
        this._libraryName = libraryName;
        this._libraryVersion = libraryVersion;
        this._resourceName = resourceName;
        this._resourceVersion = resourceVersion;
    }

    @Override
    public String getLibraryName() {
        return this._libraryName;
    }

    @Override
    public String getResourceName() {
        return this._resourceName;
    }

    @Override
    public String getLocalePrefix() {
        return this._prefix;
    }

    @Override
    public String getLibraryVersion() {
        return this._libraryVersion;
    }

    @Override
    public String getResourceVersion() {
        return this._resourceVersion;
    }

    @Override
    public String getResourceIdentifier() {
        StringBuilder builder = new StringBuilder();
        boolean firstSlashAdded = false;
        if (this._prefix != null && this._prefix.length() > 0) {
            builder.append(this._prefix);
            firstSlashAdded = true;
        }
        if (this._libraryName != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._libraryName);
            firstSlashAdded = true;
        }
        if (this._libraryVersion != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._libraryVersion);
            firstSlashAdded = true;
        }
        if (this._resourceName != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._resourceName);
            firstSlashAdded = true;
        }
        if (this._resourceVersion != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._resourceVersion);
            builder.append(this._resourceName.substring(this._resourceName.lastIndexOf(46)));
            firstSlashAdded = true;
        }
        return builder.toString();
    }

    @Override
    public boolean couldResourceContainValueExpressions() {
        return false;
    }
}

