/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_impl.util.ClassLoaderUtils;

public class MyFacesClassLoader
extends ClassLoader {
    private static final String APPLICATION_MAP_KEY = MyFacesClassLoader.class.getName();
    private ClassLoader apiClassLoader = FacesContext.class.getClassLoader();
    private ClassLoader implClassLoader = this.getClass().getClassLoader();

    public static final MyFacesClassLoader getCurrentInstance(ExternalContext externalContext) {
        if (externalContext == null) {
            return new MyFacesClassLoader();
        }
        Map applicationMap = externalContext.getApplicationMap();
        MyFacesClassLoader classLoader = (MyFacesClassLoader)applicationMap.get(APPLICATION_MAP_KEY);
        if (classLoader == null) {
            classLoader = new MyFacesClassLoader();
            applicationMap.put(APPLICATION_MAP_KEY, classLoader);
        }
        return classLoader;
    }

    private static ClassLoader getContextClassLoaderFailsafe() {
        ClassLoader contextClassLoader = ClassLoaderUtils.getContextClassLoader();
        if (contextClassLoader == null) {
            contextClassLoader = MyFacesClassLoader.class.getClassLoader();
        }
        return contextClassLoader;
    }

    public MyFacesClassLoader() {
        super(MyFacesClassLoader.getContextClassLoaderFailsafe());
    }

    @Override
    public URL getResource(String s) {
        URL url = super.getResource(s);
        if (url == null && (url = this.apiClassLoader.getResource(s)) == null) {
            url = this.implClassLoader.getResource(s);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String s) throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(Collections.list(super.getResources(s)));
        urls.addAll(Collections.list(this.apiClassLoader.getResources(s)));
        urls.addAll(Collections.list(this.implClassLoader.getResources(s)));
        return Collections.enumeration(urls);
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        InputStream stream = super.getResourceAsStream(s);
        if (stream == null && (stream = this.apiClassLoader.getResourceAsStream(s)) == null) {
            stream = this.implClassLoader.getResourceAsStream(s);
        }
        return stream;
    }

    @Override
    public Class<?> loadClass(String s) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassNotFoundException firstException = null;
        try {
            clazz = super.loadClass(s);
        }
        catch (ClassNotFoundException cnfe) {
            firstException = cnfe;
        }
        if (clazz == null && (clazz = this.loadClassFailsafe(s, this.apiClassLoader)) == null && (clazz = this.loadClassFailsafe(s, this.implClassLoader)) == null) {
            throw firstException;
        }
        return clazz;
    }

    public boolean equals(Object o) {
        if (o instanceof MyFacesClassLoader) {
            MyFacesClassLoader other = (MyFacesClassLoader)o;
            return other.getParent().equals(this.getParent());
        }
        return false;
    }

    private Class<?> loadClassFailsafe(String s, ClassLoader classLaoder) {
        try {
            return classLaoder.loadClass(s);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }
}

