/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.util.Locale;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.shared_impl.taglib.UIComponentELTagUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.taglib.core.ConverterTag;

public class ConvertDateTimeTag
extends ConverterTag {
    private static final long serialVersionUID = 54366768002181L;
    private static final String DEFAULT_DATE_STYLE = "default";
    private static final String DEFAULT_TIME_STYLE = "default";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String DEFAULT_TYPE = "date";
    private ValueExpression _dateStyle;
    private ValueExpression _locale;
    private ValueExpression _pattern;
    private ValueExpression _timeStyle;
    private ValueExpression _timeZone;
    private ValueExpression _type;
    private static final ValueExpression CONVERTER_ID;

    @Override
    public void release() {
        super.release();
        this._dateStyle = null;
        this._locale = null;
        this._pattern = null;
        this._timeStyle = null;
        this._timeZone = null;
        this._type = null;
    }

    public void setDateStyle(ValueExpression dateStyle) {
        this._dateStyle = dateStyle;
    }

    public void setLocale(ValueExpression locale) {
        this._locale = locale;
    }

    public void setPattern(ValueExpression pattern) {
        this._pattern = pattern;
    }

    public void setTimeStyle(ValueExpression timeStyle) {
        this._timeStyle = timeStyle;
    }

    public void setTimeZone(ValueExpression timeZone) {
        this._timeZone = timeZone;
    }

    public void setType(ValueExpression type) {
        this._type = type;
    }

    public int doStartTag() throws JspException {
        super.setConverterId(CONVERTER_ID);
        return super.doStartTag();
    }

    @Override
    protected Converter createConverter() throws JspException {
        DateTimeConverter converter = (DateTimeConverter)super.createConverter();
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        this.setConverterDateStyle(elContext, converter, this._dateStyle);
        this.setConverterLocale(elContext, converter, this._locale);
        this.setConverterPattern(elContext, converter, this._pattern);
        this.setConverterTimeStyle(elContext, converter, this._timeStyle);
        this.setConverterTimeZone(elContext, converter, this._timeZone);
        this.setConverterType(elContext, converter, this._type);
        return converter;
    }

    private void setConverterLocale(ELContext eLContext, DateTimeConverter converter, ValueExpression value) {
        if (value == null) {
            return;
        }
        Object objLocale = UIComponentELTagUtils.evaluateValueExpression(eLContext, value);
        if (objLocale == null) {
            return;
        }
        Locale locale = objLocale instanceof Locale ? (Locale)objLocale : LocaleUtils.toLocale(objLocale.toString());
        converter.setLocale(locale);
    }

    private void setConverterDateStyle(ELContext elContext, DateTimeConverter converter, ValueExpression value) {
        if (value == null) {
            return;
        }
        String dateStyle = (String)UIComponentELTagUtils.evaluateValueExpression(elContext, value);
        if (dateStyle == null) {
            dateStyle = "default";
        }
        converter.setDateStyle(dateStyle);
    }

    private void setConverterPattern(ELContext elContext, DateTimeConverter converter, ValueExpression value) {
        if (value == null) {
            return;
        }
        String pattern = (String)UIComponentELTagUtils.evaluateValueExpression(elContext, value);
        converter.setPattern(pattern);
    }

    private void setConverterTimeStyle(ELContext elContext, DateTimeConverter converter, ValueExpression value) {
        if (value == null) {
            return;
        }
        String timeStyle = (String)UIComponentELTagUtils.evaluateValueExpression(elContext, value);
        if (timeStyle == null) {
            timeStyle = "default";
        }
        converter.setTimeStyle(timeStyle);
    }

    private void setConverterTimeZone(ELContext elContext, DateTimeConverter converter, ValueExpression value) {
        if (value == null) {
            return;
        }
        Object objTimeZone = UIComponentELTagUtils.evaluateValueExpression(elContext, value);
        if (objTimeZone == null) {
            return;
        }
        TimeZone timeZone = objTimeZone instanceof TimeZone ? (TimeZone)objTimeZone : TimeZone.getTimeZone(objTimeZone.toString());
        converter.setTimeZone(timeZone);
    }

    private void setConverterType(ELContext elContext, DateTimeConverter converter, ValueExpression value) {
        String type = value == null ? null : (String)UIComponentELTagUtils.evaluateValueExpression(elContext, value);
        if (type == null) {
            String dateStyle;
            String timeStyle = this._timeStyle == null ? null : (String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._timeStyle);
            String string = dateStyle = this._dateStyle == null ? null : (String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._dateStyle);
            type = dateStyle == null ? (timeStyle == null ? "date" : TYPE_TIME) : (timeStyle == null ? "date" : TYPE_BOTH);
        } else if (!("date".equals(type) || TYPE_TIME.equals(type) || TYPE_BOTH.equals(type))) {
            type = "date";
        }
        converter.setType(type);
    }

    static {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        CONVERTER_ID = facesContext != null ? facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "javax.faces.DateTime", String.class) : null;
    }
}

