/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import com.ibm.ws.jsf.extprocessor.JSFExtensionFactory;
import com.ibm.ws.serialization.SerializationService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.viewstate.CounterKeyFactory;
import org.apache.myfaces.application.viewstate.CounterSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.application.viewstate.RandomKeyFactory;
import org.apache.myfaces.application.viewstate.RandomSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.SecureRandomKeyFactory;
import org.apache.myfaces.application.viewstate.SecureSerializedViewCollection;
import org.apache.myfaces.application.viewstate.SecureSerializedViewKey;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactory;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.WebConfigParamUtils;

class DefaultFaceletsStateManagementHelper {
    private static final Logger log = Logger.getLogger(DefaultFaceletsStateManagementHelper.class.getName());
    private static final String SERIALIZED_VIEW_SESSION_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".SERIALIZED_VIEW";
    public static final String SERIALIZED_VIEW_REQUEST_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".SERIALIZED_VIEW";
    private static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    private static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    private static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE = "org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT = "hard-soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT = "soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK = "soft-weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK = "weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF = "off";
    private static final int UNCOMPRESSED_FLAG = 0;
    private static final int COMPRESSED_FLAG = 1;
    private static final int JSF_SEQUENCE_INDEX = 0;
    private SessionViewStorageFactory sessionViewStorageFactory;

    public DefaultFaceletsStateManagementHelper() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
            String randomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN", "secureRandom");
            if ("random".equals(randomMode)) {
                this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new RandomKeyFactory(facesContext));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using RandomKeyFactory");
                }
            } else if ("none".equals(randomMode)) {
                this.sessionViewStorageFactory = new CounterSessionViewStorageFactory(new CounterKeyFactory());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using CounterKeyFactory");
                }
            } else {
                this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new SecureRandomKeyFactory(facesContext));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using SecureRandomKeyFactory");
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("New DefaultFaceletsStateManagementHelper instance created");
            }
        }
    }

    protected Object getSecureServerStateId(Object[] state) {
        Object sequence;
        if (state != null && (sequence = state[0]) != null) {
            return this.getKeyFactory().decode((String)sequence);
        }
        return null;
    }

    protected Integer getServerStateId(Object[] state) {
        return null;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, Object serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SecureSerializedViewCollection viewCollection = (SecureSerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = new SecureSerializedViewCollection();
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        SecureSerializedViewKey nextKey = this.getSessionViewStorageFactory().createSerializedViewKey(context, context.getViewRoot().getViewId(), this.getNextSecureViewSequence(context));
        viewCollection.add(context, this.serializeView(context, serializedView), nextKey);
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Integer sequence) {
        return null;
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Object sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Object serializedView = null;
        if (requestMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = requestMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SecureSerializedViewCollection viewCollection = (SecureSerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence))) != null) {
                serializedView = this.deserializeView(state);
            }
            requestMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            this.nextSecureViewSequence(context);
        }
        return serializedView;
    }

    protected int getNextViewSequence(FacesContext context) {
        return 0;
    }

    protected void nextViewSequence(FacesContext facescontext) {
    }

    protected Object getNextSecureViewSequence(FacesContext context) {
        Object sequence = context.getAttributes().get("jsf_sequence");
        if (sequence == null) {
            sequence = this.nextSecureViewSequence(context);
            context.getAttributes().put("jsf_sequence", sequence);
        }
        return sequence;
    }

    protected Object nextSecureViewSequence(FacesContext facescontext) {
        Object sequence = this.getKeyFactory().generateKey(facescontext);
        facescontext.getAttributes().put("jsf_sequence", sequence);
        return sequence;
    }

    private SerializationService getSerializationService() {
        return JSFExtensionFactory.getSerializationService();
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                Object[] stateArray = (Object[])serializedView;
                ObjectOutputStream out = this.getSerializationService().createObjectOutputStream(os);
                out.writeObject(stateArray[0]);
                out.writeObject(stateArray[1]);
                out.close();
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = Boolean.valueOf(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = Boolean.valueOf(value);
        }
        return compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object[] objectArray;
            block15: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                ClassLoader cl = ClassUtils.getContextClassLoader();
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream ois = null;
                try {
                    ObjectInputStream in;
                    ois = in = this.getSerializationService().createObjectInputStream(is, cl);
                    Object[] object = null;
                    object = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object[]>(){

                        @Override
                        public Object[] run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return new Object[]{in.readObject(), in.readObject()};
                        }
                    }) : new Object[]{in.readObject(), in.readObject()};
                    objectArray = object;
                    if (ois == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return objectArray;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass());
        return null;
    }

    protected KeyFactory getKeyFactory() {
        return this.sessionViewStorageFactory.getKeyFactory();
    }

    protected SessionViewStorageFactory getSessionViewStorageFactory() {
        return this.sessionViewStorageFactory;
    }

    protected static class SerializedViewKey
    implements Serializable {
        private static final long serialVersionUID = -1170697124386063642L;
        private final String _viewId;
        private final Integer _sequenceId = null;

        public SerializedViewKey(String viewId, Integer sequence) {
            this._viewId = null;
        }

        public SerializedViewKey(FacesContext context) {
            this._viewId = null;
        }
    }

    protected static class SerializedViewCollection
    implements Serializable {
        private static final long serialVersionUID = -3734849062185115847L;
        private final boolean _enableRemoveRestoredViewState = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext()).isEnableRemoveRestoredViewState();
        private final List<Object> _keys = new ArrayList<Object>(20);
        private final Map<Object, Object> _serializedViews = new HashMap<Object, Object>();
        private transient Map<Object, Object> _oldSerializedViews = null;

        protected SerializedViewCollection() {
        }

        public synchronized void add(FacesContext context, Object state) {
        }

        protected int getNumberOfViewsInSession(FacesContext context) {
            return 0;
        }

        protected Map<Object, Object> getOldSerializedViewsMap() {
            return null;
        }

        protected String getCacheOldViewsInSessionMode(FacesContext context) {
            return null;
        }

        public Object get(Integer sequence, String viewId) {
            return null;
        }
    }
}

