/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.HashMapUtils;
import org.apache.myfaces.view.facelets.AttachedFullStateWrapper;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.DefaultFaceletsStateManagementHelper;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;

public class DefaultFaceletsStateManagementStrategy
extends StateManagementStrategy {
    public static final String CLIENTIDS_ADDED = "oam.CLIENTIDS_ADDED";
    public static final String CLIENTIDS_REMOVED = "oam.CLIENTIDS_REMOVED";
    public static final String COMPONENT_ADDED_AFTER_BUILD_VIEW = "oam.COMPONENT_ADDED_AFTER_BUILD_VIEW";
    private ViewDeclarationLanguageFactory _vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
    private DefaultFaceletsStateManagementHelper helper = new DefaultFaceletsStateManagementHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        Object[] state;
        Object serverStateId;
        UIViewRoot view = null;
        boolean oldContextEventState = context.isProcessingEvents();
        ResponseStateManager manager = RendererUtils.getResponseStateManager(context, renderKitId);
        state = context.getApplication().getStateManager().isSavingStateInClient(context) ? (Object[])manager.getState(context, viewId) : (Object[])((serverStateId = this.helper.getSecureServerStateId(state = (Object[])manager.getState(context, viewId))) == null ? null : this.helper.getSerializedViewFromServletSession(context, viewId, serverStateId));
        if (state == null) {
            return null;
        }
        if (state[1] instanceof Object[]) {
            Object[] fullState = (Object[])state[1];
            view = (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)fullState[0]);
            if (view != null) {
                context.setViewRoot(view);
                view.processRestoreState(context, fullState[1]);
            }
        } else {
            ViewDeclarationLanguage vdl = this._vdlFactory.getViewDeclarationLanguage(viewId);
            try {
                ViewMetadata metadata = vdl.getViewMetadata(context, viewId);
                Collection viewParameters = null;
                if (metadata != null && (view = metadata.createMetadataView(context)) != null) {
                    viewParameters = ViewMetadata.getViewParameters((UIViewRoot)view);
                }
                if (view == null) {
                    view = context.getApplication().getViewHandler().createView(context, viewId);
                }
                context.setViewRoot(view);
                try {
                    context.setProcessingEvents(true);
                    vdl.buildView(context, view);
                    this.suscribeListeners(view);
                }
                finally {
                    context.setProcessingEvents(oldContextEventState);
                }
            }
            catch (Throwable e) {
                throw new FacesException("unable to create view \"" + viewId + "\"", e);
            }
            if (state != null && state[1] != null) {
                List<String> clientIdsAdded;
                Map states = (Map)state[1];
                this.restoreStateFromMap(context, states, (UIComponent)view);
                List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(view);
                if (clientIdsRemoved != null) {
                    HashSet<String> idsRemovedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsRemoved.size()));
                    context.getAttributes().put("org.apache.myfaces.REMOVING_COMPONENTS_BUILD", Boolean.TRUE);
                    try {
                        for (String clientId : clientIdsRemoved) {
                            if (idsRemovedSet.contains(clientId)) continue;
                            view.invokeOnComponent(context, clientId, new ContextCallback(){

                                public void invokeContextCallback(FacesContext context, UIComponent target) {
                                    if (target.getParent() != null && !target.getParent().getChildren().remove(target)) {
                                        String key = null;
                                        for (Map.Entry entry : target.getParent().getFacets().entrySet()) {
                                            if (entry.getValue() != target) continue;
                                            key = (String)entry.getKey();
                                            break;
                                        }
                                        if (key != null) {
                                            target.getParent().getFacets().remove(key);
                                        }
                                    }
                                }
                            });
                            idsRemovedSet.add(clientId);
                        }
                        clientIdsRemoved.clear();
                        clientIdsRemoved.addAll(idsRemovedSet);
                    }
                    finally {
                        context.getAttributes().remove("org.apache.myfaces.REMOVING_COMPONENTS_BUILD");
                    }
                }
                if ((clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(view)) != null) {
                    HashSet<String> idsAddedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsAdded.size()));
                    for (String clientId : clientIdsAdded) {
                        Object[] addedState;
                        if (idsAddedSet.contains(clientId)) continue;
                        AttachedFullStateWrapper wrapper = (AttachedFullStateWrapper)states.get(clientId);
                        if (wrapper != null && (addedState = (Object[])wrapper.getWrappedStateObject()) != null) {
                            if (addedState.length == 2) {
                                view = (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)addedState[0]);
                                view.processRestoreState(context, addedState[1]);
                                break;
                            }
                            String parentClientId = (String)addedState[0];
                            view.invokeOnComponent(context, parentClientId, new ContextCallback(){

                                public void invokeContextCallback(FacesContext context, UIComponent target) {
                                    if (addedState[1] != null) {
                                        String facetName = (String)addedState[1];
                                        UIComponent child = DefaultFaceletsStateManagementStrategy.this.internalRestoreTreeStructure((TreeStructComponent)addedState[3]);
                                        child.processRestoreState(context, addedState[4]);
                                        target.getFacets().put(facetName, child);
                                    } else {
                                        Integer childIndex = (Integer)addedState[2];
                                        UIComponent child = DefaultFaceletsStateManagementStrategy.this.internalRestoreTreeStructure((TreeStructComponent)addedState[3]);
                                        child.processRestoreState(context, addedState[4]);
                                        try {
                                            target.getChildren().add(childIndex, child);
                                        }
                                        catch (IndexOutOfBoundsException e) {
                                            target.getChildren().add(child);
                                        }
                                    }
                                }
                            });
                        }
                        idsAddedSet.add(clientId);
                    }
                    clientIdsAdded.clear();
                }
            }
        }
        return view;
    }

    public Object saveView(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view == null) {
            return null;
        }
        if (view.isTransient()) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        Object serializedView = externalContext.getRequestMap().get(DefaultFaceletsStateManagementHelper.SERIALIZED_VIEW_REQUEST_ATTR);
        if (serializedView == null) {
            Object[] states;
            this.checkIds(context, (UIComponent)view, new HashSet<String>());
            if (view.getAttributes().containsKey(COMPONENT_ADDED_AFTER_BUILD_VIEW)) {
                this.ensureClearInitialState((UIComponent)view);
                states = new Object[]{this.internalBuildTreeStructureToSave((UIComponent)view), view.processSaveState(context)};
            } else {
                states = new HashMap();
                this.saveStateOnMap(context, (Map)states, (UIComponent)view);
                if (((Map)states).isEmpty()) {
                    states = null;
                }
            }
            if (context.getApplication().getStateManager().isSavingStateInClient(context)) {
                serializedView = new Object[]{null, states};
            } else {
                Object sequence = this.helper.getKeyFactory().encode(this.helper.getNextSecureViewSequence(context));
                serializedView = new Object[]{sequence, states};
            }
            externalContext.getRequestMap().put(DefaultFaceletsStateManagementHelper.SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
        }
        if (!context.getApplication().getStateManager().isSavingStateInClient(context)) {
            this.helper.saveSerializedViewInServletSession(context, serializedView);
        }
        return serializedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreStateFromMap(FacesContext context, Map<String, Object> states, UIComponent component) {
        if (states == null) {
            return;
        }
        try {
            Map facetMap;
            component.pushComponentToEL(context, component);
            Object state = states.get(component.getClientId());
            if (state != null) {
                if (state instanceof AttachedFullStateWrapper) {
                    return;
                }
                try {
                    component.restoreState(context, state);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error restoring component: " + component.getClientId(), e);
                }
            }
            if (component.getChildCount() > 0) {
                List children = component.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
            if (!(facetMap = component.getFacets()).isEmpty()) {
                for (Map.Entry entry : facetMap.entrySet()) {
                    UIComponent child = (UIComponent)entry.getValue();
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    static List<String> getClientIdsAdded(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_ADDED);
    }

    static void setClientsIdsAdded(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_ADDED, clientIdsList);
    }

    static List<String> getClientIdsRemoved(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_REMOVED);
    }

    static void setClientsIdsRemoved(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_REMOVED, clientIdsList);
    }

    private void registerOnAddRemoveList(String clientId) {
        UIViewRoot uiViewRoot = FacesContext.getCurrentInstance().getViewRoot();
        List<String> clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
        List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
        if (clientIdsRemoved == null) {
            clientIdsRemoved = new ArrayList<String>();
        }
        clientIdsRemoved.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
    }

    private void registerOnAddList(String clientId) {
        UIViewRoot uiViewRoot = FacesContext.getCurrentInstance().getViewRoot();
        List<String> clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateOnMap(FacesContext context, Map<String, Object> states, UIComponent component) {
        ComponentState componentAddedAfterBuildView = null;
        try {
            Object savedState;
            Map facetMap;
            component.pushComponentToEL(context, component);
            if (component.getChildCount() > 0) {
                String currentClientId = component.getClientId();
                List children = component.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (child == null || child.isTransient()) continue;
                    componentAddedAfterBuildView = (ComponentState)((Object)child.getAttributes().get(COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddRemoveList(child.getClientId());
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(child.getClientId());
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(child.getClientId());
                        }
                        this.ensureClearInitialState(child);
                        states.put(child.getClientId(), new AttachedFullStateWrapper(new Object[]{currentClientId, null, i, this.internalBuildTreeStructureToSave(child), child.processSaveState(context)}));
                        continue;
                    }
                    this.saveStateOnMap(context, states, child);
                }
            }
            if (!(facetMap = component.getFacets()).isEmpty()) {
                String currentClientId = component.getClientId();
                for (Map.Entry entry : facetMap.entrySet()) {
                    UIComponent child = (UIComponent)entry.getValue();
                    if (child == null || child.isTransient()) continue;
                    String facetName = (String)entry.getKey();
                    componentAddedAfterBuildView = (ComponentState)((Object)child.getAttributes().get(COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddRemoveList(child.getClientId());
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(child.getClientId());
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(child.getClientId());
                        }
                        this.ensureClearInitialState(child);
                        states.put(child.getClientId(), new AttachedFullStateWrapper(new Object[]{currentClientId, facetName, null, this.internalBuildTreeStructureToSave(child), child.processSaveState(context)}));
                        continue;
                    }
                    this.saveStateOnMap(context, states, child);
                }
            }
            if ((savedState = component.saveState(context)) != null) {
                states.put(component.getClientId(), savedState);
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    protected void ensureClearInitialState(UIComponent c) {
        c.clearInitialState();
        if (c.getChildCount() > 0) {
            for (UIComponent child : c.getChildren()) {
                this.ensureClearInitialState(child);
            }
        }
        if (c.getFacetCount() > 0) {
            for (UIComponent child : c.getFacets().values()) {
                this.ensureClearInitialState(child);
            }
        }
    }

    public void suscribeListeners(UIViewRoot uiViewRoot) {
        PostAddPreRemoveFromViewListener componentListener = new PostAddPreRemoveFromViewListener();
        uiViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)componentListener);
        uiViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)componentListener);
    }

    private void checkIds(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (existingIds.contains(id)) {
            throw new IllegalStateException("component with duplicate id \"" + id + "\" found");
        }
        existingIds.add(id);
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            this.checkIds(context, (UIComponent)children.next(), existingIds);
        }
    }

    private TreeStructComponent internalBuildTreeStructureToSave(UIComponent component) {
        Map facetMap;
        TreeStructComponent structComp = new TreeStructComponent(component.getClass().getName(), component.getId());
        if (component.getChildCount() > 0) {
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            for (UIComponent child : component.getChildren()) {
                if (child.isTransient()) continue;
                TreeStructComponent treeStructComponent = this.internalBuildTreeStructureToSave(child);
                structChildList.add(treeStructComponent);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (!(facetMap = component.getFacets()).isEmpty()) {
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            for (Map.Entry entry : facetMap.entrySet()) {
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    private UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp) {
        Object[] facetArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance(compClass);
        component.setId(compId);
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List childList = component.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.internalRestoreTreeStructure(childArray[i]);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map facetMap = component.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = this.internalRestoreTreeStructure(structChild);
                facetMap.put(facetName, child);
            }
        }
        return component;
    }

    public static class TreeStructComponent
    implements Serializable {
        private static final long serialVersionUID = 5069109074684737231L;
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }

    public static class PostAddPreRemoveFromViewListener
    implements SystemEventListener {
        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent;
        }

        public void processEvent(SystemEvent event) {
            UIComponent component = (UIComponent)event.getSource();
            if (component.isTransient()) {
                return;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (FaceletViewDeclarationLanguage.isRefreshingTransientBuild(facesContext)) {
                return;
            }
            if (event instanceof PostAddToViewEvent) {
                component.getAttributes().put(DefaultFaceletsStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADD);
            } else {
                if (FaceletViewDeclarationLanguage.isRemovingComponentBuild(facesContext)) {
                    return;
                }
                UIViewRoot uiViewRoot = facesContext.getViewRoot();
                List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
                if (clientIdsRemoved == null) {
                    clientIdsRemoved = new ArrayList<String>();
                }
                clientIdsRemoved.add(component.getClientId());
                DefaultFaceletsStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
            }
        }
    }
}

