/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.io.IOException;
import java.io.Writer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.view.facelets.util.FastWriter;

public final class StateWriter
extends Writer {
    private static final String CURRENT_WRITER_KEY = "org.apache.myfaces.view.facelets.StateWriter.CURRENT_WRITER";
    private int initialSize;
    private Writer out;
    private FastWriter fast;
    private boolean writtenState;

    public static StateWriter getCurrentInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (StateWriter)facesContext.getAttributes().get(CURRENT_WRITER_KEY);
    }

    private static void setCurrentInstance(StateWriter stateWriter) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (stateWriter == null) {
            facesContext.getAttributes().remove(CURRENT_WRITER_KEY);
        } else {
            facesContext.getAttributes().put(CURRENT_WRITER_KEY, stateWriter);
        }
    }

    public StateWriter(Writer initialOut, int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        this.initialSize = initialSize;
        this.out = initialOut;
        StateWriter.setCurrentInstance(this);
    }

    public void writingState() {
        if (!this.writtenState) {
            this.writtenState = true;
            this.fast = new FastWriter(this.initialSize);
            this.out = this.fast;
        }
    }

    public boolean isStateWritten() {
        return this.writtenState;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.out.write(cbuf);
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    public String getAndResetBuffer() {
        if (!this.writtenState) {
            throw new IllegalStateException("Did not write state;  no buffer is available");
        }
        String result = this.fast.toString();
        this.fast.reset();
        return result;
    }

    public void release() {
        StateWriter.setCurrentInstance(null);
    }
}

