/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

public final class CompositeComponentELUtils {
    public static final String CURRENT_COMPOSITE_COMPONENT_KEY = "org.apache.myfaces.compositecomponent.current";
    public static final String LOCATION_KEY = "org.apache.myfaces.compositecomponent.location";
    public static final Pattern CC_EXPRESSION_REGEX = Pattern.compile(".*[^\\w\\.]cc[^\\w].*");
    public static final Pattern CC_ATTRS_METHOD_EXPRESSION_REGEX = Pattern.compile("[^\\(]*[^\\w\\.\\(]cc\\.attrs\\.[^\\.]*(\\(.*)?");
    private static final String CC = "cc";
    private static final String CC_ATTRS = "cc.attrs";
    public static final String CC_FIND_COMPONENT_EXPRESSION = "oam.CC_FIND_COMPONENT_EXPRESSION";

    private CompositeComponentELUtils() {
    }

    public static UIComponent getCompositeComponentBasedOnLocation(FacesContext facesContext, Location location) {
        Location componentLocation;
        UIComponent currentComponent = UIComponent.getCurrentComponent((FacesContext)facesContext);
        if (currentComponent == null) {
            return null;
        }
        UIComponent currentCompositeComponent = UIComponent.getCurrentCompositeComponent((FacesContext)facesContext);
        if (currentCompositeComponent != null && (componentLocation = (Location)currentCompositeComponent.getAttributes().get(LOCATION_KEY)) != null && componentLocation.getPath().equals(location.getPath())) {
            return currentCompositeComponent;
        }
        UIComponent matchingCompositeComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, currentComponent);
        if (matchingCompositeComponent != null) {
            return matchingCompositeComponent;
        }
        if (currentCompositeComponent != null) {
            currentComponent = currentCompositeComponent;
        } else {
            boolean found = false;
            while (currentComponent != null && !found) {
                UIComponent foundComponent;
                String findComponentExpr = (String)currentComponent.getAttributes().get(CC_FIND_COMPONENT_EXPRESSION);
                if (findComponentExpr != null && (foundComponent = facesContext.getViewRoot().findComponent(findComponentExpr)) != null) {
                    Location foundComponentLocation = (Location)currentComponent.getAttributes().get(LOCATION_KEY);
                    if (foundComponentLocation != null && foundComponentLocation.getPath().equals(location.getPath())) {
                        return foundComponent;
                    }
                    while (foundComponent != null) {
                        Location componentLocation2 = (Location)foundComponent.getAttributes().get(LOCATION_KEY);
                        if (componentLocation2 != null && componentLocation2.getPath().equals(location.getPath())) {
                            return foundComponent;
                        }
                        foundComponent = UIComponent.getCompositeComponentParent((UIComponent)foundComponent);
                    }
                }
                if (UIComponent.isCompositeComponent((UIComponent)currentComponent)) {
                    found = true;
                    continue;
                }
                currentComponent = currentComponent.getParent();
            }
        }
        while (currentComponent != null) {
            Location componentLocation3 = (Location)currentComponent.getAttributes().get(LOCATION_KEY);
            if (componentLocation3 != null && componentLocation3.getPath().equals(location.getPath())) {
                return currentComponent;
            }
            currentComponent = UIComponent.getCompositeComponentParent((UIComponent)currentComponent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UIComponent lookForCompositeComponentOnStack(FacesContext facesContext, Location location, UIComponent currentComponent) {
        Location componentLocation;
        if (UIComponent.isCompositeComponent((UIComponent)currentComponent) && (componentLocation = (Location)currentComponent.getAttributes().get(LOCATION_KEY)) != null && componentLocation.getPath().equals(location.getPath())) {
            return currentComponent;
        }
        currentComponent.popComponentFromEL(facesContext);
        try {
            UIComponent c = UIComponent.getCurrentComponent((FacesContext)facesContext);
            if (c != null) {
                UIComponent uIComponent = CompositeComponentELUtils.lookForCompositeComponentOnStack(facesContext, location, c);
                return uIComponent;
            }
            UIComponent uIComponent = null;
            return uIComponent;
        }
        finally {
            currentComponent.pushComponentToEL(facesContext, currentComponent);
        }
    }

    public static void saveCompositeComponentForResolver(FacesContext facesContext, Location location) {
        UIComponent cc = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location);
        facesContext.getAttributes().put(CURRENT_COMPOSITE_COMPONENT_KEY, cc);
    }

    public static void removeCompositeComponentForResolver(FacesContext facesContext) {
        facesContext.getAttributes().remove(CURRENT_COMPOSITE_COMPONENT_KEY);
    }

    public static boolean isCompositeComponentExpression(String expression) {
        if (expression.contains(CC)) {
            return CC_EXPRESSION_REGEX.matcher(expression).matches();
        }
        return false;
    }

    public static boolean isCompositeComponentAttrsMethodExpression(String expression) {
        if (expression.contains(CC_ATTRS)) {
            return CC_ATTRS_METHOD_EXPRESSION_REGEX.matcher(expression).matches();
        }
        return false;
    }
}

