/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletContext;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletFactory;
import org.apache.myfaces.view.facelets.impl.FaceletCompositionContextImpl;

final class DefaultFacelet
extends AbstractFacelet {
    private static final Logger log = Logger.getLogger(DefaultFacelet.class.getName());
    private static final String APPLIED_KEY = "org.apache.myfaces.view.facelets.APPLIED";
    private final String _alias;
    private final ExpressionFactory _elFactory;
    private final DefaultFaceletFactory _factory;
    private final long _createTime;
    private final long _refreshPeriod;
    private final Map<String, URL> _relativePaths;
    private final FaceletHandler _root;
    private final URL _src;
    private final boolean _isBuildingCompositeComponentMetadata;

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, FaceletHandler root) {
        this._factory = factory;
        this._elFactory = el;
        this._src = src;
        this._root = root;
        this._alias = alias;
        this._createTime = System.currentTimeMillis();
        this._refreshPeriod = this._factory.getRefreshPeriod();
        this._relativePaths = Collections.synchronizedMap(new WeakHashMap());
        this._isBuildingCompositeComponentMetadata = false;
    }

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, FaceletHandler root, boolean isBuildingCompositeComponentMetadata) {
        this._factory = factory;
        this._elFactory = el;
        this._src = src;
        this._root = root;
        this._alias = alias;
        this._createTime = System.currentTimeMillis();
        this._refreshPeriod = this._factory.getRefreshPeriod();
        this._relativePaths = Collections.synchronizedMap(new WeakHashMap());
        this._isBuildingCompositeComponentMetadata = isBuildingCompositeComponentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FacesContext facesContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        FaceletCompositionContext myFaceletContext = null;
        boolean faceletCompositionContextInitialized = false;
        myFaceletContext = FaceletCompositionContext.getCurrentInstance(facesContext);
        if (myFaceletContext == null) {
            myFaceletContext = new FaceletCompositionContextImpl(this._factory, facesContext);
            myFaceletContext.init(facesContext);
            faceletCompositionContextInitialized = true;
        }
        DefaultFaceletContext ctx = new DefaultFaceletContext(facesContext, (AbstractFacelet)this, myFaceletContext);
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isUpdateFaceletContextKey()) {
            facesContext.getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctx);
        }
        try {
            boolean pushedUniqueIdVendor = false;
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                ctx.getFaceletCompositionContext().pushUniqueIdVendorToStack((UniqueIdVendor)parent);
                pushedUniqueIdVendor = true;
            }
            this.refresh(parent);
            myFaceletContext.markForDeletion(parent);
            this._root.apply((FaceletContext)ctx, parent);
            myFaceletContext.finalizeForDeletion(parent);
            this.markApplied(parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            if (faceletCompositionContextInitialized) {
                myFaceletContext.release(facesContext);
            }
        }
    }

    private final void refresh(UIComponent c) {
        if (this._refreshPeriod > 0L) {
            ApplyToken token;
            int sz = c.getChildCount();
            if (sz > 0) {
                UIComponent cc = null;
                List cl = c.getChildren();
                while (--sz >= 0) {
                    cc = (UIComponent)cl.get(sz);
                    if (cc.isTransient() || (token = (ApplyToken)cc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                    }
                    cl.remove(sz);
                }
            }
            if (c.getFacets().size() > 0) {
                Collection col = c.getFacets().values();
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    UIComponent fc = (UIComponent)itr.next();
                    if (fc.isTransient() || (token = (ApplyToken)fc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                    }
                    itr.remove();
                }
            }
        }
    }

    private final void markApplied(UIComponent parent) {
        if (this._refreshPeriod > 0L) {
            Iterator itr = parent.getFacetsAndChildren();
            ApplyToken token = new ApplyToken(this._alias, System.currentTimeMillis() + this._refreshPeriod);
            while (itr.hasNext()) {
                Map attr;
                UIComponent c = (UIComponent)itr.next();
                if (c.isTransient() || (attr = c.getAttributes()).containsKey(APPLIED_KEY)) continue;
                attr.put(APPLIED_KEY, token);
            }
        }
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this._elFactory;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    private URL getRelativePath(String path) throws IOException {
        URL url = this._relativePaths.get(path);
        if (url == null) {
            url = this._factory.resolveURL(this._src, path);
            this._relativePaths.put(path, url);
        }
        return url;
    }

    public URL getSource() {
        return this._src;
    }

    private void include(AbstractFaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        this.refresh(parent);
        if (MyfacesConfig.getCurrentInstance(ctx.getFacesContext().getExternalContext()).isUpdateFaceletContextKey()) {
            DefaultFaceletContext ctxWrapper = new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)this, false);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctxWrapper);
            this._root.apply((FaceletContext)ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctx);
        } else {
            this._root.apply((FaceletContext)new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)this, false), parent);
        }
        this.markApplied(parent);
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, String path) throws IOException, FacesException, FaceletException, ELException {
        URL url = this.getRelativePath(path);
        this.include(ctx, parent, url);
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, URL url) throws IOException, FacesException, FaceletException, ELException {
        DefaultFacelet f = (DefaultFacelet)this._factory.getFacelet(url);
        f.include(ctx, parent);
    }

    @Override
    public void applyCompositeComponent(AbstractFaceletContext ctx, UIComponent parent, Resource resource) throws IOException, FacesException, FaceletException, ELException {
        DefaultFacelet f = (DefaultFacelet)this._factory.getFacelet(resource.getURL());
        boolean pushedUniqueIdVendor = false;
        FaceletCompositionContext mctx = ctx.getFaceletCompositionContext();
        if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
            mctx.pushUniqueIdVendorToStack((UniqueIdVendor)parent);
            pushedUniqueIdVendor = true;
        }
        this.refresh(parent);
        mctx.markForDeletion(parent);
        if (MyfacesConfig.getCurrentInstance(ctx.getFacesContext().getExternalContext()).isUpdateFaceletContextKey()) {
            DefaultFaceletContext ctxWrapper = new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)f, true);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctxWrapper);
            f._root.apply((FaceletContext)ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctx);
        } else {
            f._root.apply((FaceletContext)new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)f, true), parent);
        }
        mctx.finalizeForDeletion(parent);
        this.markApplied(parent);
        if (pushedUniqueIdVendor) {
            ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
        }
    }

    public String toString() {
        return this._alias;
    }

    @Override
    public boolean isBuildingCompositeComponentMetadata() {
        return this._isBuildingCompositeComponentMetadata;
    }

    private static class ApplyToken
    implements Externalizable {
        public String _alias;
        public long _time;

        public ApplyToken() {
        }

        public ApplyToken(String alias, long time) {
            this._alias = alias;
            this._time = time;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._alias = in.readUTF();
            this._time = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._alias);
            out.writeLong(this._time);
        }
    }
}

