/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.Facelet;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.TemplateManager;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletContext;

public class TemplateContextImpl
extends TemplateContext {
    private final LinkedList<TemplateManager> _clients = new LinkedList();
    private TemplateManager _compositeComponentClient;

    @Override
    public TemplateManager popClient() {
        return this._clients.removeFirst();
    }

    @Override
    public void pushClient(AbstractFacelet owner, TemplateClient client) {
        this._clients.addFirst(new TemplateManagerImpl(owner, client, true));
    }

    @Override
    public TemplateManager popExtendedClient() {
        return this._clients.removeLast();
    }

    @Override
    public void extendClient(AbstractFacelet owner, TemplateClient client) {
        this._clients.addLast(new TemplateManagerImpl(owner, client, false));
    }

    @Override
    public boolean includeDefinition(FaceletContext ctx, Facelet owner, UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        boolean found = false;
        Iterator itr = this._clients.iterator();
        while (itr.hasNext() && !found) {
            TemplateManager client = (TemplateManager)itr.next();
            if (client.equals(owner)) continue;
            found = ((TemplateManagerImpl)client).apply(ctx, parent, name);
        }
        return found;
    }

    @Override
    public TemplateManager getCompositeComponentClient() {
        return this._compositeComponentClient;
    }

    @Override
    public void setCompositeComponentClient(TemplateManager compositeComponentClient) {
        this._compositeComponentClient = compositeComponentClient;
    }

    private static final class TemplateManagerImpl
    extends TemplateManager
    implements TemplateClient {
        private final AbstractFacelet _owner;
        private final TemplateClient _target;
        private final boolean _root;
        private final Set<String> _names = new HashSet<String>();

        public TemplateManagerImpl(AbstractFacelet owner, TemplateClient target, boolean root) {
            this._owner = owner;
            this._target = target;
            this._root = root;
        }

        @Override
        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            String testName;
            String string = testName = name != null ? name : "facelets._NULL_DEF_";
            if (this._names.contains(testName)) {
                return false;
            }
            this._names.add(testName);
            boolean found = false;
            if (MyfacesConfig.getCurrentInstance(ctx.getFacesContext().getExternalContext()).isUpdateFaceletContextKey()) {
                DefaultFaceletContext actx = new DefaultFaceletContext((DefaultFaceletContext)ctx, this._owner, false);
                ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", actx);
                found = this._target.apply(actx, parent, name);
                ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", ctx);
            } else {
                found = this._target.apply(new DefaultFaceletContext((DefaultFaceletContext)ctx, this._owner, false), parent, name);
            }
            this._names.remove(testName);
            return found;
        }

        public boolean equals(Object o) {
            return this._owner == o || this._target == o;
        }

        public boolean isRoot() {
            return this._root;
        }
    }
}

