/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.FacetHandler;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TextHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentRule;
import org.apache.myfaces.view.facelets.tag.composite.CompositeMetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.composite.InsertChildrenHandler;
import org.apache.myfaces.view.facelets.tag.composite.InsertFacetHandler;
import org.apache.myfaces.view.facelets.tag.composite.RetargetMethodExpressionRule;
import org.apache.myfaces.view.facelets.tag.jsf.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentBuilderHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.ValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;
import org.apache.myfaces.view.facelets.tag.ui.DecorateHandler;
import org.apache.myfaces.view.facelets.tag.ui.IncludeHandler;
import org.apache.myfaces.view.facelets.tag.ui.InsertHandler;

public class CompositeComponentResourceTagHandler
extends ComponentHandler
implements ComponentBuilderHandler,
TemplateClient {
    private final Resource _resource;
    private Metadata _mapper;
    private Class<?> _lastType = Object.class;
    protected volatile Map<String, FaceletHandler> _facetHandlersMap;
    protected final Collection<FaceletHandler> _componentHandlers;
    protected final Collection<FaceletHandler> _facetHandlers;

    public CompositeComponentResourceTagHandler(ComponentConfig config, Resource resource) {
        super(config);
        this._resource = resource;
        this._facetHandlers = TagHandlerUtils.findNextByType(this.nextHandler, FacetHandler.class, InsertFacetHandler.class);
        this._componentHandlers = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, InsertChildrenHandler.class, InsertHandler.class, DecorateHandler.class, IncludeHandler.class, TextHandler.class);
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        FacesContext facesContext = ctx.getFacesContext();
        UIComponent component = facesContext.getApplication().createComponent(facesContext, this._resource);
        if (!facesContext.isProjectStage(ProjectStage.Production)) {
            BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                TagAttribute attrValue;
                ValueExpression ve = (ValueExpression)propertyDescriptor.getValue("required");
                if (ve == null) continue;
                Object value = ve.getValue(facesContext.getELContext());
                Boolean required = null;
                required = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.getBoolean(value.toString()));
                if (required == null || !required.booleanValue() || (attrValue = this.tag.getAttributes().get(propertyDescriptor.getName())) != null) continue;
                throw new TagException(this.tag, "Attribute '" + propertyDescriptor.getName() + "' is required");
            }
        }
        return component;
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException {
        this.applyNextHandlerIfNotApplied(ctx, c);
        this.applyCompositeComponentFacelet(ctx, c);
        if (ComponentHandler.isNew((UIComponent)c)) {
            FacesContext facesContext = ctx.getFacesContext();
            ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            List<AttachedObjectHandler> handlers = mctx.getAttachedObjectHandlers(c);
            if (handlers != null) {
                vdl.retargetAttachedObjects(facesContext, c, handlers);
                mctx.removeAttachedObjectHandlers(c);
            }
            vdl.retargetMethodExpressions(facesContext, c);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
                c.markInitialState();
                c.getFacet("javax.faces.component.COMPOSITE_FACET_NAME").markInitialState();
            }
        }
    }

    protected void applyNextHandlerIfNotApplied(FaceletContext ctx, UIComponent c) throws IOException {
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)c.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        boolean insertChildrenUsed = beanDescriptor.getValue(InsertChildrenHandler.INSERT_CHILDREN_USED) != null;
        List insertFacetList = (List)beanDescriptor.getValue(InsertFacetHandler.INSERT_FACET_USED);
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)this.nextHandler).getHandlers()) {
                if (handler instanceof FacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((FacetHandler)handler).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (handler instanceof InsertFacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((InsertFacetHandler)handler).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (insertChildrenUsed) {
                    if (handler instanceof ComponentHandler || handler instanceof InsertChildrenHandler || handler instanceof InsertHandler || handler instanceof DecorateHandler || handler instanceof IncludeHandler || handler instanceof TextHandler) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                handler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof FacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((FacetHandler)this.nextHandler).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof InsertFacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((InsertFacetHandler)this.nextHandler).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (insertChildrenUsed) {
            if (!(this.nextHandler instanceof ComponentHandler || this.nextHandler instanceof InsertChildrenHandler || this.nextHandler instanceof InsertHandler || this.nextHandler instanceof DecorateHandler || this.nextHandler instanceof IncludeHandler || this.nextHandler instanceof TextHandler)) {
                this.nextHandler.apply(ctx, c);
            }
        } else {
            this.nextHandler.apply(ctx, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCompositeComponentFacelet(FaceletContext faceletContext, UIComponent compositeComponentBase) throws IOException {
        Iterator<AjaxHandler> it;
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(faceletContext);
        AbstractFaceletContext actx = (AbstractFaceletContext)faceletContext;
        UIPanel compositeFacetPanel = (UIPanel)compositeComponentBase.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
        if (compositeFacetPanel == null) {
            compositeFacetPanel = (UIPanel)faceletContext.getFacesContext().getApplication().createComponent("javax.faces.Panel");
            compositeComponentBase.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", compositeFacetPanel);
            UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
            if (uniqueIdVendor == null) {
                uniqueIdVendor = ComponentSupport.getViewRoot(faceletContext, compositeComponentBase);
            }
            if (uniqueIdVendor != null) {
                String uid = uniqueIdVendor.createUniqueId(faceletContext.getFacesContext(), null);
                compositeFacetPanel.setId(uid);
            }
        }
        if ((it = ((AbstractFaceletContext)faceletContext).getAjaxHandlers()) != null) {
            while (it.hasNext()) {
                mctx.addAttachedObjectHandler(compositeComponentBase, (AttachedObjectHandler)it.next());
            }
        }
        VariableMapper orig = faceletContext.getVariableMapper();
        try {
            faceletContext.setVariableMapper((VariableMapper)new VariableMapperWrapper(orig));
            actx.pushCompositeComponentClient(this);
            actx.applyCompositeComponent((UIComponent)compositeFacetPanel, this._resource);
        }
        finally {
            actx.popCompositeComponentClient();
            faceletContext.setVariableMapper(orig);
        }
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            UIComponent component = (UIComponent)instance;
            Class<?> type = instance.getClass();
            if (this._mapper == null || !this._lastType.equals(type)) {
                this._lastType = type;
                BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("javax.faces.component.BEANINFO_KEY");
                this._mapper = this.createMetaRuleset(type, beanInfo).finish();
            }
            this._mapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createMetaRuleset(Class<?> type, BeanInfo beanInfo) {
        CompositeMetaRulesetImpl m = new CompositeMetaRulesetImpl(this.getTag(), type, beanInfo);
        m.ignore("binding").ignore("id");
        m.addRule(CompositeComponentRule.Instance);
        m.addRule(RetargetMethodExpressionRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            FaceletHandler handler;
            if (this._facetHandlers == null || this._facetHandlers.isEmpty()) {
                return true;
            }
            if (this._facetHandlersMap == null) {
                HashMap<String, FaceletHandler> map = new HashMap<String, FaceletHandler>();
                for (FaceletHandler handler2 : this._facetHandlers) {
                    if (handler2 instanceof FacetHandler) {
                        map.put(((FacetHandler)handler2).getFacetName(ctx), handler2);
                        continue;
                    }
                    if (!(handler2 instanceof InsertFacetHandler)) continue;
                    map.put(((InsertFacetHandler)handler2).getFacetName(ctx), handler2);
                }
                this._facetHandlersMap = map;
            }
            if ((handler = this._facetHandlersMap.get(name)) != null) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                TemplateContext itc = actx.popTemplateContext();
                try {
                    handler.apply(ctx, parent);
                }
                finally {
                    actx.pushTemplateContext(itc);
                }
                return true;
            }
            return true;
        }
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        TemplateContext itc = actx.popTemplateContext();
        try {
            for (FaceletHandler handler : this._componentHandlers) {
                handler.apply(ctx, parent);
            }
        }
        finally {
            actx.pushTemplateContext(itc);
        }
        return true;
    }
}

