/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.validation.groups.Default;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.jsf.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentBuilderHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.RelocatableResourceHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

public class ComponentTagHandlerDelegate
extends TagHandlerDelegate {
    private static final Logger log = Logger.getLogger(ComponentTagHandlerDelegate.class.getName());
    private final ComponentHandler _delegate;
    private final String _componentType;
    private final TagAttribute _id;
    private final String _rendererType;
    private final ComponentBuilderHandler _componentBuilderHandlerDelegate;
    private final RelocatableResourceHandler _relocatableResourceHandler;
    private boolean fullyRestoreDynamicComponent = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext()).isFullyRestoreDynamicComponent();

    public ComponentTagHandlerDelegate(ComponentHandler delegate) {
        ComponentHandler handler = this._delegate = delegate;
        boolean found = false;
        while (handler != null && !found) {
            if (handler instanceof ComponentBuilderHandler) {
                found = true;
                continue;
            }
            if (handler instanceof FacesWrapper) {
                handler = (ComponentHandler)((FacesWrapper)handler).getWrapped();
                continue;
            }
            handler = null;
        }
        this._componentBuilderHandlerDelegate = found ? (ComponentBuilderHandler)handler : null;
        handler = this._delegate;
        found = false;
        while (handler != null && !found) {
            if (handler instanceof RelocatableResourceHandler) {
                found = true;
                continue;
            }
            if (handler instanceof FacesWrapper) {
                handler = (ComponentHandler)((FacesWrapper)handler).getWrapped();
                continue;
            }
            handler = null;
        }
        this._relocatableResourceHandler = found ? (RelocatableResourceHandler)handler : null;
        ComponentConfig delegateComponentConfig = delegate.getComponentConfig();
        this._componentType = delegateComponentConfig.getComponentType();
        this._rendererType = delegateComponentConfig.getRendererType();
        this._id = delegate.getTagAttribute("id");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null) {
            throw new TagException(this._delegate.getTag(), "Parent UIComponent was null");
        }
        FacesContext facesContext = ctx.getFacesContext();
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this._delegate.getTagId());
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        UIComponent c = null;
        c = this._relocatableResourceHandler != null ? this._relocatableResourceHandler.findChildByTagId(ctx, parent, id) : ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._delegate.getTag() + " Component[" + id + "] Found, marking children for cleanup");
            }
            mctx.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._delegate.getTag() + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this._delegate.setAttributes(ctx, (Object)c);
            c.getAttributes().put("org.apache.myfaces.view.facelets.MARK_ID", id);
            if (facesContext.isProjectStage(ProjectStage.Development)) {
                c.getAttributes().put("javax.faces.component.VIEW_LOCATION_KEY", this._delegate.getTag().getLocation());
            }
            if (this._id != null) {
                c.setId(this._id.getValue(ctx));
            } else {
                UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
                if (uniqueIdVendor == null && (uniqueIdVendor = facesContext.getViewRoot()) == null) {
                    uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
                }
                if (uniqueIdVendor != null) {
                    String uid = uniqueIdVendor.createUniqueId(facesContext, id);
                    c.setId(uid);
                }
            }
            if (this._rendererType != null) {
                c.setRendererType(this._rendererType);
            }
            this._delegate.onComponentCreated(ctx, c, parent);
        }
        c.pushComponentToEL(facesContext, c);
        if (c instanceof UniqueIdVendor) {
            mctx.pushUniqueIdVendorToStack((UniqueIdVendor)c);
        }
        this._delegate.applyNextHandler(ctx, c);
        boolean oldProcessingEvents = facesContext.isProcessingEvents();
        if (componentFound) {
            mctx.finalizeForDeletion(c);
            if (mctx.isRefreshingTransientBuild()) {
                facesContext.setProcessingEvents(false);
            }
            if (facetName == null) {
                parent.getChildren().remove(c);
            } else {
                ComponentSupport.removeFacet(ctx, parent, c, facetName);
            }
            if (mctx.isRefreshingTransientBuild()) {
                facesContext.setProcessingEvents(oldProcessingEvents);
            }
        }
        if (!componentFound) {
            Iterator<AjaxHandler> it;
            if (c instanceof ClientBehaviorHolder && !UIComponent.isCompositeComponent((UIComponent)c) && (it = ((AbstractFaceletContext)ctx).getAjaxHandlers()) != null) {
                while (it.hasNext()) {
                    it.next().applyAttachedObject(facesContext, c);
                }
            }
            if (c instanceof EditableValueHolder) {
                this.addDefaultValidators(mctx, facesContext, (EditableValueHolder)c);
            }
        }
        this._delegate.onComponentPopulated(ctx, c, parent);
        if (componentFound && mctx.isRefreshingTransientBuild()) {
            facesContext.setProcessingEvents(false);
        }
        if (facetName == null) {
            parent.getChildren().add(c);
        } else {
            ComponentSupport.addFacet(ctx, parent, c, facetName);
        }
        if (componentFound && mctx.isRefreshingTransientBuild()) {
            facesContext.setProcessingEvents(oldProcessingEvents);
        }
        if (c instanceof UniqueIdVendor) {
            mctx.popUniqueIdVendorToStack();
        }
        c.popComponentFromEL(facesContext);
        if (mctx.isMarkInitialState()) {
            c.markInitialState();
        }
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        if (this._componentBuilderHandlerDelegate != null) {
            return this._componentBuilderHandlerDelegate.createComponent(ctx);
        }
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this._delegate.getBinding() != null) {
            ValueExpression ve = this._delegate.getBinding().getValueExpression(ctx, Object.class);
            c = this._rendererType == null ? app.createComponent(ve, faces, this._componentType) : app.createComponent(ve, faces, this._componentType, this._rendererType);
            if (c != null) {
                c.setValueExpression("binding", ve);
                if (this.fullyRestoreDynamicComponent && (c.getChildCount() > 0 || c.getFacetCount() > 0)) {
                    c.getAttributes().put("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW", ComponentState.REMOVE_ADD);
                }
            }
        } else {
            c = this._rendererType == null ? app.createComponent(this._componentType) : app.createComponent(faces, this._componentType, this._rendererType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this._id != null) {
            return this._id.getValue(ctx);
        }
        return ctx.generateUniqueId(this._delegate.getTagId());
    }

    public MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl m = new MetaRulesetImpl(this._delegate.getTag(), type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    private void addDefaultValidators(FaceletCompositionContext mctx, FacesContext context, EditableValueHolder component) {
        Iterator<String> enclosingValidatorIds;
        Map defaultValidators = context.getApplication().getDefaultValidatorInfo();
        if (defaultValidators != null && defaultValidators.size() != 0) {
            for (Map.Entry entry : defaultValidators.entrySet()) {
                this.addDefaultValidator(mctx, context, component, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((enclosingValidatorIds = mctx.getEnclosingValidatorIds()) != null) {
            while (enclosingValidatorIds.hasNext()) {
                String validatorId = enclosingValidatorIds.next();
                if (defaultValidators.containsKey(validatorId)) continue;
                this.addDefaultValidator(mctx, context, component, validatorId, null);
            }
        }
    }

    private void addDefaultValidator(FaceletCompositionContext mctx, FacesContext context, EditableValueHolder component, String validatorId, String validatorClassName) {
        BeanValidator beanValidator;
        String validationGroups;
        Validator enclosingValidator = null;
        if (validatorClassName == null) {
            enclosingValidator = context.getApplication().createValidator(validatorId);
            validatorClassName = enclosingValidator.getClass().getName();
        }
        Validator validator = null;
        for (Validator v : component.getValidators()) {
            if (!v.getClass().getName().equals(validatorClassName)) continue;
            validator = v;
            break;
        }
        if (validator == null) {
            if (this.shouldAddDefaultValidator(mctx, context, component, validatorId)) {
                validator = enclosingValidator != null ? enclosingValidator : context.getApplication().createValidator(validatorId);
                component.addValidator(validator);
            } else {
                return;
            }
        }
        if (validator instanceof BeanValidator && ((validationGroups = (beanValidator = (BeanValidator)validator).getValidationGroups()) == null || validationGroups.matches("^[\\W,]*$"))) {
            String stackGroup = mctx.getFirstValidationGroupFromStack();
            validationGroups = stackGroup != null ? stackGroup : Default.class.getName();
            beanValidator.setValidationGroups(validationGroups);
        }
    }

    private boolean shouldAddDefaultValidator(FaceletCompositionContext mctx, FacesContext facesContext, EditableValueHolder component, String validatorId) {
        Iterator<String> it;
        List exclusionList = (List)((UIComponent)component).getAttributes().get("org.apache.myfaces.validator.VALIDATOR_ID_EXCLUSION_LIST");
        if (exclusionList != null) {
            for (String excludedId : exclusionList) {
                if (!excludedId.equals(validatorId)) continue;
                return false;
            }
        }
        if ((it = mctx.getExcludedValidatorIds()) != null) {
            while (it.hasNext()) {
                String excludedId;
                excludedId = it.next();
                if (!excludedId.equals(validatorId)) continue;
                return false;
            }
        }
        if (validatorId.equals("javax.faces.Bean") && !ExternalSpecifications.isBeanValidationAvailable()) {
            log.log(Level.WARNING, "Bean validation is not available on the classpath, thus the BeanValidator will not be added for the component " + component);
            return false;
        }
        return true;
    }
}

