/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public final class Classpath {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private Classpath() {
    }

    public static URL[] search(String prefix, String suffix) throws IOException {
        return Classpath.search(ClassUtils.getContextClassLoader(), prefix, suffix);
    }

    public static URL[] search(ClassLoader loader, String prefix, String suffix) throws IOException {
        LinkedHashSet<URL> all = new LinkedHashSet<URL>();
        Classpath._searchResource(all, loader, prefix, prefix, suffix);
        Classpath._searchResource(all, loader, prefix + "MANIFEST.MF", prefix, suffix);
        URL[] urlArray = all.toArray(new URL[all.size()]);
        return urlArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _searchResource(Set<URL> result, ClassLoader loader, String resource, String prefix, String suffix) throws IOException {
        Enumeration<URL> urls = loader.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setDefaultUseCaches(false);
            JarFile jar = null;
            try {
                jar = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : Classpath._getAlternativeJarFile(url);
                if (jar != null) {
                    Classpath._searchJar(loader, result, jar, prefix, suffix);
                    continue;
                }
                if (Classpath._searchDir(result, new File(URLDecoder.decode(url.getFile(), "UTF-8")), suffix)) continue;
                Classpath._searchFromURL(result, prefix, suffix, url);
            }
            catch (Throwable e) {}
            continue;
            finally {
                if (jar == null) continue;
                jar.close();
            }
        }
    }

    private static boolean _searchDir(Set<URL> result, File dir, String suffix) throws IOException {
        File[] dirFiles;
        boolean dirExists = false;
        if (System.getSecurityManager() != null) {
            final File finalDir = dir;
            dirExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return finalDir.exists();
                }
            });
        } else {
            dirExists = dir.exists();
        }
        if (dirExists && dir.isDirectory() && (dirFiles = dir.listFiles()) != null) {
            for (File file : dirFiles) {
                String path = file.getAbsolutePath();
                if (file.isDirectory()) {
                    Classpath._searchDir(result, file, suffix);
                    continue;
                }
                if (!path.endsWith(suffix)) continue;
                result.add(file.toURI().toURL());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _searchFromURL(Set<URL> result, String prefix, String suffix, URL url) throws IOException {
        boolean done = false;
        InputStream is = Classpath._getInputStream(url);
        if (is != null) {
            try (ZipInputStream zis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);){
                ZipEntry entry = zis.getNextEntry();
                boolean bl = done = entry != null;
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.endsWith(suffix)) {
                        result.add(new URL(url.toExternalForm() + entryName));
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Exception zis2) {
                // empty catch block
            }
        }
        if (!done && prefix.length() > 0) {
            String urlString = url.toExternalForm() + "/";
            String[] split = prefix.split("/");
            prefix = Classpath._join(split, true);
            String end = Classpath._join(split, false);
            url = new URL(urlString.substring(0, urlString.lastIndexOf(end)));
            Classpath._searchFromURL(result, prefix, suffix, url);
        }
    }

    private static String _join(String[] tokens, boolean excludeLast) {
        StringBuilder join = new StringBuilder();
        int length = tokens.length - (excludeLast ? 1 : 0);
        for (int i = 0; i < length; ++i) {
            join.append(tokens[i]).append("/");
        }
        return join.toString();
    }

    private static InputStream _getInputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static JarFile _getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            jarFileUrl = Classpath.decodeFilesystemUrl(jarFileUrl);
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    private static void _searchJar(ClassLoader loader, Set<URL> result, JarFile file, String prefix, String suffix) throws IOException {
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            try {
                String name = e.nextElement().getName();
                if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                Enumeration<URL> e2 = loader.getResources(name);
                while (e2.hasMoreElements()) {
                    result.add(e2.nextElement());
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String decodeFilesystemUrl(String url) {
        String decoded = url;
        if (url != null && url.indexOf(37) >= 0) {
            int n = url.length();
            StringBuffer buffer = new StringBuffer();
            ByteBuffer bytes = ByteBuffer.allocate(n);
            int i = 0;
            while (i < n) {
                if (url.charAt(i) == '%') {
                    try {
                        do {
                            byte octet = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                            bytes.put(octet);
                        } while ((i += 3) < n && url.charAt(i) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (bytes.position() <= 0) continue;
                        bytes.flip();
                        buffer.append(UTF8.decode(bytes).toString());
                        bytes.clear();
                        continue;
                    }
                }
                buffer.append(url.charAt(i++));
            }
            decoded = buffer.toString();
        }
        return decoded;
    }
}

