/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.webcontainerext.JSPExtensionFactory;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class InjectionServiceImpl
implements WebAppInjectionClassListCollaborator {
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    protected static final Level logLevel = Level.FINEST;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.InjectionServiceImpl";
    static final long serialVersionUID = 459272882767715406L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InjectionServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JspCoreException.class})
    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> result;
        block10: {
            JspXmlExtConfig jspConfig;
            WebAppConfiguration webAppConfiguration;
            block8: {
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.entering(CLASS_NAME, "getInjectionClasses", new Object[]{moduleContainer});
                }
                result = new ArrayList<String>();
                webAppConfiguration = null;
                jspConfig = null;
                try {
                    webAppConfiguration = (WebAppConfiguration)moduleContainer.adapt(WebAppConfig.class);
                    jspConfig = (JspXmlExtConfig)moduleContainer.adapt(JspXmlExtConfig.class);
                }
                catch (UnableToAdaptException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                    logger.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "exception getting injection classes for jsp", e);
                }
            }
            if (jspConfig != null) {
                Map tagLibs = jspConfig.getTagLibMap();
                JspOptions options = jspConfig.getJspOptions();
                if (tagLibs != null) {
                    ArrayList<String> arrayList;
                    block9: {
                        try {
                            GlobalTagLibraryCache globalCache = JSPExtensionFactory.getGlobalTagLibraryCache();
                            Map globalTagLibMap = globalCache.getGlobalTagLibMapForWebApp(moduleContainer, jspConfig);
                            TagLibraryCache tagLibCacheList = new TagLibraryCache(moduleContainer, tagLibs, options, null, (Map<String, Object>)globalTagLibMap, globalCache.getImplicitTagLibPrefixMap(), globalCache.getOptimizedTagConfigMap(), webAppConfiguration);
                            List<String> jspListeners = tagLibCacheList.getEventListenerList();
                            result.addAll(jspListeners);
                            List<String> tags = tagLibCacheList.getTagsList();
                            result.addAll(tags);
                            arrayList = result;
                            if (logger == null || !logger.isLoggable(Level.FINER)) break block9;
                        }
                        catch (JspCoreException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block10;
                            logger.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "exception getting injection classes for jsp", e);
                        }
                        arrayList = arrayList;
                        logger.exiting(CLASS_NAME, "getInjectionClasses", arrayList);
                    }
                    return arrayList;
                }
            }
        }
        ArrayList<String> arrayList = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "getInjectionClasses", arrayList);
        }
        return arrayList;
    }
}

