/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive;

import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import java.io.File;
import java.io.IOException;

public class FileEntryConfig
implements ArchiveEntryConfig {
    private final String entryPath;
    private final File source;

    public FileEntryConfig(String entryPath, File source) {
        entryPath = FileUtils.normalizeEntryPath(entryPath);
        this.entryPath = entryPath.equals("") || entryPath.endsWith("/") ? entryPath + source.getName() : entryPath;
        if (!source.exists()) {
            throw new IllegalArgumentException("The source does not exist.");
        }
        if (!source.isFile()) {
            throw new IllegalArgumentException("The source is not a file.");
        }
        this.source = source;
    }

    @Override
    public String getEntryPath() {
        return this.entryPath;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public void configure(Archive archive) throws IOException {
        archive.addFileEntry(this.entryPath, this.source);
    }
}

