/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object.hpel;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.websphere.logging.hpel.LogRecordContext;
import java.util.HashMap;
import java.util.Map;

public class LogRecordStack {
    private static final ThreadLocal<StackInfo> MDC = new ThreadLocal();

    public static StackInfo getStack() {
        StackInfo result = MDC.get();
        return result == null ? new StackInfo() : result;
    }

    public static int getThreadID() {
        StackInfo result = MDC.get();
        return result == null ? HpelHelper.getIntThreadId() : result.threadId;
    }

    public static Map<String, String> getExtensions() {
        StackInfo result = MDC.get();
        if (result == null) {
            return StackInfo.collectExtensions();
        }
        return result.extensions;
    }

    public static void setStack(StackInfo stack) {
        MDC.set(stack);
    }

    public static void clear() {
        MDC.remove();
    }

    public static class StackInfo {
        private final Map<String, String> extensions = StackInfo.collectExtensions();
        private final int threadId = HpelHelper.getIntThreadId();

        private static Map<String, String> collectExtensions() {
            HashMap<String, String> extensions = new HashMap<String, String>();
            LogRecordContext.getExtensions(extensions);
            return extensions;
        }
    }
}

