/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.ejs.ras.TrLevelConstants;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceStateChangeListener;
import com.ibm.ws.kernel.boot.logging.WsLogManager;
import com.ibm.ws.logging.internal.StackFinder;
import com.ibm.ws.logging.internal.TrSharedSecrets;
import com.ibm.ws.logging.internal.WsLogRecord;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WsLogger
extends Logger
implements TraceStateChangeListener {
    private String ivCachedResourceBundleName = null;
    private ResourceBundle ivCachedResourceBundle = null;
    private String ivComponent;
    private String ivOrganization;
    private String ivProduct;
    private int ivMinimumLocalizationLevelIntValue = TrLevelConstants.MIN_LOCALIZATION.intValue();
    private TraceComponent ivTC;
    public static final ThreadLocal<TraceComponent> loggerRegistrationComponent = new ThreadLocal();

    public WsLogger(String name, Class<?> c, String resourceBundleName) {
        super(name, resourceBundleName);
        if (resourceBundleName != null && !resourceBundleName.equals("")) {
            this.ivCachedResourceBundleName = resourceBundleName;
            this.ivCachedResourceBundle = this.getResourceBundle(resourceBundleName);
        }
        this.ivTC = loggerRegistrationComponent.get();
        if (this.ivTC == null) {
            this.registerTraceComponent(name, c, resourceBundleName);
        }
        LogManager.getLogManager().addLogger(this);
    }

    public void setMinimumLocalizationLevel(Level level) {
        if (level == null) {
            return;
        }
        this.ivMinimumLocalizationLevelIntValue = level.intValue();
    }

    @Override
    public void log(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Filter f = this.getFilter();
        if (this.isLoggable(logRecord.getLevel()) && (f == null || f.isLoggable(logRecord))) {
            logRecord.getSourceClassName();
            super.log(logRecord);
        }
    }

    private LogRecord createLogRecord(Level level, String msg, Object[] params, String sourceClassName, String sourceMethodName, String resourceBundleName, Throwable thrown) {
        ResourceBundle resourceBundle = null;
        if (level.intValue() >= this.ivMinimumLocalizationLevelIntValue) {
            if (null == this.ivCachedResourceBundle) {
                this.ivCachedResourceBundle = super.getResourceBundle();
                this.ivCachedResourceBundleName = super.getResourceBundleName();
            }
            if (resourceBundleName == null) {
                resourceBundleName = this.computeResourceBundleName();
            }
            if (resourceBundleName != null) {
                resourceBundle = resourceBundleName.equals(this.ivCachedResourceBundleName) ? this.ivCachedResourceBundle : this.getResourceBundle(resourceBundleName);
            }
            if (null == resourceBundle && null != sourceClassName) {
                try {
                    Class<?> source = Class.forName(sourceClassName);
                    resourceBundle = ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), source.getClassLoader());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.createWsLogRecord(level, msg, params, sourceClassName, sourceMethodName, resourceBundleName, resourceBundle, thrown);
    }

    private WsLogRecord createWsLogRecord(Level level, String msg, Object[] params, String sourceClassName, String sourceMethodName, String resourceBundleName, ResourceBundle resourceBundle, Throwable thrown) {
        WsLogRecord logRecord = new WsLogRecord(level, msg);
        if (params != null) {
            logRecord.setParameters(params);
            if (params.length > 0 && params[0] != null && Byte.TYPE.equals(params[0].getClass().getComponentType())) {
                logRecord.setRawData((byte[])params[0]);
            }
        }
        if (sourceClassName != null) {
            logRecord.setSourceClassName(sourceClassName);
        }
        if (sourceMethodName != null) {
            logRecord.setSourceMethodName(sourceMethodName);
        }
        if (resourceBundleName != null) {
            logRecord.setResourceBundleName(resourceBundleName);
        }
        if (resourceBundle != null) {
            logRecord.setResourceBundle(resourceBundle);
        }
        if (thrown != null) {
            logRecord.setThrown(thrown);
        }
        if (this.getName() != null) {
            logRecord.setLoggerName(this.getName());
        }
        if (this.getOrganization() != null) {
            logRecord.setOrganization(this.getOrganization());
        }
        if (this.getProduct() != null) {
            logRecord.setProduct(this.getProduct());
        }
        if (this.getComponent() != null) {
            logRecord.setComponent(this.getComponent());
        }
        LogRecordContext.getExtensions(logRecord.getExtensions());
        logRecord.setTraceClass(this.ivTC.getTraceClass());
        return logRecord;
    }

    @Override
    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, null, null, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            Object[] params = new Object[]{param1};
            LogRecord logRecord = this.createLogRecord(level, msg, params, null, null, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, params, null, null, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, null, null, null, thrown);
            this.log(logRecord);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            Object[] params = new Object[]{param1};
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, null, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, null, thrown);
            this.log(logRecord);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            Object[] params = new Object[]{param1};
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, params, sourceClass, sourceMethod, bundleName, null);
            this.log(logRecord);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, msg, null, sourceClass, sourceMethod, bundleName, thrown);
            this.log(logRecord);
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{param1};
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(Level.FINER)) {
            String msg = "ENTRY";
            if (params != null) {
                StringBuilder sb = new StringBuilder(msg);
                for (int i = 0; i < params.length; ++i) {
                    sb.append(" {").append(i).append("}");
                }
                msg = sb.toString();
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{result};
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", params);
        }
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord logRecord = this.createLogRecord(Level.FINER, "THROW", null, sourceClass, sourceMethod, null, thrown);
            this.log(logRecord);
        }
    }

    @Override
    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, msg);
        }
    }

    @Override
    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg);
        }
    }

    @Override
    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, msg);
        }
    }

    @Override
    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg);
        }
    }

    @Override
    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, msg);
        }
    }

    @Override
    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, msg);
        }
    }

    private ResourceBundle getResourceBundle(String name) {
        if (this.ivTC != null) {
            try {
                return TraceNLS.getResourceBundle(this.ivTC.getClass(), name, Locale.getDefault());
            }
            catch (MissingResourceException missingResourceException) {
            }
        } else {
            try {
                return TraceNLS.getResourceBundle(null, name, Locale.getDefault());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private String computeResourceBundleName() {
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            String name = logger.getResourceBundleName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private void registerTraceComponent(String name, Class<?> c, String resourceBundleName) {
        if (name != null && name.length() > 0) {
            StackFinder finder;
            if (c == null && (finder = StackFinder.getInstance()) != null) {
                c = finder.matchCaller(name);
            }
            this.ivTC = c != null ? Tr.register(name, c, name, resourceBundleName) : Tr.register(name, null, name, resourceBundleName);
            this.ivTC.setLoggerForCallback(this);
            if (!WsLogManager.isConfiguredByLoggingProperties()) {
                this.traceStateChanged();
            }
        }
    }

    public void addGroup(String group) {
        TrSharedSecrets.getInstance().addGroup(this.ivTC, group);
    }

    @Override
    public void traceStateChanged() {
        final Level rasLevel = this.ivTC.getLoggerLevel();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                WsLogger.this.setLevel(rasLevel);
                return null;
            }
        });
    }

    public String getComponent() {
        return this.ivComponent;
    }

    public String getOrganization() {
        return this.ivOrganization;
    }

    public String getProduct() {
        return this.ivProduct;
    }

    public void setComponent(String component) {
        this.ivComponent = component;
    }

    public void setOrganization(String organization) {
        this.ivOrganization = organization;
    }

    public void setProduct(String product) {
        this.ivProduct = product;
    }
}

