/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private final OutputStream out;
    private long count;

    public CountingOutputStream(OutputStream out) {
        this(out, 0L);
    }

    public CountingOutputStream(OutputStream out, long startOffset) {
        this.out = out;
        this.count = startOffset;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.count += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

