/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsApiHdrsImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgMap;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.utils.PasswordUtils;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class JsApiMessageImpl
extends JsApiHdrsImpl
implements JsApiMessage {
    private static final long serialVersionUID = 1L;
    private static TraceComponent tc = SibTr.register(JsApiMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    static final String USER_PREFIX = "user.";
    static final int USER_PREFIX_LENGTH = "user.".length();
    static final String SI_PREFIX = "SI_";
    static final int SI_PREFIX_LENGTH = "SI_".length();
    static final String SI_REPORT = "Report";
    static final int SI_REPORT_LENGTH = "Report".length();
    static final int SI_REPORT_OFFSET = SI_PREFIX_LENGTH + SI_REPORT_LENGTH;
    private static final String SI_EXCEPTION = "Exception";
    private static final int SI_EXCEPTION_LENGTH = "Exception".length();
    private static final int SI_EXCEPTION_OFFSET = SI_PREFIX_LENGTH + SI_EXCEPTION_LENGTH;
    static final String JMS_PREFIX = "JMS";
    static final int JMS_LENGTH = 3;
    static final char JMSX_EXTRA_PREFIX = 'X';
    static final int JMSX_LENGTH = 4;
    static final String JMS_IBM_EXTRA_PREFIX = "_IBM_";
    static final int JMS_IBM_LENGTH = 8;
    static final String MQMD_EXTRA_PREFIX = "MQMD_";
    static final String JMS_IBM_MQMD_PREFIX = "JMS_IBM_MQMD_";
    static final String REPORT = "Report_";
    static final int REPORT_LENGTH = "Report_".length();
    static final int REPORT_OFFSET = 8 + REPORT_LENGTH;
    private static final byte HEADER_BYTE_0 = -34;
    private static final byte HEADER_BYTE_1 = -83;
    private static final int FLUFFED_PROPERTIES_GUESS = FLUFFED_STRING_OVERHEAD * 2 + 40 + FLUFFED_OBJECT_OVERHEAD * 2 + FLUFFED_JMF_LIST_SIZE * 2;
    private transient JsMsgMap jmsSystemPropertyMap = null;
    private transient JsMsgMap jmsUserPropertyMap = null;
    private transient JsMsgMap otherUserPropertyMap = null;
    private transient JsMsgMap systemContextMap = null;
    private transient JsMsgMap mqMdSetPropertiesMap = null;

    JsApiMessageImpl() {
    }

    JsApiMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    JsApiMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    int guessApproxLength() {
        List props;
        int total = super.guessApproxLength();
        int size = 0;
        if (this.jmsUserPropertyMap != null) {
            size += this.jmsUserPropertyMap.size();
        } else if (this.getApi().isNotEMPTYlist(38) && (props = (List)this.getApi().getField(38)) != null) {
            size += props.size();
        }
        if (this.otherUserPropertyMap != null) {
            size += this.otherUserPropertyMap.size();
        } else if (this.getApi().isNotEMPTYlist(40) && (props = (List)this.getApi().getField(40)) != null) {
            size += props.size();
        }
        if (this.jmsSystemPropertyMap != null) {
            size += this.jmsSystemPropertyMap.size();
        } else if (this.getApi().isNotEMPTYlist(36) && (props = (List)this.getApi().getField(36)) != null) {
            size += props.size();
        }
        if (this.systemContextMap != null) {
            size += this.systemContextMap.size();
        } else if (this.getApi().isNotEMPTYlist(42) && (props = (List)this.getApi().getField(42)) != null) {
            size += props.size();
        }
        if (this.mqMdSetPropertiesMap != null) {
            size += this.mqMdSetPropertiesMap.size();
        } else {
            props = (List)this.getHdr2().getField(60);
            if (props != null) {
                size += props.size();
            }
        }
        return total += size * 40;
    }

    @Override
    int guessFluffedSize() {
        int nameSize;
        int total = super.guessFluffedSize();
        JsMsgPart part = this.getApiIfFluffed();
        if (part != null) {
            nameSize = part.estimateFieldValueSize(38);
            total += nameSize * 2;
            nameSize = part.estimateFieldValueSize(40);
            total += nameSize * 2;
            nameSize = part.estimateFieldValueSize(36);
            total += nameSize * 2;
            nameSize = part.estimateFieldValueSize(42);
            total += nameSize * 2;
        } else {
            total += FLUFFED_PROPERTIES_GUESS;
        }
        part = this.getHdr2IfFluffed();
        if (part != null) {
            nameSize = part.estimateFieldValueSize(60);
            total += nameSize * 2;
        }
        int numProps = 0;
        if (this.jmsUserPropertyMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            numProps += this.jmsUserPropertyMap.size();
        }
        if (this.otherUserPropertyMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            numProps += this.otherUserPropertyMap.size();
        }
        if (this.jmsSystemPropertyMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            numProps += this.jmsSystemPropertyMap.size();
        }
        if (this.systemContextMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            numProps += this.systemContextMap.size();
        }
        if (this.mqMdSetPropertiesMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            numProps += this.mqMdSetPropertiesMap.size();
        }
        return total += numProps * FLUFFED_MAP_ENTRY_SIZE;
    }

    @Override
    public final Serializable getUserProperty(String name) throws IOException, ClassNotFoundException {
        if (name != null) {
            return this.getUserProperty(name, false);
        }
        return null;
    }

    @Override
    public boolean userPropertyExists(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"userPropertyExists", (Object)name);
        }
        boolean result = false;
        if (name != null) {
            if (name.equals("transportVersion") && this.isTransportVersionSet()) {
                result = true;
            } else if (this.mayHaveJmsUserProperties() && this.getJmsUserPropertyMap().containsKey(name)) {
                result = true;
            } else if (this.mayHaveOtherUserProperties() && this.getOtherUserPropertyMap().containsKey(name)) {
                result = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"userPropertyExists", (Object)result);
        }
        return result;
    }

    @Override
    public final Serializable getSystemContextItem(String name) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSystemContextItem", (Object)name);
        }
        Serializable item = null;
        if (name != null) {
            if (this.mayHaveSystemContext()) {
                item = (Serializable)this.getSystemContextMap().get(name);
            }
            if (!(item == null || item instanceof String || item instanceof Number || item instanceof Boolean)) {
                item = this.restoreMapObject((byte[])item);
            }
        } else {
            throw new IllegalArgumentException("null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSystemContextItem", (Object)item);
        }
        return item;
    }

    @Override
    public void putSystemContextItem(String name, Serializable item) throws IllegalArgumentException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putSystemContextItem", (Object)new Object[]{name, item});
        }
        if (name != null) {
            if (item != null) {
                if (this.isValidForJms(item)) {
                    this.getSystemContextMap().put(name, (Object)item);
                } else {
                    this.getSystemContextMap().put(name, (Object)this.flattenMapObject(item));
                }
            } else {
                this.getSystemContextMap().remove(name);
            }
        } else {
            throw new IllegalArgumentException("null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putSystemContextItem");
        }
    }

    @Override
    public Object getIdentifierValue(Identifier id, boolean ignoreType) throws BadMessageFormatMatchingException {
        return this.getIdentifierValue(id, ignoreType, null, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getIdentifierValue(Identifier id, boolean ignoreType, Object contextValue, boolean returnList) throws BadMessageFormatMatchingException {
        if (TraceComponent.isAnyTracingEnabled() && JsApiMessageImpl.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)JsApiMessageImpl.tc, (String)"getIdentifierValue", (Object)new Object[]{id, ignoreType, contextValue, returnList});
        }
        value = null;
        dontTraceNonNullValue = false;
        domain = SelectorDomain.getSelectorDomain(id.getSelectorDomain());
        if (domain == SelectorDomain.XPATH1) {
            try {
                if (contextValue != null && !(contextValue instanceof Node)) {
                    throw new IllegalArgumentException("contextValue must be a Node");
                }
                xrep = (XPathExpression)id.getCompiledExpression();
                if (returnList) {
                    if (xrep == null) ** GOTO lbl61
                    if (contextValue == null) {
                        contextValue = this.getPayloadDocument();
                    }
                    if (contextValue == null || (nodeList = (NodeList)xrep.evaluate(contextValue, XPathConstants.NODESET)) == null || nodeList.getLength() <= 0) ** GOTO lbl61
                    value = new ArrayList<E>(nodeList.getLength());
                    for (i = 0; i < nodeList.getLength(); ++i) {
                        value.add(nodeList.item(i));
                    }
                }
                if (xrep != null) {
                    if (contextValue == null) {
                        contextValue = this.getPayloadDocument();
                    }
                    if (contextValue != null) {
                        value = xrep.evaluate(contextValue, XPathConstants.BOOLEAN);
                    }
                    value = Boolean.FALSE;
                }
                value = Boolean.FALSE;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsApiMessageImpl.getIdentifierValue", (String)"795");
                throw new BadMessageFormatMatchingException(e);
            }
        } else {
            fieldName = id.getName();
            dontTraceNonNullValue = PasswordUtils.containsPassword((String)fieldName);
            if (fieldName.startsWith("JMS")) {
                if (!(fieldName.equals("JMSDestination") || fieldName.equals("JMSReplyTo") || fieldName.equals("JMS_IBM_ExceptionMessage") || fieldName.startsWith("JMS_IBM_MQMD_"))) {
                    value = this.getJMSSystemProperty(fieldName, true);
                }
            } else if (domain == SelectorDomain.JMS) {
                if (this.mayHaveJmsUserProperties()) {
                    value = this.getJmsUserPropertyMap().get(fieldName);
                }
                if (value == null && fieldName.equals("transportVersion")) {
                    value = this.getTransportVersion();
                }
            } else if (domain == SelectorDomain.SIMESSAGE) {
                if (fieldName.startsWith("SI_")) {
                    if (!fieldName.equals("SI_ExceptionInserts")) {
                        value = this.getSIProperty(fieldName, true);
                    }
                } else if (fieldName.startsWith("user.")) {
                    remainder = fieldName.substring(JsApiMessageImpl.USER_PREFIX_LENGTH);
                    try {
                        value = this.getUserProperty(remainder, true);
                    }
                    catch (Exception var10_14) {
                        // empty catch block
                    }
                }
            }
            if (value != null && !ignoreType) {
                value = this.typeCheck(value, id.getType());
            }
        }
lbl61:
        // 9 sources

        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && JsApiMessageImpl.tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)JsApiMessageImpl.tc, (String)"getIdentifierValue", null);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && JsApiMessageImpl.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)JsApiMessageImpl.tc, (String)"getIdentifierValue", (Object)new Object[]{PasswordUtils.replacePossiblePassword((boolean)dontTraceNonNullValue, (Object)value), value.getClass()});
        }
        return value;
    }

    @Override
    public Object getRootContext() throws BadMessageFormatMatchingException {
        Document result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRootContext");
        }
        try {
            result = this.getPayloadDocument();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsApiMessageImpl.getRootContext", (String)"921");
            result = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRootContext", (Object)result);
        }
        return result;
    }

    private final Object typeCheck(Object value, int type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("typecheck: value = " + value + ", " + value.getClass() + " , type=" + type));
        }
        switch (type) {
            case 0: {
                return value;
            }
            case -5: {
                return value instanceof String ? value : null;
            }
            case -6: {
                return value instanceof Boolean ? value : null;
            }
        }
        return value instanceof Number ? value : null;
    }

    final JsMsgMap getJmsSystemPropertyMap() {
        if (this.jmsSystemPropertyMap == null) {
            List keys = (List)this.getApi().getField(36);
            List values = (List)this.getApi().getField(37);
            this.jmsSystemPropertyMap = new JsMsgMap(keys, values);
        }
        return this.jmsSystemPropertyMap;
    }

    final boolean mayHaveMappedJmsSystemProperties() {
        return this.jmsSystemPropertyMap != null || this.getApi().isNotEMPTYlist(36);
    }

    final JsMsgMap getJmsUserPropertyMap() {
        if (this.jmsUserPropertyMap == null) {
            List keys = (List)this.getApi().getField(38);
            List values = (List)this.getApi().getField(39);
            this.jmsUserPropertyMap = new JsMsgMap(keys, values);
        }
        return this.jmsUserPropertyMap;
    }

    final boolean mayHaveJmsUserProperties() {
        return this.jmsUserPropertyMap != null || this.getApi().isNotEMPTYlist(38);
    }

    final JsMsgMap getOtherUserPropertyMap() {
        if (this.otherUserPropertyMap == null) {
            List keys = (List)this.getApi().getField(40);
            List values = (List)this.getApi().getField(41);
            this.otherUserPropertyMap = new JsMsgMap(keys, values);
        }
        return this.otherUserPropertyMap;
    }

    final boolean mayHaveOtherUserProperties() {
        return this.otherUserPropertyMap != null || this.getApi().isNotEMPTYlist(40);
    }

    final JsMsgMap getSystemContextMap() {
        if (this.systemContextMap == null) {
            List keys = (List)this.getApi().getField(42);
            List values = (List)this.getApi().getField(43);
            this.systemContextMap = new JsMsgMap(keys, values);
        }
        return this.systemContextMap;
    }

    final boolean mayHaveSystemContext() {
        return this.systemContextMap != null || this.getApi().isNotEMPTYlist(42);
    }

    final JsMsgMap getMQMDSetPropertiesMap() {
        if (this.mqMdSetPropertiesMap == null) {
            if (this.getHdr2().getChoiceField(89) == 1) {
                List keys = (List)this.getHdr2().getField(60);
                List values = (List)this.getHdr2().getField(61);
                this.mqMdSetPropertiesMap = new JsMsgMap(keys, values);
            } else {
                this.mqMdSetPropertiesMap = new JsMsgMap(null, null);
            }
        }
        return this.mqMdSetPropertiesMap;
    }

    final boolean hasMQMDPropertiesSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasMQMDPropertiesSet");
        }
        boolean set = false;
        if (this.mqMdSetPropertiesMap != null) {
            if (this.mqMdSetPropertiesMap.size() > 0) {
                set = true;
            }
        } else if (this.getHdr2().getChoiceField(89) == 1) {
            set = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasMQMDPropertiesSet", (Object)set);
        }
        return set;
    }

    @Override
    void updateDataFields(int why) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
        super.updateDataFields(why);
        if (this.jmsSystemPropertyMap != null && this.jmsSystemPropertyMap.isChanged()) {
            this.getApi().setField(36, this.jmsSystemPropertyMap.getKeyList());
            this.getApi().setField(37, this.jmsSystemPropertyMap.getValueList());
            this.jmsSystemPropertyMap.setUnChanged();
        }
        if (this.jmsUserPropertyMap != null && this.jmsUserPropertyMap.isChanged()) {
            this.getApi().setField(38, this.jmsUserPropertyMap.getKeyList());
            this.getApi().setField(39, this.jmsUserPropertyMap.getValueList());
            this.jmsUserPropertyMap.setUnChanged();
        }
        if (this.otherUserPropertyMap != null && this.otherUserPropertyMap.isChanged()) {
            this.getApi().setField(40, this.otherUserPropertyMap.getKeyList());
            this.getApi().setField(41, this.otherUserPropertyMap.getValueList());
            this.otherUserPropertyMap.setUnChanged();
        }
        if (this.systemContextMap != null && this.systemContextMap.isChanged()) {
            this.getApi().setField(42, this.systemContextMap.getKeyList());
            this.getApi().setField(43, this.systemContextMap.getValueList());
            this.systemContextMap.setUnChanged();
        }
        if (this.mqMdSetPropertiesMap != null && this.mqMdSetPropertiesMap.isChanged()) {
            if (this.mqMdSetPropertiesMap.size() > 0) {
                this.getHdr2().setField(60, this.mqMdSetPropertiesMap.getKeyList());
                this.getHdr2().setField(61, this.mqMdSetPropertiesMap.getValueList());
            } else {
                this.getHdr2().setChoiceField(89, 0);
            }
            this.mqMdSetPropertiesMap.setUnChanged();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
    }

    final Serializable getUserProperty(String name, boolean forMatching) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUserProperty", (Object)new Object[]{name, forMatching});
        }
        Serializable item = null;
        if (name.equals("transportVersion") && this.isTransportVersionSet()) {
            item = (Serializable)this.getTransportVersion();
        } else if (this.mayHaveJmsUserProperties()) {
            item = (Serializable)this.getJmsUserPropertyMap().get(name);
        }
        if (item == null) {
            if (this.mayHaveOtherUserProperties()) {
                item = (Serializable)this.getOtherUserPropertyMap().get(name);
            }
            if (item != null && !forMatching && item instanceof byte[]) {
                item = this.restoreMapObject((byte[])item);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUserProperty", (Object)PasswordUtils.replaceValueIfKeyIsPassword((String)name, (Object)item));
        }
        return item;
    }

    final Serializable getSIProperty(String name, boolean forMatching) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSIProperty", (Object)name);
        }
        Object value = null;
        if (name.regionMatches(SI_PREFIX_LENGTH, SI_REPORT, 0, SI_REPORT_LENGTH)) {
            int count = name.length() - SI_REPORT_OFFSET;
            if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportExpiration", SI_REPORT_OFFSET, count)) {
                value = this.getReportExpiry();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportException", SI_REPORT_OFFSET, count)) {
                value = this.getReportException();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOA", SI_REPORT_OFFSET, count)) {
                value = this.getReportCOA();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOD", SI_REPORT_OFFSET, count)) {
                value = this.getReportCOD();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportPAN", SI_REPORT_OFFSET, count)) {
                value = this.getReportPAN();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportNAN", SI_REPORT_OFFSET, count)) {
                value = this.getReportNAN();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassMsgID", SI_REPORT_OFFSET, count)) {
                value = this.getReportPassMsgId();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassCorrelID", SI_REPORT_OFFSET, count)) {
                value = this.getReportPassCorrelId();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportDiscardMsg", SI_REPORT_OFFSET, count)) {
                value = this.getReportDiscardMsg();
            } else if (name.regionMatches(SI_REPORT_OFFSET, "SI_ReportFeedback", SI_REPORT_OFFSET, count)) {
                value = this.getReportFeedback();
            } else if (!forMatching) {
                throw new IllegalArgumentException(name);
            }
        } else if (name.regionMatches(SI_PREFIX_LENGTH, SI_EXCEPTION, 0, SI_EXCEPTION_LENGTH)) {
            int count = name.length() - SI_EXCEPTION_OFFSET;
            if (name.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionReason", SI_EXCEPTION_OFFSET, count)) {
                value = this.getExceptionReason();
            } else if (name.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionInserts", SI_EXCEPTION_OFFSET, count)) {
                value = this.getExceptionInserts();
            } else if (name.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionTimestamp", SI_EXCEPTION_OFFSET, count)) {
                value = this.getExceptionTimestamp();
            } else if (name.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionProblemDestination", SI_EXCEPTION_OFFSET, count)) {
                value = this.getExceptionProblemDestination();
            } else if (name.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionProblemSubscription", SI_EXCEPTION_OFFSET, count)) {
                value = this.getExceptionProblemSubscription();
            } else if (!forMatching) {
                throw new IllegalArgumentException(name);
            }
        } else if (forMatching) {
            int count = name.length() - SI_PREFIX_LENGTH;
            if (name.regionMatches(SI_PREFIX_LENGTH, "SI_NextDestination", SI_PREFIX_LENGTH, count)) {
                List<SIDestinationAddress> frp = this.getForwardRoutingPath();
                if (frp != null && frp.size() > 0) {
                    value = frp.get(0).getDestinationName();
                }
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_SystemMessageID", SI_PREFIX_LENGTH, count)) {
                value = this.getSystemMessageId();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_Reliability", SI_PREFIX_LENGTH, count)) {
                value = this.getReliability().toString();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_Priority", SI_PREFIX_LENGTH, count)) {
                value = this.getPriority();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_TimeToLive", SI_PREFIX_LENGTH, count)) {
                value = this.getTimeToLive();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_Discriminator", SI_PREFIX_LENGTH, count)) {
                value = this.getDiscriminator();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyReliability", SI_PREFIX_LENGTH, count)) {
                Reliability r = this.getReplyReliability();
                value = r == null ? null : r.toString();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyPriority", SI_PREFIX_LENGTH, count)) {
                value = this.getReplyPriority();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyTimeToLive", SI_PREFIX_LENGTH, count)) {
                value = this.getReplyTimeToLive();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyDiscriminator", SI_PREFIX_LENGTH, count)) {
                value = this.getReplyDiscriminator();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_RedeliveredCount", SI_PREFIX_LENGTH, count)) {
                value = this.deliveryCount;
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_MessageID", SI_PREFIX_LENGTH, count)) {
                value = this.getApiMessageId();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_CorrelationID", SI_PREFIX_LENGTH, count)) {
                value = this.getCorrelationId();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_UserID", SI_PREFIX_LENGTH, count)) {
                value = this.getUserid();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_Format", SI_PREFIX_LENGTH, count)) {
                value = this.getFormat();
            } else if (name.regionMatches(SI_PREFIX_LENGTH, "SI_DeliveryDelay", SI_PREFIX_LENGTH, count)) {
                value = this.getDeliveryDelay();
            }
        } else {
            throw new IllegalArgumentException(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSIProperty", (Object)value);
        }
        return value;
    }

    final Serializable getJMSSystemProperty(String name, boolean forMatching) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSSystemProperty", (Object)name);
        }
        Object value = null;
        if (name.charAt(3) == 'X') {
            int count = name.length() - 4;
            if (name.regionMatches(4, "JMSXDeliveryCount", 4, count)) {
                value = forMatching ? Integer.valueOf(this.deliveryCount + 1) : Integer.valueOf(this.getJmsxDeliveryCount());
            } else if (name.regionMatches(4, "JMSXAppID", 4, count)) {
                value = this.getJmsxAppId();
            } else if (name.regionMatches(4, "JMSXUserID", 4, count)) {
                value = this.getUserid();
            } else if (this.mayHaveMappedJmsSystemProperties()) {
                value = (Serializable)this.getJmsSystemPropertyMap().get(name);
            }
        } else if (name.startsWith(JMS_IBM_EXTRA_PREFIX, 3)) {
            if (name.regionMatches(8, REPORT, 0, REPORT_LENGTH)) {
                int count = name.length() - REPORT_OFFSET;
                if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Expiration", REPORT_OFFSET, count)) {
                    value = this.getReportExpiry();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Exception", REPORT_OFFSET, count)) {
                    value = this.getReportException();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COA", REPORT_OFFSET, count)) {
                    value = this.getReportCOA();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COD", REPORT_OFFSET, count)) {
                    value = this.getReportCOD();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_PAN", REPORT_OFFSET, count)) {
                    value = this.getReportPAN();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_NAN", REPORT_OFFSET, count)) {
                    value = this.getReportNAN();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Msg_ID", REPORT_OFFSET, count)) {
                    value = this.getReportPassMsgId();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Correl_ID", REPORT_OFFSET, count)) {
                    value = this.getReportPassCorrelId();
                } else if (name.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Discard_Msg", REPORT_OFFSET, count)) {
                    value = this.getReportDiscardMsg();
                }
            } else {
                int count = name.length() - 8;
                if (name.regionMatches(8, "JMS_IBM_ExceptionReason", 8, count)) {
                    value = this.getExceptionReason();
                } else if (name.regionMatches(8, "JMS_IBM_ExceptionTimestamp", 8, count)) {
                    value = this.getExceptionTimestamp();
                } else if (name.regionMatches(8, "JMS_IBM_ExceptionProblemDestination", 8, count)) {
                    value = this.getExceptionProblemDestination();
                } else if (name.regionMatches(8, "JMS_IBM_ExceptionProblemSubscription", 8, count)) {
                    value = this.getExceptionProblemSubscription();
                } else if (name.regionMatches(8, "JMS_IBM_ExceptionMessage", 8, count)) {
                    value = this.getExceptionMessage();
                } else if (name.regionMatches(8, "JMS_IBM_Feedback", 8, count)) {
                    value = this.getReportFeedback();
                } else if (name.regionMatches(8, "JMS_IBM_System_MessageID", 8, count)) {
                    value = this.getSystemMessageId();
                } else if (name.regionMatches(8, "JMS_IBM_ArmCorrelator", 8, count)) {
                    value = this.getARMCorrelator();
                } else if (this.mayHaveMappedJmsSystemProperties()) {
                    value = (Serializable)this.getJmsSystemPropertyMap().get(name);
                }
            }
        } else {
            int count = name.length() - 3;
            if (name.regionMatches(3, "JMSDestination", 3, count)) {
                value = this.getJmsDestination();
                if (value != null && !forMatching) {
                    byte[] copy = new byte[((byte[])value).length];
                    System.arraycopy(value, 0, copy, 0, ((byte[])value).length);
                    value = copy;
                }
            } else if (name.regionMatches(3, "JMSDeliveryMode", 3, count)) {
                value = this.getJmsDeliveryMode().toString();
            } else if (name.regionMatches(3, "JMSMessageID", 3, count)) {
                value = this.getApiMessageId();
            } else if (name.regionMatches(3, "JMSTimestamp", 3, count)) {
                value = this.getTimestamp();
            } else if (name.regionMatches(3, "JMSExpiration", 3, count)) {
                value = this.getJmsExpiration();
            } else if (name.regionMatches(3, "JMSRedelivered", 3, count)) {
                value = forMatching ? (this.deliveryCount > 0 ? Boolean.TRUE : Boolean.FALSE) : this.getJmsRedelivered();
            } else if (name.regionMatches(3, "JMSPriority", 3, count)) {
                value = this.getPriority();
            } else if (name.regionMatches(3, "JMSReplyTo", 3, count)) {
                value = this.getJmsReplyTo();
                if (value != null && !forMatching) {
                    byte[] copy = new byte[((byte[])value).length];
                    System.arraycopy(value, 0, copy, 0, ((byte[])value).length);
                    value = copy;
                }
            } else if (name.regionMatches(3, "JMSCorrelationID", 3, count)) {
                value = this.getCorrelationId();
            } else if (name.regionMatches(3, "JMSType", 3, count)) {
                value = this.getJmsType();
            } else if (name.regionMatches(3, "JMS_TOG_ARM_Correlator", 3, count)) {
                value = this.getARMCorrelator();
            } else if (name.regionMatches(3, "JMSDeliveryTime", 3, count)) {
                value = this.getJmsDeliveryTime();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSSystemProperty", (Object)value);
        }
        return value;
    }

    final Object getMQMDProperty(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMQMDProperty", (Object)name);
        }
        Object result = null;
        result = this.getMQMDSetPropertiesMap().get(name);
        if (result == null && this.mayHaveMappedJmsSystemProperties()) {
            result = this.getJmsSystemPropertyMap().get(name);
        }
        if (result != null && result.getClass() == byte[].class) {
            result = this.copyOf((byte[])result, ((byte[])result).length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMQMDProperty", (Object)result);
        }
        return result;
    }

    final void setMQMDProperty(String name, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMQMDProperty", (Object)new Object[]{name, value});
        }
        if (value instanceof byte[]) {
            value = this.copyOf((byte[])value, 24);
        } else if (value instanceof String && ((String)value).length() > 48) {
            value = ((String)value).substring(0, 48);
        }
        this.getMQMDSetPropertiesMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMQMDProperty");
        }
    }

    final void deleteMQMDProperty(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteMQMDProperty", (Object)name);
        }
        this.getMQMDSetPropertiesMap().remove(name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteMQMDProperty");
        }
    }

    final void clearSmokeAndMirrorsProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearSmokeAndMirrorsProperties");
        }
        this.getHdr2().setChoiceField(66, 0);
        this.setUserid(null);
        this.getApi().setChoiceField(57, 0);
        this.getApi().setChoiceField(60, 0);
        this.getHdr2().setChoiceField(69, 0);
        this.getHdr2().setChoiceField(71, 0);
        this.getHdr2().setChoiceField(70, 0);
        this.getApi().setChoiceField(51, 0);
        this.getApi().setChoiceField(52, 0);
        this.getApi().setChoiceField(53, 0);
        this.getApi().setChoiceField(54, 0);
        this.getApi().setChoiceField(55, 0);
        this.getApi().setChoiceField(56, 0);
        this.setARMCorrelator(null);
        this.getHdr2().setChoiceField(86, 0);
        this.setCcsid(null);
        this.setEncoding(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearSmokeAndMirrorsProperties");
        }
    }

    final byte[] flattenMapObject(Serializable item) throws IOException {
        byte[] serializedItem = null;
        if (item instanceof byte[]) {
            serializedItem = new byte[((byte[])item).length + 2];
            serializedItem[0] = -34;
            serializedItem[1] = -83;
            System.arraycopy(item, 0, serializedItem, 2, ((byte[])item).length);
        } else {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bao);
            out.writeObject(item);
            out.flush();
            out.close();
            serializedItem = bao.toByteArray();
        }
        return serializedItem;
    }

    final Serializable restoreMapObject(byte[] mapItemArray) throws IOException, ClassNotFoundException {
        Object item;
        block10: {
            item = null;
            if (mapItemArray[0] == -34 && mapItemArray[1] == -83) {
                item = new byte[mapItemArray.length - 2];
                System.arraycopy(mapItemArray, 2, item, 0, ((byte[])item).length);
            } else {
                ByteArrayInputStream bai = new ByteArrayInputStream(mapItemArray);
                ObjectInputStream wsin = null;
                if (RuntimeInfo.isThinClient() || RuntimeInfo.isFatClient()) {
                    Class<?> clazz = Class.forName("com.ibm.ws.util.WsObjectInputStream");
                    try {
                        wsin = (ObjectInputStream)clazz.getConstructor(ByteArrayInputStream.class).newInstance(bai);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)e);
                        }
                    }
                } else {
                    ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    wsin = new DeserializationObjectInputStream((InputStream)bai, cl);
                }
                item = (Serializable)wsin.readObject();
                try {
                    if (wsin != null) {
                        wsin.close();
                    }
                }
                catch (IOException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)ex);
                }
            }
        }
        return item;
    }

    final boolean isValidForJms(Object obj) {
        return obj instanceof String || obj instanceof Boolean || obj instanceof Number && !(obj instanceof BigInteger) && !(obj instanceof BigDecimal);
    }

    final boolean isTransportVersionSet() {
        return this.getHdr2().getChoiceField(86) == 1;
    }

    final Object getTransportVersion() {
        return this.getHdr2().getField(57);
    }

    final void setTransportVersion(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransportVersion", (Object)value);
        }
        this.getHdr2().setField(57, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransportVersion");
        }
    }

    final void clearTransportVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearTransportVersion");
        }
        this.getHdr2().setChoiceField(86, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearTransportVersion");
        }
    }

    Document getPayloadDocument() throws ParserConfigurationException, IOException, SIDataGraphSchemaNotFoundException, SIMessageException, UnsupportedEncodingException {
        return null;
    }

    private byte[] copyOf(byte[] original, int length) {
        byte[] copy = new byte[length];
        if (length <= original.length) {
            System.arraycopy(original, 0, copy, 0, length);
        } else {
            System.arraycopy(original, 0, copy, 0, original.length);
        }
        return copy;
    }
}

