/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MFPUnsupportedEncodingRuntimeException;
import com.ibm.ws.sib.mfp.schema.JmsTextBodyAccess;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class JsJmsTextMessageImpl
extends JsJmsMessageImpl
implements JsJmsTextMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static TraceComponent tc;
    private transient SoftReference<Document> softRefToDocument = null;

    JsJmsTextMessageImpl() {
    }

    JsJmsTextMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setFormat("JMS:text");
        this.setBodyType(JmsBodyType.TEXT);
        if (flag != 2) {
            this.jmo.getPayloadPart().setPart(1, JmsTextBodyAccess.schema);
            this.clearBody();
        }
    }

    JsJmsTextMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    public String getText() throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getText");
        }
        String text = null;
        try {
            text = (String)this.getPayload().getField(0);
        }
        catch (MFPUnsupportedEncodingRuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsJmsTextMessageImpl.getText", (String)"148");
            throw (UnsupportedEncodingException)e.getCause();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (text == null || text.length() < 257) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getText", (Object)text);
            } else {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getText", (Object)new Object[]{text.length(), text.substring(0, 200) + "..."});
            }
        }
        return text;
    }

    @Override
    public void setText(String text) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (text == null || text.length() < 257) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setText", (Object)text);
            } else {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setText", (Object)new Object[]{text.length(), text.substring(0, 200) + "..."});
            }
        }
        this.softRefToDocument = null;
        this.clearCachedLengths();
        this.getPayload().setField(0, text);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setText");
        }
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.softRefToDocument = null;
        this.clearCachedLengths();
        this.getPayload().setChoiceField(1, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    int guessPayloadLength() {
        int length = 0;
        try {
            String payload;
            if (this.jmo.getPayloadPart().getChoiceField(4) != 0 && (payload = (String)this.getPayload().getField(0)) != null) {
                length = payload.length() + 24;
            }
        }
        catch (MFPUnsupportedEncodingRuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsJmsTextMessageImpl.getText", (String)"129");
        }
        return length;
    }

    @Override
    int guessFluffedDataSize() {
        int payloadSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize");
        }
        int total = 0;
        JsMsgPart part = this.getPayloadIfFluffed();
        total = part != null ? (total += part.estimateFieldValueSize(0)) : ((payloadSize = this.jmo.getPayloadPart().getAssembledLengthIfKnown()) != -1 ? (total += (payloadSize - 40) * 2 + FLUFFED_STRING_OVERHEAD) : (total += this.getPayload().estimateFieldValueSize(0)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize", (Object)total);
        }
        return total;
    }

    JsMsgPart getPayload() {
        return this.getPayload(JmsTextBodyAccess.schema);
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    @Override
    final Document getPayloadDocument() throws ParserConfigurationException, IOException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPayloadDocument");
        }
        Document domDoc = null;
        if (this.softRefToDocument != null) {
            domDoc = this.softRefToDocument.get();
        }
        if (domDoc == null) {
            String text = this.getText();
            if (text != null && text.length() > 0) {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(text));
                try {
                    domDoc = builder.parse(is);
                    this.softRefToDocument = new SoftReference<Document>(domDoc);
                }
                catch (SAXException e) {
                    domDoc = null;
                }
            } else {
                domDoc = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPayloadDocument", (Object)domDoc);
        }
        return domDoc;
    }

    static {
        tc = SibTr.register(JsJmsTextMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = JsJmsTextMessageImpl.flattenClassName(JsJmsTextMessageImpl.class.getName());
    }
}

