/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.impl.JsJmsBytesMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMapMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsObjectMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsStreamMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsTextMessageImpl;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class WebJsMessageFactoryImpl {
    private static TraceComponent tc = SibTr.register(WebJsMessageFactoryImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    static JsMessage createInboundWebMessage(String data) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInboundWebMessage");
        }
        JsJmsMessage result = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Decoding message from web data", (Object)data);
        }
        StringTokenizer st = new StringTokenizer(data, "~", true);
        String body = null;
        String props = null;
        String topic = null;
        String format = null;
        String type = null;
        String id = null;
        String version = null;
        try {
            version = st.nextToken();
            st.nextToken();
            String s = st.nextToken();
            if (!s.equals("~")) {
                id = s;
                st.nextToken();
            }
            if (!(s = st.nextToken()).equals("~")) {
                type = s;
                st.nextToken();
            }
            if (!(s = st.nextToken()).equals("~")) {
                format = s;
                st.nextToken();
            }
            if (!(s = st.nextToken()).equals("~")) {
                topic = s;
                st.nextToken();
            }
            if (!(s = st.nextToken()).equals("~")) {
                props = s;
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
            }
            if (st.hasMoreTokens()) {
                body = st.nextToken();
            }
        }
        catch (NoSuchElementException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsMessageFactoryImpl.createInboundWebMessage", (String)"119");
            throw new MessageDecodeFailedException("Inccorect WebClient encoding", e);
        }
        if (!version.equals("1")) {
            throw new MessageDecodeFailedException("Incorrect WebClient encoding version: " + version);
        }
        if (!format.startsWith("JMS:")) {
            throw new MessageDecodeFailedException("Incorrect WebClient message format: " + format);
        }
        result = format.equalsIgnoreCase("JMS:text") ? WebJsMessageFactoryImpl.decodeTextBody(body) : (format.equalsIgnoreCase("JMS:bytes") ? WebJsMessageFactoryImpl.decodeBytesBody(body) : (format.equalsIgnoreCase("JMS:object") ? WebJsMessageFactoryImpl.decodeObjectBody(body) : (format.equalsIgnoreCase("JMS:stream") ? WebJsMessageFactoryImpl.decodeStreamBody(body) : (format.equalsIgnoreCase("JMS:map") ? WebJsMessageFactoryImpl.decodeMapBody(body) : new JsJmsMessageImpl(0)))));
        WebJsMessageFactoryImpl.decodeHeader(result, id, type, topic, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Decoded Web Message", (Object)((MessageImpl)((Object)result)).debugMsg());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInboundWebMessage");
        }
        return result;
    }

    private static JsJmsMessage decodeTextBody(String body) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeTextBody");
        }
        JsJmsTextMessageImpl result = new JsJmsTextMessageImpl(0);
        if (body != null) {
            result.setText(WebJsMessageFactoryImpl.URLDecode(body));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeTextBody");
        }
        return result;
    }

    private static JsJmsMessage decodeBytesBody(String body) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeBytesBody");
        }
        JsJmsBytesMessageImpl result = new JsJmsBytesMessageImpl(0);
        if (body != null) {
            result.setBytes(HexString.hexToBin((String)body, (int)0));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeBytesBody");
        }
        return result;
    }

    private static JsJmsMessage decodeObjectBody(String body) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeObjectBody");
        }
        JsJmsObjectMessageImpl result = new JsJmsObjectMessageImpl(0);
        if (body != null) {
            result.setSerializedObject(HexString.hexToBin((String)body, (int)0));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeObjectBody");
        }
        return result;
    }

    private static JsJmsMessage decodeStreamBody(String body) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeStreamBody");
        }
        JsJmsStreamMessageImpl result = new JsJmsStreamMessageImpl(0);
        if (body != null) {
            try {
                StringTokenizer st = new StringTokenizer(body, "&");
                while (st.hasMoreTokens()) {
                    result.writeObject(WebJsMessageFactoryImpl.decodeObject(st.nextToken()));
                }
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageFactoryImpl.decodeStreamBody", (String)"196");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeStreamBody");
        }
        return result;
    }

    private static JsJmsMessage decodeMapBody(String body) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeMapBody");
        }
        JsJmsMapMessageImpl result = new JsJmsMapMessageImpl(0);
        if (body != null) {
            try {
                StringTokenizer st = new StringTokenizer(body, "&");
                while (st.hasMoreTokens()) {
                    Object[] pair = WebJsMessageFactoryImpl.decodePair(st.nextToken());
                    result.setObject((String)pair[0], pair[1]);
                }
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageFactoryImpl.decodeMapBody", (String)"218");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeMapBody");
        }
        return result;
    }

    private static void decodeHeader(JsJmsMessage msg, String id, String type, String topic, String props) {
        if (id != null) {
            if (id.length() % 2 != 0) {
                id = "0" + id;
            }
            msg.setCorrelationIdAsBytes(HexString.hexToBin((String)id, (int)0));
        }
        if (type != null) {
            if (type.equals("SIB")) {
                msg.setJmsxAppId(MfpConstants.WPM_JMSXAPPID);
            } else {
                msg.setJmsxAppId(WebJsMessageFactoryImpl.URLDecode(type));
            }
        }
        if (topic != null) {
            msg.setDiscriminator(WebJsMessageFactoryImpl.URLDecode(topic));
        }
        if (props != null) {
            StringTokenizer st = new StringTokenizer(props, "&");
            while (st.hasMoreTokens()) {
                Object[] pair = WebJsMessageFactoryImpl.decodePair(st.nextToken());
                if (((String)pair[0]).equals("JMSXAppID")) continue;
                try {
                    msg.setObjectProperty((String)pair[0], pair[1]);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Object[] decodePair(String text) {
        Object[] result = new Object[2];
        int i = text.indexOf(61);
        result[0] = WebJsMessageFactoryImpl.URLDecode(text.substring(0, i));
        result[1] = WebJsMessageFactoryImpl.decodeObject(text.substring(i + 1));
        return result;
    }

    private static Object decodeObject(String text) {
        Object result = null;
        result = text.startsWith("[]") ? (Object)HexString.hexToBin((String)text, (int)2) : WebJsMessageFactoryImpl.URLDecode(text);
        return result;
    }

    private static String URLDecode(String text) {
        String result = null;
        try {
            result = URLDecoder.decode(text, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsMessageFactoryImpl.URLDecode", (String)"293");
        }
        return result;
    }
}

