/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public class JmfTr {
    private static ThreadLocal jmfThreadLocal = new ThreadLocal(){

        public Object initialValue() {
            JmfThreadData data = new JmfThreadData();
            data.clear();
            return data;
        }
    };

    public static boolean isTracing() {
        return ((JmfThreadData)jmfThreadLocal.get()).isTracing();
    }

    public static int traceSuppressionCount() {
        return ((JmfThreadData)jmfThreadLocal.get()).getTrueCount();
    }

    public static void setTracing(boolean trace) {
        ((JmfThreadData)jmfThreadLocal.get()).setTracing(trace);
    }

    public static TraceComponent register(Class aClass, String group, String resourceBundleName) {
        TraceComponent tc = SibTr.register((Class)aClass, (String)group, (String)resourceBundleName);
        return tc;
    }

    public static final void debug(TraceComponent tc, String msg) {
        SibTr.debug(null, (TraceComponent)tc, (String)msg);
    }

    public static String getMEName(Object o) {
        return SibTr.getMEName((Object)o);
    }

    public static void push(Object jsme) {
        SibTr.push((Object)jsme);
    }

    public static void pop() {
        SibTr.pop();
    }

    public static void audit(TraceComponent tc, String msgKey) {
        SibTr.audit((TraceComponent)tc, (String)msgKey);
    }

    public static void audit(TraceComponent tc, String msgKey, Object objs) {
        SibTr.audit((TraceComponent)tc, (String)msgKey, (Object)objs);
    }

    public static void debug(TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.debug((TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void debug(Object o, TraceComponent tc, String msg) {
        if (JmfTr.isTracing()) {
            SibTr.debug((Object)o, (TraceComponent)tc, (String)msg);
        }
    }

    public static void debug(Object o, TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.debug((Object)o, (TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void dump(TraceComponent tc, String msg) {
        if (JmfTr.isTracing()) {
            SibTr.dump((TraceComponent)tc, (String)msg);
        }
    }

    public static void dump(TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.debug((TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void dump(Object o, TraceComponent tc, String msg) {
        if (JmfTr.isTracing()) {
            SibTr.dump((Object)o, (TraceComponent)tc, (String)msg);
        }
    }

    public static void dump(Object o, TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.dump((Object)o, (TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void error(TraceComponent tc, String msgKey) {
        if (JmfTr.isTracing()) {
            SibTr.error((TraceComponent)tc, (String)msgKey);
        }
    }

    public static void error(TraceComponent tc, String msgKey, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.error((TraceComponent)tc, (String)msgKey, (Object)objs);
        }
    }

    public static void event(TraceComponent tc, String msg) {
        if (JmfTr.isTracing()) {
            SibTr.event((TraceComponent)tc, (String)msg);
        }
    }

    public static void event(TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.event((TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void event(Object o, TraceComponent tc, String msg) {
        if (JmfTr.isTracing()) {
            SibTr.event((Object)o, (TraceComponent)tc, (String)msg);
        }
    }

    public static void event(Object o, TraceComponent tc, String msg, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.event((Object)o, (TraceComponent)tc, (String)msg, (Object)objs);
        }
    }

    public static void entry(TraceComponent tc, String methodName) {
        if (JmfTr.isTracing()) {
            SibTr.entry((TraceComponent)tc, (String)methodName);
        }
    }

    public static void entry(TraceComponent tc, String methodName, Object obj) {
        if (JmfTr.isTracing()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)obj);
        }
    }

    public static void entry(Object o, TraceComponent tc, String methodName) {
        if (JmfTr.isTracing()) {
            SibTr.entry((Object)o, (TraceComponent)tc, (String)methodName);
        }
    }

    public static void entry(Object o, TraceComponent tc, String methodName, Object obj) {
        if (JmfTr.isTracing()) {
            SibTr.entry((Object)o, (TraceComponent)tc, (String)methodName, (Object)obj);
        }
    }

    public static void exit(TraceComponent tc, String methodName) {
        if (JmfTr.isTracing()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public static void exit(TraceComponent tc, String methodName, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.exit((TraceComponent)tc, (String)methodName, (Object)objs);
        }
    }

    public static void exit(Object o, TraceComponent tc, String methodName) {
        if (JmfTr.isTracing()) {
            SibTr.exit((Object)o, (TraceComponent)tc, (String)methodName);
        }
    }

    public static void exit(Object o, TraceComponent tc, String methodName, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.exit((Object)o, (TraceComponent)tc, (String)methodName, (Object)objs);
        }
    }

    public static void fatal(TraceComponent tc, String msgKey) {
        if (JmfTr.isTracing()) {
            SibTr.fatal((TraceComponent)tc, (String)msgKey);
        }
    }

    public static void fatal(TraceComponent tc, String msgKey, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.fatal((TraceComponent)tc, (String)msgKey, (Object)objs);
        }
    }

    public static void info(TraceComponent tc, String msgKey) {
        if (JmfTr.isTracing()) {
            SibTr.info((TraceComponent)tc, (String)msgKey);
        }
    }

    public static void info(TraceComponent tc, String msgKey, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.info((TraceComponent)tc, (String)msgKey, (Object)objs);
        }
    }

    public static void service(TraceComponent tc, String msgKey) {
        if (JmfTr.isTracing()) {
            SibTr.service((TraceComponent)tc, (String)msgKey);
        }
    }

    public static void service(TraceComponent tc, String msgKey, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.service((TraceComponent)tc, (String)msgKey, (Object)objs);
        }
    }

    public static void warning(TraceComponent tc, String msgKey) {
        if (JmfTr.isTracing()) {
            SibTr.warning((TraceComponent)tc, (String)msgKey);
        }
    }

    public static void warning(TraceComponent tc, String msgKey, Object objs) {
        if (JmfTr.isTracing()) {
            SibTr.warning((TraceComponent)tc, (String)msgKey, (Object)objs);
        }
    }

    public static void bytes(TraceComponent tc, byte[] data) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((TraceComponent)tc, (byte[])data);
        }
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((Object)o, (TraceComponent)tc, (byte[])data);
        }
    }

    public static void bytes(TraceComponent tc, byte[] data, int start) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((TraceComponent)tc, (byte[])data, (int)start);
        }
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((Object)o, (TraceComponent)tc, (byte[])data, (int)start);
        }
    }

    public static void bytes(TraceComponent tc, byte[] data, int start, int count) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((TraceComponent)tc, (byte[])data, (int)start, (int)count);
        }
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start, int count) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((Object)o, (TraceComponent)tc, (byte[])data, (int)start, (int)count);
        }
    }

    public static void bytes(TraceComponent tc, byte[] data, int start, int count, String comment) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((TraceComponent)tc, (byte[])data, (int)start, (int)count, (String)comment);
        }
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start, int count, String comment) {
        if (JmfTr.isTracing()) {
            SibTr.bytes((Object)o, (TraceComponent)tc, (byte[])data, (int)start, (int)count, (String)comment);
        }
    }

    public static String formatBytes(byte[] data, int start, int count) {
        if (JmfTr.isTracing()) {
            return SibTr.formatBytes((byte[])data, (int)start, (int)count);
        }
        return "";
    }

    public static String formatBytes(byte[] data, int start, int count, boolean displayCharRepresentations) {
        if (JmfTr.isTracing()) {
            return SibTr.formatBytes((byte[])data, (int)start, (int)count, (boolean)displayCharRepresentations);
        }
        return "";
    }

    public static void exception(TraceComponent tc, Exception e) {
        if (JmfTr.isTracing()) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
    }

    public static void exception(Object o, TraceComponent tc, Exception e) {
        if (JmfTr.isTracing()) {
            SibTr.exception((Object)o, (TraceComponent)tc, (Exception)e);
        }
    }

    public static void exception(TraceComponent tc, Throwable t) {
        if (JmfTr.isTracing()) {
            SibTr.exception((TraceComponent)tc, (Throwable)t);
        }
    }

    public static void exception(Object o, TraceComponent tc, Throwable t) {
        if (JmfTr.isTracing()) {
            SibTr.exception((Object)o, (TraceComponent)tc, (Throwable)t);
        }
    }

    private static class JmfThreadData {
        private int trueCount = 0;
        private int workingCount = 0;

        private JmfThreadData() {
        }

        public void clear() {
            this.trueCount = 0;
            this.workingCount = 0;
        }

        public boolean isTracing() {
            return this.workingCount == 0;
        }

        public void setTracing(boolean tracing) {
            if (tracing) {
                --this.trueCount;
                --this.workingCount;
                this.workingCount = this.workingCount < 0 ? 0 : this.workingCount;
            } else {
                ++this.trueCount;
                ++this.workingCount;
            }
        }

        public int getTrueCount() {
            return this.trueCount;
        }
    }
}

