/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFMessageData;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JMFVariantType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;

public final class JSVariant
extends JSField
implements JMFVariantType {
    private static TraceComponent tc = JmfTr.register(JSVariant.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JSType[] cases;
    private JSchema boxed;
    private JSVariant boxedBy;
    private int index;
    private JSVariant[][] dominated;
    JSField.Accessor boxAccessor;

    public JSVariant() {
    }

    @Override
    public boolean isOptionalData() {
        if (this.cases == null || this.cases.length != 2) {
            return false;
        }
        return this.cases[0] instanceof JSTuple && ((JSTuple)this.cases[0]).getFieldCount() == 0;
    }

    @Override
    public int getCaseCount() {
        return this.cases == null ? 0 : this.cases.length;
    }

    @Override
    public JMFType getCase(int position) {
        if (position >= this.getCaseCount()) {
            throw new IllegalArgumentException("Invalid variant position");
        }
        return this.cases[position];
    }

    @Override
    public void addCase(JMFType theCase) {
        if (theCase == null) {
            throw new NullPointerException("Variant case cannot be null");
        }
        JSType newCase = (JSType)theCase;
        if (this.cases == null) {
            this.cases = new JSType[1];
        } else {
            JSType[] oldCases = this.cases;
            this.cases = new JSType[oldCases.length + 1];
            System.arraycopy(oldCases, 0, this.cases, 0, oldCases.length);
        }
        newCase.parent = this;
        newCase.siblingPosition = this.cases.length - 1;
        this.cases[newCase.siblingPosition] = newCase;
    }

    @Override
    BigInteger setMultiChoiceCount() {
        if (this.boxed == null) {
            this.multiChoiceCount = BigInteger.ZERO;
            for (int i = 0; i < this.cases.length; ++i) {
                this.multiChoiceCount = this.multiChoiceCount.add(this.cases[i].setMultiChoiceCount());
            }
        }
        return this.multiChoiceCount;
    }

    public JSVariant[] getDominatedVariants(int i) {
        if (this.dominated == null) {
            this.dominated = new JSVariant[this.cases.length][];
        }
        if (this.dominated[i] == null) {
            JSType acase = this.cases[i];
            this.dominated[i] = acase instanceof JSVariant ? new JSVariant[]{(JSVariant)acase} : (acase instanceof JSTuple ? ((JSTuple)acase).getDominatedVariants() : new JSVariant[0]);
        }
        return this.dominated[i];
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public JMFSchema getBoxed() {
        return this.boxed;
    }

    public JSVariant getBoxedBy() {
        return this.boxedBy;
    }

    JSchema box(Map context) {
        if (this.boxed != null) {
            return this.boxed;
        }
        JSVariant subTop = new JSVariant();
        subTop.cases = this.cases;
        subTop.boxedBy = this;
        this.boxed = (JSchema)context.get(subTop);
        if (this.boxed == null) {
            this.boxed = new JSchema(subTop, context);
            for (int i = 0; i < this.cases.length; ++i) {
                this.cases[i].parent = subTop;
            }
            context.put(subTop, this.boxed);
        }
        return this.boxed;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getBoxAccessor() {
        if (this.boxAccessor == null) {
            return -1;
        }
        return this.boxAccessor.accessor;
    }

    @Override
    public int getBoxAccessor(JMFSchema schema) {
        JSField.Accessor acc = this.boxAccessor;
        while (acc != null) {
            if (schema == acc.schema) {
                return acc.accessor;
            }
            acc = acc.next;
        }
        return -1;
    }

    void setBoxAccessor(int accessor, JMFSchema schema) {
        this.boxAccessor = new JSField.Accessor(accessor, schema, this.boxAccessor);
    }

    @Override
    public void format(StringBuffer fmt, Set done, Set todo, int indent) {
        this.formatName(fmt, indent);
        fmt.append("{\n");
        for (int i = 0; i < this.cases.length; ++i) {
            if (i > 0) {
                fmt.append(" |\n");
            }
            this.cases[i].format(fmt, done, todo, indent + 2);
        }
        fmt.append("\n");
        this.indent(fmt, indent);
        fmt.append("}");
    }

    JSVariant(byte[] frame, int[] limits) {
        int count = JSType.getCount(frame, limits);
        this.cases = new JSType[count];
        for (int i = 0; i < count; ++i) {
            this.cases[i] = JSType.createJSType(frame, limits);
            this.cases[i].parent = this;
            this.cases[i].siblingPosition = i;
        }
    }

    @Override
    public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        return 4 + ((JSMessageImpl)val).getEncodedLength();
    }

    @Override
    public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
        if (val instanceof JSMessageImpl) {
            if (this.boxed.getID() != ((JSMessageImpl)val).getJMFSchema().getID()) {
                throw new JMFSchemaViolationException("Incorrect schema for boxed variant");
            }
            return val;
        }
        throw new JMFSchemaViolationException(val == null ? "null" : val.getClass().getName());
    }

    @Override
    public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        JSMessageImpl box = (JSMessageImpl)val;
        int len = box.getEncodedLength();
        ArrayUtil.writeInt(frame, offset, len);
        box.toByteArray(frame, offset + 4, len);
        return offset + 4 + len;
    }

    @Override
    public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
        int length = ArrayUtil.readInt(frame, offset);
        JSListCoder.sanityCheck(length, frame, offset);
        return new JSMessageImpl(this.boxed, frame, offset + 4, length, false);
    }

    @Override
    public Object copy(Object val, int indirect) throws JMFSchemaViolationException {
        return ((JSMessageImpl)val).getCopy();
    }

    @Override
    public int estimateUnassembledSize(Object val) {
        return 88;
    }

    @Override
    public int estimateUnassembledSize(byte[] frame, int offset) {
        return 88;
    }

    @Override
    public int encodedTypeLength() {
        int ans = 3;
        for (int i = 0; i < this.cases.length; ++i) {
            ans += this.cases[i].encodedTypeLength();
        }
        return ans;
    }

    @Override
    public void encodeType(byte[] frame, int[] limits) {
        JSType.setByte(frame, limits, (byte)4);
        JSType.setCount(frame, limits, this.getCaseCount());
        if (this.cases != null) {
            for (int i = 0; i < this.cases.length; ++i) {
                this.cases[i].encodeType(frame, limits);
            }
        }
    }

    @Override
    public void updateAssociations(JMFType type) {
        super.updateAssociations(type);
        if (this.getCaseCount() != ((JSVariant)type).getCaseCount()) {
            throw new IllegalStateException();
        }
        if (this.cases != null) {
            for (int i = 0; i < this.cases.length; ++i) {
                this.cases[i].updateAssociations(((JSVariant)type).getCase(i));
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof JSVariant) {
            return this.cases == ((JSVariant)o).cases;
        }
        return false;
    }

    public int hashCode() {
        if (this.cases == null) {
            return super.hashCode();
        }
        return this.cases.hashCode();
    }
}

