/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.CommsServerByteBufferPool;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public abstract class CommonServerReceiveListener {
    private static final TraceComponent tc = SibTr.register(CommonServerReceiveListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = CommonServerReceiveListener.class.getName();
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean clientConnection = true;
    protected CommsServerByteBufferPool poolManager = CommsServerByteBufferPool.getInstance();

    public CommonServerReceiveListener(boolean clientConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("" + clientConnection));
        }
        this.clientConnection = clientConnection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected void rcvHandshake(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvHandshake", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationUsageType usageType = ConversationUsageType.JFAP;
        CATHandshakeProperties catHandshakeProps = new CATHandshakeProperties();
        CommsServerByteBuffer reply = this.poolManager.allocate();
        reply.put(request.get());
        int currentFapLevel = CommsUtils.getRuntimeIntProperty((String)"sib.comms.ServerFapLevel", (String)"20");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Server is FAP Level: " + currentFapLevel));
        }
        boolean noErrorOccurred = true;
        boolean rcvFapLevel = false;
        boolean rcvProdVersion = false;
        boolean rcvProdId = false;
        boolean rcvSupportedFaps = false;
        boolean[] supportedFaps = null;
        int peerFapLevel = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- Received the following handshake data -----");
        }
        block18: while (request.hasRemaining() && noErrorOccurred) {
            short fieldId = request.getShort();
            switch (fieldId) {
                case 1: {
                    short productVersionFieldLength = request.getShort();
                    if (productVersionFieldLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Product Version field length", (Object)productVersionFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "ProductVersion length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    byte upperProductVersion = request.get();
                    byte lowerProductVersion = request.get();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Product Version   : " + upperProductVersion + "." + lowerProductVersion));
                    }
                    rcvProdVersion = true;
                    catHandshakeProps.setMajorVersion((short)upperProductVersion);
                    catHandshakeProps.setMinorVersion((short)lowerProductVersion);
                    reply.putShort((short)1);
                    reply.putShort(2);
                    reply.put((byte)6);
                    reply.put((byte)0);
                    continue block18;
                }
                case 2: {
                    short fapLevelFieldLength = request.getShort();
                    if (fapLevelFieldLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected FAP Level field length", (Object)fapLevelFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "FAPLevel length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    peerFapLevel = request.getShort();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" FAP Version       : " + peerFapLevel));
                    }
                    rcvFapLevel = true;
                    continue block18;
                }
                case 3: {
                    short maxMessageFieldLength = request.getShort();
                    if (maxMessageFieldLength != 8) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Max Message Size field length", (Object)maxMessageFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "MaxMessageSize length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    long maxMessageSize = request.getLong();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Max Msg Size      : " + maxMessageSize));
                    }
                    catHandshakeProps.setMaxMessageSize(maxMessageSize);
                    continue block18;
                }
                case 4: {
                    short maxTransmissionFieldLength = request.getShort();
                    if (maxTransmissionFieldLength != 4) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Max Transmission Size field length", (Object)maxTransmissionFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "MaxTransmissionSize length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    int maxTransmissionSize = request.getInt();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Max Tx Size       : " + maxTransmissionSize));
                    }
                    catHandshakeProps.setMaxTransmissionSize(maxTransmissionSize);
                    continue block18;
                }
                case 5: {
                    short maxInterval;
                    short heartbeatFieldLength = request.getShort();
                    if (heartbeatFieldLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Heartbeat Interval field length", (Object)heartbeatFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "HeartbeatInterval length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    short heartbeatInterval = request.getShort();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Interval: " + heartbeatInterval));
                    }
                    if ((maxInterval = (short)Math.max(conversation.getHeartbeatInterval(), heartbeatInterval)) > heartbeatInterval) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("> Negotiating Heartbeat Interval to: " + maxInterval));
                        }
                        reply.putShort((short)5);
                        reply.putShort(2);
                        reply.putShort(maxInterval);
                    } else {
                        conversation.setHeartbeatInterval((int)maxInterval);
                    }
                    catHandshakeProps.setHeartbeatInterval(maxInterval);
                    continue block18;
                }
                case 13: {
                    short maxTimeout;
                    short heartbeatTimeoutFieldLength = request.getShort();
                    if (heartbeatTimeoutFieldLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Heartbeat Timeout field length", (Object)heartbeatTimeoutFieldLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "HeartbeatTimeout length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    short heartbeatTimeout = request.getShort();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Timeout : " + heartbeatTimeout));
                    }
                    if ((maxTimeout = (short)Math.max(conversation.getHeartbeatTimeout(), heartbeatTimeout)) > heartbeatTimeout) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("> Negotiating Heartbeat Timeout to: " + maxTimeout));
                        }
                        reply.putShort((short)13);
                        reply.putShort(2);
                        reply.putShort(maxTimeout);
                    } else {
                        conversation.setHeartbeatTimeout((int)maxTimeout);
                    }
                    catHandshakeProps.setHeartbeatTimeout(maxTimeout);
                    continue block18;
                }
                case 7: {
                    short capabilityLength = request.getShort();
                    if (capabilityLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Capability field length", (Object)capabilityLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "Capability length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    short capability = request.getShort();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Capabilities      : 0x" + Integer.toHexString(capability)));
                    }
                    if ((capability & 0xFFFFFF80) != 0) {
                        capability = (short)(capability & 0x7F);
                        reply.putShort((short)7);
                        reply.putShort(2);
                        reply.putShort(capability);
                    }
                    catHandshakeProps.setCapabilites(capability);
                    continue block18;
                }
                case 11: {
                    short productIdLength = request.getShort();
                    if (productIdLength != 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected Product Id length", (Object)productIdLength);
                        }
                        this.rejectHandshake(conversation, requestNumber, "Product Id length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    short productId = request.getShort();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Peer Product Id   : 0x" + Integer.toHexString(productId)));
                    }
                    rcvProdId = true;
                    catHandshakeProps.setPeerProductId(productId);
                    reply.putShort((short)11);
                    reply.putShort(2);
                    reply.putShort((short)1);
                    continue block18;
                }
                case 12: {
                    short supportedFapsLength = request.getShort();
                    if (supportedFapsLength != 32) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected Supported FAPs length: " + supportedFapsLength));
                        }
                        this.rejectHandshake(conversation, requestNumber, "Supported FAPs length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    StringBuffer traceData = null;
                    byte[] fapsBitmap = request.get(32);
                    supportedFaps = new boolean[256];
                    for (int i = 0; i < supportedFaps.length; ++i) {
                        boolean bitOn;
                        byte byteValue = fapsBitmap[(255 - i) / 8];
                        supportedFaps[i] = bitOn = (byteValue >> i % 8 & 1) == 1;
                        if (!bitOn || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        if (traceData == null) {
                            traceData = new StringBuffer().append(i + 1);
                            continue;
                        }
                        traceData.append(", ").append(i + 1);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Supported FAP's   : " + traceData.toString()));
                    }
                    rcvSupportedFaps = true;
                    continue block18;
                }
                case 14: {
                    short length = request.getShort();
                    if (length != 4) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected FIELDID_CONVERSATION_USAGE_TYPE length: " + length));
                        }
                        this.rejectHandshake(conversation, requestNumber, "FIELDID_CONVERSATION_USAGE_TYPE length");
                        noErrorOccurred = false;
                        continue block18;
                    }
                    usageType = ConversationUsageType.deserialize((JFapByteBuffer)request);
                    if (usageType == ConversationUsageType.JFAP) continue block18;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not running on z/OS CRA rejecting handshake");
                    }
                    this.rejectHandshake(conversation, requestNumber, "FIELDID_CONVERSATION_USAGE_TYPE platform");
                    noErrorOccurred = false;
                    continue block18;
                }
                case 15: {
                    request.getShort();
                    String remoteCellName = request.getString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Remote cell name: " + remoteCellName));
                    }
                    catHandshakeProps.setRemoteCellName(remoteCellName);
                    continue block18;
                }
                case 16: {
                    request.getShort();
                    String remoteNodeName = request.getString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Remote node name: " + remoteNodeName));
                    }
                    catHandshakeProps.setRemoteNodeName(remoteNodeName);
                    continue block18;
                }
                case 17: {
                    request.getShort();
                    String remoteServerName = request.getString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Remote server name: " + remoteServerName));
                    }
                    catHandshakeProps.setRemoteServerName(remoteServerName);
                    continue block18;
                }
                case 18: {
                    request.getShort();
                    String remoteClusterName = request.getString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Remote cluster name: " + remoteClusterName));
                    }
                    catHandshakeProps.setRemoteClusterName(remoteClusterName);
                    continue block18;
                }
            }
            short fieldLength = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("* Unknown Field    : Id: " + fieldId + ", Length: " + fieldLength));
            }
            request.skip((int)fieldLength);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- End of handshake data ---------------------");
        }
        if (noErrorOccurred) {
            if (!rcvFapLevel) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No FAP level present in handshake");
                }
                this.rejectHandshake(conversation, requestNumber, "FAPLevel");
            } else if (!rcvProdVersion) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No Product Version present in handshake");
                }
                this.rejectHandshake(conversation, requestNumber, "ProductVersion");
            } else if (!rcvProdId && this.clientConnection) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No Product Id present in handshake");
                }
                this.rejectHandshake(conversation, requestNumber, "ProductId");
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Handshake contained enough information to continue");
                }
                boolean foundSuitableFapLevel = true;
                int linkFapLevel = peerFapLevel;
                if (linkFapLevel > currentFapLevel) {
                    linkFapLevel = currentFapLevel;
                }
                if (rcvSupportedFaps && currentFapLevel >= 3) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Examining the peers supported FAP levels");
                    }
                    int i = linkFapLevel - 1;
                    boolean suitableLevelFound = false;
                    while (i >= 0 && !suitableLevelFound) {
                        suitableLevelFound = supportedFaps[i] && supportedFaps[i] == CommsConstants.isFapLevelSupported((int)(i + 1));
                        if (suitableLevelFound) continue;
                        --i;
                    }
                    if (suitableLevelFound) {
                        linkFapLevel = i + 1;
                    } else {
                        foundSuitableFapLevel = false;
                        this.rejectHandshake(conversation, requestNumber, "No mutually agreeable FAP level");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Peer did not supply supported FAP levels or SupportedFAPVersions field is not applicable");
                    }
                    linkFapLevel = peerFapLevel == 1 ? 1 : 2;
                }
                if (foundSuitableFapLevel) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Informing peer of negotiatied value: " + linkFapLevel));
                    }
                    reply.putShort((short)2);
                    reply.putShort(2);
                    reply.putShort(linkFapLevel);
                    catHandshakeProps.setFapLevel((short)linkFapLevel);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Handshake Properties: ", (Object)catHandshakeProps);
                    }
                    if (usageType.requiresNormalHandshakeProcessing()) {
                        conversation.setHandshakeProperties((HandshakeProperties)catHandshakeProps);
                    }
                    try {
                        conversation.send((JFapByteBuffer)reply, 6, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvHandshake"), (String)"3-031-0001", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
                    }
                }
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvHandshake");
        }
    }

    private void rejectHandshake(Conversation conversation, int requestNumber, String rejectedField) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rejectHandshake", (Object)new Object[]{conversation, requestNumber, rejectedField});
        }
        SIConnectionLostException exception = new SIConnectionLostException(nls.getFormattedMessage("INVALID_PROP_SICO8012", null, null));
        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rejectHandshake"), (String)"3-031-0002", (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid handshake type received - rejecting field:", (Object)rejectedField);
        }
        StaticCATHelper.sendExceptionToClient((Throwable)exception, "3-031-0002", conversation, requestNumber);
        this.closeConnection(conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rejectHandshake");
        }
    }

    protected abstract void closeConnection(Conversation var1);
}

