/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.client.ConsumerMonitorListenerCache;
import com.ibm.ws.sib.comms.client.DestinationListenerCache;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CachedSessionProperties;
import com.ibm.ws.sib.comms.server.clientsupport.ChunkedMessageWrapper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

public class ConversationState {
    private static TraceComponent tc = SibTr.register(ConversationState.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = ConversationState.class.getName();
    public static final int OBJECT_TABLE_ORIGIN = 10;
    public static final int INITIAL_SIZE_OF_OBJECT_TABLE = 42;
    static final int MINUS_ONE = -1;
    static final int OBJECT_TABLE_EXTEND_FACTOR = 2;
    private int maxIndex = 41;
    private int highWatermark = 10;
    private int freeSlot = 10;
    private int maxTableSize = 0;
    private Object[] objectTable;
    private boolean foundFreeSlot;
    private short connectionObjectId;
    private int requestNumber = 0;
    private CachedSessionProperties cachedProps = null;
    private CATMainConsumer cachedConsumer = null;
    private CommsConnection cc = null;
    private final HashMap<Long, ChunkedMessageWrapper> inProgressMessages = new HashMap();
    private volatile boolean hasMETerminated = false;
    private volatile DestinationListenerCache destinationListenerCache = null;
    private volatile ConsumerMonitorListenerCache consumerMonitorListenerCache = null;

    public ConversationState() {
        this(Short.MAX_VALUE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConversationState(int maxTabSize) {
        this(42, maxTabSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("" + maxTabSize));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConversationState(int initialTableSize, int maxTabSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + initialTableSize, "" + maxTabSize});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ConversationState", (Object)"CS> Create a new Conversation State (Object Store)");
        }
        if (initialTableSize <= 0 || maxTabSize <= 0) {
            throw new NegativeArraySizeException();
        }
        if (initialTableSize < 10) {
            throw new IllegalArgumentException();
        }
        if (initialTableSize > maxTabSize) {
            throw new IllegalArgumentException();
        }
        this.maxTableSize = maxTabSize;
        this.objectTable = new Object[initialTableSize];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void setConnectionObjectId(short connectionObjectId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConnectionObjectId", (Object)connectionObjectId);
        }
        this.connectionObjectId = connectionObjectId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConnectionObjectId");
        }
    }

    public short getConnectionObjectId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionObjectId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionObjectId", (Object)this.connectionObjectId);
        }
        return this.connectionObjectId;
    }

    public void setCachedConsumerProps(CachedSessionProperties props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCachedConsumerProps", (Object)props);
        }
        this.cachedProps = props;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCachedConsumerProps");
        }
    }

    public CachedSessionProperties getCachedConsumerProps() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCachedConsumerProps");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCachedConsumerProps", (Object)this.cachedProps);
        }
        return this.cachedProps;
    }

    public CATMainConsumer getCachedConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCachedConsumer");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCachedConsumer", (Object)this.cachedConsumer);
        }
        return this.cachedConsumer;
    }

    public void setCachedConsumer(CATMainConsumer consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCachedConsumer", (Object)consumer);
        }
        this.cachedConsumer = consumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCachedConsumer");
        }
    }

    public int getObjectCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectCount");
        }
        int count = 0;
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            ++count;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectCount", (Object)count);
        }
        return count;
    }

    public synchronized void emptyObjectStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emptyObjectStore");
        }
        for (int i = 0; i < this.objectTable.length; ++i) {
            this.objectTable[i] = null;
        }
        this.freeSlot = 10;
        this.highWatermark = 10;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emptyObjectStore");
        }
    }

    public synchronized int addObject(Object object) throws ConversationStateFullException {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addObject", (Object)("object=" + object));
        }
        int objectIndex = 0;
        if (this.freeSlot == -1) {
            this.extendObjectTable();
        }
        objectIndex = this.freeSlot;
        this.objectTable[objectIndex] = object;
        this.highWatermark = Math.max(this.highWatermark, this.freeSlot);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"High Water Mark = ", (Object)this.highWatermark);
        }
        this.foundFreeSlot = false;
        for (i = this.highWatermark + 1; i <= this.maxIndex; ++i) {
            if (this.objectTable[i] != null) continue;
            this.freeSlot = i;
            this.foundFreeSlot = true;
            break;
        }
        if (!this.foundFreeSlot) {
            for (i = 10; i <= this.highWatermark - 1; ++i) {
                if (this.objectTable[i] != null) continue;
                this.freeSlot = i;
                this.foundFreeSlot = true;
                break;
            }
        }
        if (!this.foundFreeSlot) {
            this.freeSlot = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Next free slot = ", (Object)this.freeSlot);
            SibTr.debug((TraceComponent)tc, (String)"Max Index = ", (Object)this.maxIndex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addObject", (Object)("" + objectIndex));
        }
        return objectIndex;
    }

    private synchronized void extendObjectTable() throws ConversationStateFullException {
        int newTableSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"extendObjectTable");
        }
        if ((newTableSize = (this.maxIndex + 1) * 2 - 10) > this.maxTableSize) {
            if (this.maxIndex + 1 < this.maxTableSize) {
                newTableSize = this.maxTableSize;
            } else {
                ConversationStateFullException e = new ConversationStateFullException();
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".extendObjectTable"), (String)"5-004-0001", (Object[])new Object[]{this.getLastItemsInStore(), this});
                throw e;
            }
        }
        Object[] newObjectTable = new Object[newTableSize];
        System.arraycopy(this.objectTable, 0, newObjectTable, 0, this.maxIndex + 1);
        this.freeSlot = this.maxIndex + 1;
        this.maxIndex = newTableSize - 1;
        this.objectTable = newObjectTable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Next free slot = ", (Object)this.freeSlot);
            SibTr.debug((TraceComponent)tc, (String)"Max Index = ", (Object)this.maxIndex);
            SibTr.debug((TraceComponent)tc, (String)"High Water Mark = ", (Object)this.highWatermark);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"extendObjectTable");
        }
    }

    public synchronized Object getObject(int objectIndex) throws IndexOutOfBoundsException, NoSuchElementException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObject", (Object)("" + objectIndex));
        }
        if (objectIndex < 10 || objectIndex > this.maxIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid object index");
            }
            throw new IndexOutOfBoundsException();
        }
        Object object = this.objectTable[objectIndex];
        if (object == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No such element existed!");
            }
            throw new NoSuchElementException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObject", (Object)object);
        }
        return object;
    }

    public synchronized Object removeObject(int objectIndex) throws IndexOutOfBoundsException, NoSuchElementException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeObject", (Object)objectIndex);
        }
        if (objectIndex < 10) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid object index");
            }
            throw new IndexOutOfBoundsException();
        }
        if (objectIndex > this.maxIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid object index");
            }
            return null;
        }
        if (this.objectTable[objectIndex] == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No object exists at the entry");
            }
            throw new NoSuchElementException();
        }
        Object returnObject = this.objectTable[objectIndex];
        this.objectTable[objectIndex] = null;
        this.freeSlot = this.freeSlot == -1 ? objectIndex : Math.min(this.freeSlot, objectIndex);
        if (this.highWatermark == objectIndex) {
            while (this.objectTable[this.highWatermark] == null && this.highWatermark != 10) {
                --this.highWatermark;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeObject", (Object)returnObject);
        }
        return returnObject;
    }

    public synchronized List getAllObjects() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllObjects");
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            objs.add(this.objectTable[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllObjects", objs);
        }
        return objs;
    }

    public void dumpObjectTable(int numberOfEntries) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpObjectTable");
        }
        if (numberOfEntries < 0) {
            throw new IllegalArgumentException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (int i = 10; i < 10 + numberOfEntries; ++i) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("objectTable: " + i), (Object)this.objectTable[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpObjectTable");
        }
    }

    public CommsConnection getCommsConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCommsConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCommsConnection", (Object)this.cc);
        }
        return this.cc;
    }

    public void setCommsConnection(CommsConnection cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCommsConnection", (Object)cc);
        }
        this.cc = cc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCommsConnection");
        }
    }

    public void setInitialRequestNumber(int initialRequestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInitialRequestNumber", (Object)initialRequestNumber);
        }
        this.requestNumber = initialRequestNumber;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInitialRequestNumber");
        }
    }

    public synchronized int getUniqueRequestNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueRequestNumber");
        }
        this.requestNumber += 2;
        if (this.requestNumber > Short.MAX_VALUE) {
            this.requestNumber %= 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueRequestNumber", (Object)("" + this.requestNumber));
        }
        return this.requestNumber;
    }

    public synchronized String getLastItemsInStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastItemsInStore");
        }
        String lastItems = "";
        for (int x = this.maxIndex; x > this.maxIndex - 101; --x) {
            lastItems = " [" + x + "]: " + this.objectTable[x] + "\r\n" + lastItems;
        }
        lastItems = "The last 100 items in the store:\r\n\r\n" + lastItems;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLastItemsInStore");
        }
        return lastItems;
    }

    public ChunkedMessageWrapper getChunkedMessageWrapper(long wrapperId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getChunkedMessageWrapper", (Object)wrapperId);
        }
        ChunkedMessageWrapper wrapper = this.inProgressMessages.get(wrapperId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getChunkedMessageWrapper", (Object)wrapper);
        }
        return wrapper;
    }

    public void putChunkedMessageWrapper(long wrapperId, ChunkedMessageWrapper wrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putChunkedMessageWrapper", (Object)new Object[]{wrapperId, wrapper});
        }
        this.inProgressMessages.put(wrapperId, wrapper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putChunkedMessageWrapper");
        }
    }

    public void removeChunkedMessageWrapper(long wrapperId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeChunkedMessageWrapper", (Object)wrapperId);
        }
        this.inProgressMessages.remove(wrapperId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeChunkedMessageWrapper");
        }
    }

    public void setMETerminated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMETerminated");
        }
        this.hasMETerminated = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMETerminated");
        }
    }

    public boolean hasMETerminated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasMETerminated");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasMETerminated", (Object)this.hasMETerminated);
        }
        return this.hasMETerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationListenerCache getDestinationListenerCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationListenerCache");
        }
        if (this.destinationListenerCache == null) {
            ConversationState conversationState = this;
            synchronized (conversationState) {
                if (this.destinationListenerCache == null) {
                    this.destinationListenerCache = new DestinationListenerCache();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationListenerCache", (Object)this.destinationListenerCache);
        }
        return this.destinationListenerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerMonitorListenerCache getConsumerMonitorListenerCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerMonitorListenerCache");
        }
        if (this.consumerMonitorListenerCache == null) {
            ConversationState conversationState = this;
            synchronized (conversationState) {
                if (this.consumerMonitorListenerCache == null) {
                    this.consumerMonitorListenerCache = new ConsumerMonitorListenerCache();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerMonitorListenerCache", (Object)this.consumerMonitorListenerCache);
        }
        return this.consumerMonitorListenerCache;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/ConversationState.java, SIB.comms, WASX.SIB, aa1225.01 1.48");
        }
    }
}

