/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class CATAsynchConsumer
extends CATConsumer
implements StoppableAsynchConsumerCallback {
    private static String CLASS_NAME = CATAsynchConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATAsynchConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final CATMainConsumer mainConsumer;

    public CATAsynchConsumer(CATMainConsumer mainConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)mainConsumer);
        }
        this.mainConsumer = mainConsumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    protected ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        ConsumerSession sess = this.mainConsumer.getConsumerSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)sess);
        }
        return sess;
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        Conversation conv = this.mainConsumer.getConversation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)conv);
        }
        return conv;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        int lowestPri = this.mainConsumer.getLowestPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)lowestPri);
        }
        return lowestPri;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        short sessId = this.mainConsumer.getClientSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        return sessId;
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        Reliability rel = this.mainConsumer.getUnrecoverableReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        return rel;
    }

    @Override
    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext, boolean stoppable, int maxSequentialFailures, long hiddenMessageDelay) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay});
        }
        try {
            boolean inlineCallbacks = CommsUtils.getRuntimeBooleanProperty((String)"sib.comms.InlineAsyncCBacks", (String)CommsConstants.INLINE_ASYNC_CBACKS);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Inline async callbacks: " + inlineCallbacks));
            }
            MPConsumerSession session = (MPConsumerSession)this.getConsumerSession();
            if (stoppable) {
                session.registerStoppableAsynchConsumerCallback((StoppableAsynchConsumerCallback)this, maxActiveMessages, messageLockExpiry, batchsize, this.getUnrecoverableReliability(), inlineCallbacks, orderContext, maxSequentialFailures, hiddenMessageDelay);
            } else {
                session.registerAsynchConsumerCallback((AsynchConsumerCallback)this, maxActiveMessages, messageLockExpiry, batchsize, this.getUnrecoverableReliability(), inlineCallbacks, orderContext);
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 211, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-018-0001", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-018-0002", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-018-0002", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to unlock " + msgHandles.length + " message(s)"));
        }
        try {
            this.getConsumerSession().unlockSet(msgHandles);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0004", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0003", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-018-0003", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2002", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply, boolean incrementLockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply, incrementLockCount});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to unlock " + msgHandles.length + " message(s)"));
        }
        try {
            this.getConsumerSession().unlockSet(msgHandles, incrementLockCount);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0015", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-018-0014", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-018-0014", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2002", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void deleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{requestNumber, msgHandles, tran, reply});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to delete " + msgHandles.length + " message(s)"));
            if (reply) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Client is expecting a reply");
            }
        }
        try {
            SITransaction siTran = ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().get(tran);
            if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                this.getConsumerSession().deleteSet(msgHandles, siTran);
            }
            try {
                if (reply) {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 219, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-024-0003", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-018-0005", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-018-0005", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_MSGS_SICO2028", (Object)((Object)e));
            if (tran != 0) {
                ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().markAsRollbackOnly(tran, e);
            }
            StaticCATHelper.sendAsyncExceptionToClient(e, "3-018-0005", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)requestNumber);
        }
        CATConsumer.State returnToState = CATConsumer.State.UNDEFINED;
        try {
            this.stateLock.lock();
            try {
                this.awaitStableState();
                returnToState = this.setState(CATConsumer.State.PAUSED);
            }
            finally {
                this.stateLock.unlock();
            }
            boolean wasStarted = returnToState.isStarted();
            boolean restart = false;
            if (wasStarted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping the consumer session");
                }
                this.getConsumerSession().stop();
                returnToState = CATConsumer.State.STOPPED;
                restart = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer not fully started");
            }
            CATAsynchConsumer cATAsynchConsumer = this;
            synchronized (cATAsynchConsumer) {
                this.mainConsumer.incremenetMessageBatchNumber();
                this.getConsumerSession().unlockAll();
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 216, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0007", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
            }
            if (restart) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting the consumer session");
                }
                this.getConsumerSession().start(false);
                returnToState = CATConsumer.State.STARTED;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer was not fully started");
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0006", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-018-0006", this.getConversation(), requestNumber);
        }
        catch (InterruptedException ie) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)ie.getMessage(), (Object)ie);
            }
        }
        finally {
            if (CATConsumer.State.UNDEFINED != returnToState) {
                this.setState(returnToState);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    @Override
    public void flush(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)("" + requestNumber));
        }
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
            }
            this.getConsumerSession().activateAsynchConsumer(true);
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().start(false);
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 215, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-024-0001", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-024-0002", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-024-0002", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
        }
    }

    private boolean sendMessage(SIBusMessage sibMessage, boolean lastMsg, Integer priority) throws MessageEncodeFailedException, IncorrectMessageTypeException, MessageCopyFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)new Object[]{sibMessage, lastMsg, priority});
        }
        boolean ok = false;
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        ok = props.getFapLevel() >= 9 ? this.sendChunkedMessage(sibMessage, lastMsg, priority) : this.sendEntireMessage(sibMessage, null, lastMsg, priority);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)ok);
        }
        return ok;
    }

    private boolean sendChunkedMessage(SIBusMessage sibMessage, boolean lastMsg, Integer priority) throws MessageEncodeFailedException, IncorrectMessageTypeException, MessageCopyFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)new Object[]{sibMessage, lastMsg, priority});
        }
        boolean ok = true;
        short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)priority);
        int msgLen = 0;
        CommsServerByteBuffer buffer = poolManager.allocate();
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        try {
            List messageSlices = buffer.encodeFast((AbstractMessage)((JsMessage)sibMessage), convState.getCommsConnection(), this.getConversation());
            for (DataSlice slice : messageSlices) {
                msgLen += slice.getLength();
            }
            if (msgLen < 1024000) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
                }
                this.sendEntireMessage(sibMessage, messageSlices, lastMsg, priority);
            } else {
                for (int x = 0; x < messageSlices.size(); ++x) {
                    DataSlice slice;
                    slice = (DataSlice)messageSlices.get(x);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                    }
                    boolean first = x == 0;
                    boolean last = x == messageSlices.size() - 1;
                    byte flags = 0;
                    if (first) {
                        flags = (byte)(flags | 1);
                    }
                    if (last) {
                        flags = (byte)(flags | 4);
                    } else if (!first) {
                        flags = (byte)(flags | 2);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                    }
                    if (!first) {
                        buffer = poolManager.allocate();
                    }
                    short msgFlags = 0;
                    if (lastMsg) {
                        msgFlags = (short)(msgFlags | 1);
                    }
                    buffer.putShort(convState.getConnectionObjectId());
                    buffer.putShort(this.mainConsumer.getClientSessionId());
                    buffer.putShort(msgFlags);
                    buffer.putShort(this.mainConsumer.getMessageBatchNumber());
                    buffer.put(flags);
                    buffer.putDataSlice(slice);
                    this.getConversation().send((JFapByteBuffer)buffer, 248, 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"3-018-0011", (Object)this);
            ok = false;
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)ok);
        }
        return ok;
    }

    private boolean sendEntireMessage(SIBusMessage sibMessage, List<DataSlice> messageSlices, boolean lastMsg, Integer priority) throws MessageEncodeFailedException, IncorrectMessageTypeException, MessageCopyFailedException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{sibMessage, messageSlices, lastMsg, priority});
        }
        if (lastMsg && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending last in batch");
        }
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        boolean ok = true;
        try {
            CommsServerByteBuffer byteBuffer = poolManager.allocate();
            int msgLen = 0;
            short msgFlags = 0;
            if (lastMsg) {
                msgFlags = (short)(msgFlags | 1);
            }
            byteBuffer.putShort(convState.getConnectionObjectId());
            byteBuffer.putShort(this.mainConsumer.getClientSessionId());
            byteBuffer.putShort(msgFlags);
            byteBuffer.putShort(this.mainConsumer.getMessageBatchNumber());
            msgLen = messageSlices == null ? byteBuffer.putMessage((JsMessage)sibMessage, convState.getCommsConnection(), this.getConversation()) : byteBuffer.putMessgeWithoutEncode(messageSlices);
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)priority);
            this.getConversation().send((JFapByteBuffer)byteBuffer, 221, 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendEntireMessage"), (String)"3-018-0012", (Object)this);
            ok = false;
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)ok);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumeMessages(LockedMessageEnumeration lme) {
        SIBusMessage jsMessage;
        int messageCount;
        Integer highestPriority;
        block38: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages", (Object)lme);
            }
            highestPriority = 0;
            messageCount = 0;
            jsMessage = null;
            try {
                while (true) {
                    if ((jsMessage = lme.nextLocked()) == null) {
                        lme.resetCursor();
                        break;
                    }
                    ++messageCount;
                    Integer currentPriority = jsMessage.getPriority();
                    if (currentPriority > highestPriority) {
                        highestPriority = currentPriority;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message " + jsMessage.getMessageHandle() + " has priority " + currentPriority));
                }
            }
            catch (SIException e) {
                if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-018-0009", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendAsyncExceptionToClient(e, "3-018-0009", this.getClientSessionId(), this.getConversation(), 0);
                try {
                    lme.resetCursor();
                }
                catch (SIException e1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block38;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e1.getMessage(), (Object)((Object)e1));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("There are " + messageCount + " messages in the LME"));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("The highest message priority is " + highestPriority));
        }
        Object xctErrStr = null;
        boolean ok = true;
        for (int currMessCount = 0; currMessCount < messageCount && ok; ++currMessCount) {
            try {
                jsMessage = lme.nextLocked();
                if (currMessCount + 1 == messageCount) {
                    CATConsumer.State returnState = CATConsumer.State.UNDEFINED;
                    this.stateLock.lock();
                    try {
                        this.awaitStableState();
                        returnState = this.setState(CATConsumer.State.STOPPING);
                    }
                    finally {
                        this.stateLock.unlock();
                    }
                    try {
                        this.getConsumerSession().stop();
                        returnState = CATConsumer.State.STOPPED;
                    }
                    finally {
                        this.setState(returnState);
                    }
                    ++this.batchesSent;
                    ++this.messagesSent;
                    ok = this.sendMessage(jsMessage, true, highestPriority);
                } else {
                    ok = this.sendMessage(jsMessage, false, highestPriority);
                    ++this.messagesSent;
                }
                if (CommsUtils.isRecoverable((SIBusMessage)jsMessage, (Reliability)this.mainConsumer.getUnrecoverableReliability())) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Deleting message");
                }
                lme.deleteCurrent(null);
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof SIException) || !((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-018-0010");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendAsyncExceptionToClient(e, "3-018-0010", this.getClientSessionId(), this.getConversation(), 0);
                try {
                    CATConsumer.State returnState = CATConsumer.State.UNDEFINED;
                    try {
                        this.stateLock.lock();
                        try {
                            try {
                                this.awaitStableState();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            returnState = this.setState(CATConsumer.State.STOPPING);
                        }
                        finally {
                            this.stateLock.unlock();
                        }
                        this.getConsumerSession().stop();
                        returnState = CATConsumer.State.STOPPED;
                    }
                    finally {
                        this.setState(returnState);
                    }
                }
                catch (SIException e1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e1.getMessage(), (Object)((Object)e1));
                }
                break;
            }
        }
        this.mainConsumer.setLowestPriority(JFapChannelConstants.getJFAPPriority((Integer)highestPriority));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
        }
    }

    public void consumerSessionStopped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumerSessionStopped");
        }
        this.mainConsumer.stopStoppableSession();
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        CommsServerByteBuffer buffer = poolManager.allocate();
        buffer.putShort(convState.getConnectionObjectId());
        buffer.putShort(this.getClientSessionId());
        try {
            this.getConversation().send((JFapByteBuffer)buffer, 123, 0, 7, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumerSessionStopped"), (String)"3-018-0013", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumerSessionStopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(int requestNumber, boolean incrementUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{requestNumber, incrementUnlockCount});
        }
        CATConsumer.State returnToState = CATConsumer.State.UNDEFINED;
        try {
            this.stateLock.lock();
            try {
                this.awaitStableState();
                returnToState = this.setState(CATConsumer.State.PAUSED);
            }
            finally {
                this.stateLock.unlock();
            }
            boolean wasStarted = returnToState.isStarted();
            boolean restart = false;
            if (wasStarted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping the consumer session");
                }
                this.getConsumerSession().stop();
                returnToState = CATConsumer.State.STOPPED;
                restart = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer not fully started");
            }
            CATAsynchConsumer cATAsynchConsumer = this;
            synchronized (cATAsynchConsumer) {
                this.mainConsumer.incremenetMessageBatchNumber();
                this.getConsumerSession().unlockAll(incrementUnlockCount);
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)this.mainConsumer.getLowestPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 135, requestNumber, (int)jfapPriority, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0016", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2017", (Object)((Object)e));
            }
            if (restart) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting the consumer session");
                }
                this.getConsumerSession().start(false);
                returnToState = CATConsumer.State.STARTED;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer was not fully started");
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-018-0017", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-018-0017", this.getConversation(), requestNumber);
        }
        catch (InterruptedException ie) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)ie.getMessage(), (Object)ie);
            }
        }
        finally {
            if (CATConsumer.State.UNDEFINED != returnToState) {
                this.setState(returnToState);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATAsynchConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.99");
        }
    }
}

