/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.List;

public class CATBrowseConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATBrowseConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATBrowseConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private CATMainConsumer mainConsumer = null;
    private long sentBytes = 0L;
    private short msgBatch = 0;

    public CATBrowseConsumer(CATMainConsumer mainConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)mainConsumer);
        }
        this.mainConsumer = mainConsumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    private long sendMessage(SIBusMessage msg) throws OperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)msg);
        }
        long retValue = 0L;
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        retValue = props.getFapLevel() >= 9 ? this.sendChunkedMessage(msg) : this.sendEntireMessage(msg, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessage", (Object)("" + retValue));
        }
        return retValue;
    }

    private long sendEntireMessage(SIBusMessage msg, List<DataSlice> messageSlices) throws OperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{msg, messageSlices});
        }
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        long retValue = 0L;
        CommsServerByteBuffer buffer = poolManager.allocate();
        try {
            buffer.putShort(convState.getConnectionObjectId());
            buffer.putShort(this.mainConsumer.getClientSessionId());
            buffer.putShort(this.msgBatch);
            int msgLen = 0;
            msgLen = messageSlices == null ? buffer.putMessage((JsMessage)msg, convState.getCommsConnection(), this.getConversation()) : buffer.putMessgeWithoutEncode(messageSlices);
            try {
                retValue = this.getConversation().send((JFapByteBuffer)buffer, 222, 0, -1, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendEntireMessage"), (String)"3-023-0002", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2012", (Object)((Object)e));
                throw new OperationFailedException();
            }
        }
        catch (Exception e) {
            if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendEntireMessage"), (String)"3-023-0001", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            }
            if (e instanceof SIConnectionDroppedException) {
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2012", (Object)e);
                throw new OperationFailedException();
            }
            SIResourceException coreException = new SIResourceException();
            coreException.initCause((Throwable)e);
            StaticCATHelper.sendAsyncExceptionToClient((Throwable)coreException, "3-023-0001", this.getClientSessionId(), this.getConversation(), 0);
            throw new OperationFailedException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)retValue);
        }
        return retValue;
    }

    private long sendChunkedMessage(SIBusMessage sibMessage) throws OperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)sibMessage);
        }
        long retValue = 0L;
        CommsServerByteBuffer buffer = poolManager.allocate();
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        try {
            List messageSlices = buffer.encodeFast((AbstractMessage)((JsMessage)sibMessage), convState.getCommsConnection(), this.getConversation());
            int msgLen = 0;
            for (DataSlice slice : messageSlices) {
                msgLen += slice.getLength();
            }
            if (msgLen < 1024000) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
                }
                retValue = this.sendEntireMessage(sibMessage, messageSlices);
            } else {
                short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)sibMessage.getPriority());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
                }
                try {
                    for (int x = 0; x < messageSlices.size(); ++x) {
                        DataSlice slice = (DataSlice)messageSlices.get(x);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                        }
                        boolean first = x == 0;
                        boolean last = x == messageSlices.size() - 1;
                        byte flags = 0;
                        if (first) {
                            flags = (byte)(flags | 1);
                        }
                        if (last) {
                            flags = (byte)(flags | 4);
                        } else if (!first) {
                            flags = (byte)(flags | 2);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                        }
                        if (!first) {
                            buffer = poolManager.allocate();
                        }
                        buffer.putShort(convState.getConnectionObjectId());
                        buffer.putShort(this.mainConsumer.getClientSessionId());
                        buffer.putShort(this.msgBatch);
                        buffer.put(flags);
                        buffer.putDataSlice(slice);
                        retValue = this.getConversation().send((JFapByteBuffer)buffer, 249, 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    ++this.messagesSent;
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"3-023-0007", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2012", (Object)((Object)e));
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"3-023-0008", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            }
            if (e instanceof SIConnectionDroppedException) {
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2012", (Object)e);
                throw new OperationFailedException();
            }
            SIResourceException coreException = new SIResourceException();
            coreException.initCause((Throwable)e);
            StaticCATHelper.sendAsyncExceptionToClient((Throwable)coreException, "3-023-0008", this.getClientSessionId(), this.getConversation(), 0);
            throw new OperationFailedException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)retValue);
        }
        return retValue;
    }

    private SIBusMessage getNextMessage(BrowserSession browserSession, Conversation conversation, short requestNumber) throws OperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextMessage", (Object)new Object[]{browserSession, conversation, "" + requestNumber});
        }
        SIBusMessage msg = null;
        try {
            msg = browserSession.next();
        }
        catch (SIException e) {
            if (!((ConversationState)conversation.getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getNextMessage"), (String)"3-023-0003", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-023-0003", conversation, requestNumber);
            throw new OperationFailedException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextMessage", (Object)msg);
        }
        return msg;
    }

    @Override
    public void requestMsgs(int requestNumber, int receiveBytes, int requestedBytes) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestMessages", (Object)new Object[]{"" + requestNumber, "" + receiveBytes, "" + requestedBytes});
            }
            BrowserSession browserSession = this.mainConsumer.getBrowserSession();
            Conversation conversation = this.getConversation();
            this.sentBytes -= (long)receiveBytes;
            try {
                for (boolean done = this.sentBytes > (long)requestedBytes ? true : false; !done; done |= this.sentBytes > (long)requestedBytes) {
                    SIBusMessage msg = null;
                    msg = this.getNextMessage(browserSession, conversation, (short)requestNumber);
                    boolean bl = done = msg == null;
                    if (done) continue;
                    this.sentBytes += this.sendMessage(msg);
                }
            }
            catch (OperationFailedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestMessages");
        }
    }

    @Override
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        BrowserSession browserSession = this.mainConsumer.getBrowserSession();
        this.msgBatch = (short)(this.msgBatch + 1);
        browserSession.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public void flush(int requestNumber) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)("" + requestNumber));
            }
            BrowserSession browserSession = this.mainConsumer.getBrowserSession();
            SIBusMessage msg = null;
            try {
                msg = this.getNextMessage(browserSession, this.getConversation(), (short)requestNumber);
                if (msg != null) {
                    this.sendMessage(msg);
                }
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 215, requestNumber, -1, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-023-0004", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2012", (Object)((Object)e));
                }
            }
            catch (OperationFailedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
        }
    }

    @Override
    public void close(int requestNumber) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)("" + requestNumber));
            }
            BrowserSession browserSession = this.mainConsumer.getBrowserSession();
            try {
                browserSession.close();
            }
            catch (SIException e) {
                if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-023-0005", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-023-0005", this.getConversation(), requestNumber);
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 201, requestNumber, -1, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-023-0006", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @Override
    protected ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        ConsumerSession sess = this.mainConsumer.getConsumerSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)sess);
        }
        return sess;
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        Conversation conv = this.mainConsumer.getConversation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)conv);
        }
        return conv;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        int lowestPri = this.mainConsumer.getLowestPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)lowestPri);
        }
        return lowestPri;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        short sessId = this.mainConsumer.getClientSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        return sessId;
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        Reliability rel = this.mainConsumer.getUnrecoverableReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        return rel;
    }

    private class OperationFailedException
    extends Exception {
        private static final long serialVersionUID = -5191481178136106792L;

        private OperationFailedException() {
        }
    }
}

