/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.Map;

public class StaticCATConsumer {
    private static String CLASS_NAME = StaticCATConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(StaticCATConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateConsumerSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rcvCreateConsumerSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
            }
            String subscriptionName = null;
            ConversationState convState = (ConversationState)conversation.getAttachment();
            short connectionObjectID = request.getShort();
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectID);
            }
            short clientSessionId = request.getShort();
            short consumerFlags = request.getShort();
            short reliabilityShort = request.getShort();
            int requestedBytes = request.getInt();
            short destinationTypeShort = request.getShort();
            short unrecovShort = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"clientSessionId", (Object)clientSessionId);
                SibTr.debug((TraceComponent)tc, (String)"consumerFlags", (Object)consumerFlags);
                SibTr.debug((TraceComponent)tc, (String)"reliability", (Object)reliabilityShort);
                SibTr.debug((TraceComponent)tc, (String)"requestedBytes", (Object)requestedBytes);
                SibTr.debug((TraceComponent)tc, (String)"destinationType", (Object)destinationTypeShort);
                SibTr.debug((TraceComponent)tc, (String)"unrecovReliability", (Object)unrecovShort);
            }
            try {
                if (consumerFlags > 511) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Consumer flags (" + consumerFlags + ") > " + 511));
                    }
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8013", new Object[]{"" + consumerFlags}, null));
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerSess"), (String)"3-010-0004");
                    throw e;
                }
                boolean readAheadPermitted = (consumerFlags & 1) != 0;
                boolean noLocal = (consumerFlags & 2) != 0;
                boolean unicastRequested = (consumerFlags & 8) != 0;
                boolean bifurcatable = (consumerFlags & 0x40) != 0;
                boolean ignoreIndoubts = (consumerFlags & 0x80) != 0;
                boolean allowMessageGathering = (consumerFlags & 0x100) != 0;
                boolean supportsMultipleConsumers = (consumerFlags & 4) != 0;
                HandshakeProperties handshakeProps = conversation.getHandshakeProperties();
                short clientFapLevel = handshakeProps.getFapLevel();
                if (clientFapLevel < 5) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"FAP Version is <5 - setting ignoreInitialIndoubts to true");
                    }
                    ignoreIndoubts = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Flags:", (Object)new Object[]{"No Local: " + noLocal, "Bifurcatable: " + bifurcatable, "Ignore Initial Indoubts: " + ignoreIndoubts, "Allow Message Gathering: " + allowMessageGathering});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Selection criteria:", (Object)new Object[]{"Read ahead requested    : " + readAheadPermitted, "Unicast requested       : " + unicastRequested, "NoLocal                 : " + noLocal});
                }
                Reliability reliability = null;
                if (reliabilityShort != -1) {
                    reliability = Reliability.getReliability((int)reliabilityShort);
                }
                DestinationType destType = null;
                if (destinationTypeShort != -1) {
                    destType = DestinationType.getDestinationType((int)destinationTypeShort);
                }
                Reliability unrecoverableReliability = Reliability.getReliability((int)unrecovShort);
                SIDestinationAddress destAddr = request.getSIDestinationAddress(clientFapLevel);
                if (supportsMultipleConsumers && clientFapLevel >= 20) {
                    subscriptionName = request.getString();
                }
                SelectionCriteria criteria = request.getSelectionCriteria();
                String alternateUser = request.getString();
                Map messageControlProperties = null;
                if (clientFapLevel >= 9) {
                    messageControlProperties = request.getMap();
                }
                CATMainConsumer mainConsumer = null;
                short consSessionObjectID = 0;
                ConsumerSession consumerSession = null;
                consumerSession = subscriptionName != null ? connection.createSharedConsumerSession(subscriptionName, destAddr, destType, criteria, reliability, readAheadPermitted, supportsMultipleConsumers, readAheadPermitted, unrecoverableReliability, bifurcatable, alternateUser, ignoreIndoubts, allowMessageGathering, messageControlProperties) : connection.createConsumerSession(destAddr, destType, criteria, reliability, readAheadPermitted, noLocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreIndoubts, allowMessageGathering, messageControlProperties);
                mainConsumer = new CATMainConsumer(conversation, clientSessionId, consumerSession, readAheadPermitted, noLocal, unrecoverableReliability);
                consSessionObjectID = (short)convState.addObject(mainConsumer);
                mainConsumer.setConsumerSessionId(consSessionObjectID);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Consumer Session Id:", (Object)("" + consSessionObjectID));
                }
                StaticCATHelper.sendSessionCreateResponse(205, requestNumber, conversation, consSessionObjectID, (DestinationSession)consumerSession, destAddr);
                if (!readAheadPermitted) break block26;
                try {
                    mainConsumer.setRequestedBytes(requestedBytes);
                    mainConsumer.setAsynchConsumerCallback(requestNumber, 0, 0L, 1, null);
                    mainConsumer.start(requestNumber, false, false, null);
                }
                catch (RuntimeException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerSess"), (String)"3-010-0001");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to create readahead async consumer");
                        SibTr.exception((TraceComponent)tc, (Exception)((Exception)e.getCause()));
                    }
                    throw new SIResourceException(e.getMessage(), (Throwable)e);
                }
            }
            catch (ConversationStateFullException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerSess"), (String)"3-010-0002");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-010-0002", conversation, requestNumber);
            }
            catch (SINotAuthorizedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
            }
            catch (SIException e) {
                if (!convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerSess"), (String)"3-010-0003");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-010-0003", conversation, requestNumber);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateConsumerSess");
        }
    }

    static void rcvStartSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange, boolean restart) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvStartSess", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, restart});
        }
        short connectionObjectID = request.getShort();
        short consumerObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectID", (Object)consumerObjectID);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectID);
        mainConsumer.start(requestNumber, true, partOfExchange, null, restart);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvStartSess");
        }
    }

    static void rcvStopSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvStopSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectID = request.getShort();
        short consumerObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectID", (Object)consumerObjectID);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectID);
        mainConsumer.stop(requestNumber);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvStopSess");
        }
    }

    static void rcvRegisterAsyncConsumer(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange, boolean stoppable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvRegisterAsyncConsumer", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, stoppable});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        short orderContextId = request.getShort();
        short clientSessionId = request.getShort();
        int maxActiveMessages = request.getInt();
        long messageLockExpiry = request.getLong();
        int maxBatchSize = request.getInt();
        int maxSequentialFailures = 0;
        long hiddenMessageDelay = 0L;
        if (stoppable) {
            maxSequentialFailures = request.getInt();
            hiddenMessageDelay = request.getLong();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("connectionObjectID=" + connectionObjectId));
            SibTr.debug((TraceComponent)tc, (String)("consumerObjectID=" + consumerObjectId));
            SibTr.debug((TraceComponent)tc, (String)("orderContextID=" + orderContextId));
            SibTr.debug((TraceComponent)tc, (String)("clientSessionID=" + clientSessionId));
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessages=" + maxActiveMessages));
            SibTr.debug((TraceComponent)tc, (String)("messageLockExpiry=" + messageLockExpiry));
            SibTr.debug((TraceComponent)tc, (String)("maxBatchSize=" + maxBatchSize));
            SibTr.debug((TraceComponent)tc, (String)("maxSequentialFailures=" + maxSequentialFailures));
            SibTr.debug((TraceComponent)tc, (String)("hiddenMesageDelay=" + hiddenMessageDelay));
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        CATMainConsumer mainConsumer = (CATMainConsumer)convState.getObject(consumerObjectId);
        OrderingContext orderContext = null;
        if (orderContextId != 0) {
            orderContext = ((CATOrderingContext)convState.getObject(orderContextId)).getOrderingContext();
        }
        mainConsumer.setClientSessionId(clientSessionId);
        mainConsumer.setAsynchConsumerCallback(requestNumber, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvRegisterAsyncConsumer");
        }
    }

    static void rcvRequestMsgs(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvRequestMsgs", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectID = request.getShort();
        short consumerObjectID = request.getShort();
        int receivedBytes = request.getInt();
        int requestedBytes = request.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectID", (Object)consumerObjectID);
            SibTr.debug((TraceComponent)tc, (String)"receivedBytes", (Object)receivedBytes);
            SibTr.debug((TraceComponent)tc, (String)"requestedBytes", (Object)requestedBytes);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectID);
        mainConsumer.requestMsgs(requestNumber, receivedBytes, requestedBytes);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvRequestMsgs");
        }
    }

    static void rcvCloseConsumerSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCloseConsumerSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectID = request.getShort();
        short consumerObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectID", (Object)consumerObjectID);
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CATMainConsumer mainConsumer = (CATMainConsumer)conversationState.getObject(consumerObjectID);
        mainConsumer.close(requestNumber);
        conversationState.removeObject(consumerObjectID);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCloseConsumerSess");
        }
    }

    static void rcvSessReceive(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSessReceive", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        short connectionObjectID = request.getShort();
        short consumerObjectID = request.getShort();
        int transactionObjectId = request.getSITransactionId(connectionObjectID, linkState, optimizedTx);
        long timeout = request.getLong();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectID", (Object)consumerObjectID);
            SibTr.debug((TraceComponent)tc, (String)"transaction Id", (Object)transactionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"timeout", (Object)timeout);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)conversationState.getObject(consumerObjectID);
        mainConsumer.receive(requestNumber, transactionObjectId, timeout);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSessReceive");
        }
    }

    static void rcvFlushSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvFlushSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.flush(requestNumber);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvFlushSess");
        }
    }

    static void rcvDeregisterAsyncConsumer(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange, boolean stoppable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvDeregisterAsyncConsumer", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, stoppable});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.unsetAsynchConsumerCallback(requestNumber, stoppable);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvDeregisterAsyncConsumer");
        }
    }

    static void rcvUnlockAll(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvUnlockAll", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.unlockAll(requestNumber);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvUnlockAll");
        }
    }

    static void rcvUnlockSet(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvUnlockSet", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
        }
        SIMessageHandle[] msgHandles = request.getSIMessageHandles();
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        short fapLevel = conversation.getHandshakeProperties().getFapLevel();
        if (fapLevel >= 7 && fapLevel != 9) {
            byte incrementlockCountByte = request.get();
            boolean incrementlockCount = incrementlockCountByte == 1;
            mainConsumer.unlockSet(requestNumber, msgHandles, partOfExchange, incrementlockCount);
        } else {
            mainConsumer.unlockSet(requestNumber, msgHandles, partOfExchange);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvUnlockSet");
        }
    }

    static void rcvDeleteSet(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvDeleteSet", (Object)new Object[]{request, conversation, "" + requestNumber});
        }
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        int transactionId = request.getSITransactionId(connectionObjectId, linkState, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
            SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
        }
        SIMessageHandle[] siMsgHandles = request.getSIMessageHandles();
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.deleteSet(requestNumber, siMsgHandles, transactionId, partOfExchange);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvDeleteSet");
        }
    }

    static void rcvReadSet(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvReadSet", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
        }
        SIMessageHandle[] msgHandles = request.getSIMessageHandles();
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.readSet(requestNumber, msgHandles);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvReadSet");
        }
    }

    static void rcvReadAndDeleteSet(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvReadAndDeleteSet", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        int transactionId = request.getSITransactionId(connectionObjectId, linkState, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
            SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
        }
        SIMessageHandle[] msgHandles = request.getSIMessageHandles();
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.readAndDeleteSet(requestNumber, msgHandles, transactionId);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvReadAndDeleteSet");
        }
    }

    static void rcvCreateBifurcatedSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateBifurcatedSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        long mpSessionId = request.getLong();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectID));
            SibTr.debug((TraceComponent)tc, (String)"MP Session Id:", (Object)("" + mpSessionId));
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        try {
            BifurcatedConsumerSession bifConsumerSession = connection.createBifurcatedConsumerSession(mpSessionId);
            CATMainConsumer mainConsumer = new CATMainConsumer(conversation, 0, null, false, false, null);
            short consSessionObjectID = (short)convState.addObject(mainConsumer);
            mainConsumer.setConsumerSessionId(consSessionObjectID);
            mainConsumer.setBifurcatedSession(bifConsumerSession);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Consumer Session Id:", (Object)consSessionObjectID);
            }
            StaticCATHelper.sendSessionCreateResponse(232, requestNumber, conversation, consSessionObjectID, (DestinationSession)bifConsumerSession, null);
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateBifurcatedSess"), (String)"3-010-0005");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-010-0005", conversation, requestNumber);
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateBifurcatedSess"), (String)"3-010-0006");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-010-0006", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateBifurcatedSess");
        }
    }

    static void rcvUnlockAllWithUnlockCountFlag(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvUnlockAllWithUnlockCountFlag", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short consumerObjectId = request.getShort();
        boolean incrementUnlockCount = request.getBoolean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)consumerObjectId);
            SibTr.debug((TraceComponent)tc, (String)"incrementUnlockCount", (Object)incrementUnlockCount);
        }
        CATMainConsumer mainConsumer = (CATMainConsumer)((ConversationState)conversation.getAttachment()).getObject(consumerObjectId);
        mainConsumer.unlockAll(requestNumber, incrementUnlockCount);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvUnlockAllWithUnlockCountFlag");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.89.1.1");
        }
    }
}

