/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.server.AcceptListenerFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;

public abstract class ServerConnectionManager {
    private static final TraceComponent tc;
    private static ServerConnectionManager instance;
    private static boolean initialised;

    public static void initialise(AcceptListenerFactory _acceptListenerFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        if (!initialised) {
            block7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"not previously initialised");
                }
                Class<?> clientImpl = instance.getClass();
                try {
                    Method initialiseMethod = clientImpl.getMethod("initialise", AcceptListenerFactory.class);
                    initialiseMethod.invoke(clientImpl, _acceptListenerFactory);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.{}", (String)"00010001");
                    Throwable displayedException = e;
                    if (e instanceof InvocationTargetException) {
                        displayedException = e.getCause();
                    }
                    SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0003", (Object)new Object[]{clientImpl, displayedException});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            initialised = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public static void initialiseAcceptListenerFactory(AcceptListenerFactory _acceptListenerFactory) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initialiseAcceptListenerFactory", (Object)_acceptListenerFactory);
            }
            Class<?> clientImpl = instance.getClass();
            try {
                Method initialiseAcceptListenerFactoryMethod = clientImpl.getMethod("initialiseAcceptListenerFactory", AcceptListenerFactory.class);
                initialiseAcceptListenerFactoryMethod.invoke(clientImpl, _acceptListenerFactory);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.initialiseAcceptListenerFactory", (String)"00010003");
                Throwable displayedException = e;
                if (e instanceof InvocationTargetException) {
                    displayedException = e.getCause();
                }
                SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0081", (Object)new Object[]{clientImpl, displayedException});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseAcceptListenerFactory");
        }
    }

    public static synchronized ServerConnectionManager getRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRef");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRef");
        }
        return instance;
    }

    public abstract void closeAll(boolean var1);

    public abstract Conversation connect(InetSocketAddress var1, ConversationReceiveListener var2, String var3) throws SIResourceException;

    public abstract Conversation connect(CFEndPoint var1, ConversationReceiveListener var2) throws SIResourceException;

    public abstract List getActiveOutboundMEtoMEConversations();

    static {
        block5: {
            tc = SibTr.register(ServerConnectionManager.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.server/src/com/ibm/ws/sib/jfapchannel/ServerConnectionManager.java, SIB.comms, WASX.SIB, aa1225.01 1.34");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"<clinit>");
            }
            try {
                Class<?> serverImpl = Class.forName("com.ibm.ws.sib.jfapchannel.server.impl.ServerConnectionManagerImpl");
                Constructor<?> serverImplConstructor = serverImpl.getConstructor(new Class[0]);
                instance = (ServerConnectionManager)serverImplConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.initialise", (String)"00010002");
                SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0004", (Object)new Object[]{"<init>", "com.ibm.ws.sib.jfapchannel.server.impl.ServerConnectionManagerImpl", e});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<clinit>");
        }
        initialised = false;
    }
}

