/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.util.Map;

public class JFapDiscriminator
implements Discriminator {
    private static final TraceComponent tc = SibTr.register(JFapDiscriminator.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static byte[] EYECATCHER = new byte[]{-66, -17};
    private Channel channel = null;

    public JFapDiscriminator(Channel channel) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)channel);
        }
        this.channel = channel;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        int answer;
        WsByteBuffer[] dataArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"discriminate", (Object)new Object[]{vc, discrimData});
        }
        if ((dataArray = (WsByteBuffer[])discrimData) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"timeout prior to discrimination.");
            }
            answer = -1;
        } else {
            int i;
            WsByteBuffer data = null;
            int originalPosition = 0;
            int originalLimit = 0;
            switch (dataArray.length) {
                case 0: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"discriminate", (Object)"MAYBE");
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"discriminate");
                    }
                    return -1;
                }
                case 1: {
                    originalPosition = dataArray[0].position();
                    originalLimit = dataArray[0].limit();
                    data = dataArray[0].flip();
                    break;
                }
                default: {
                    int i2;
                    int totalAmount = 0;
                    for (i2 = 0; i2 < dataArray.length; ++i2) {
                        totalAmount += dataArray[i2].position();
                    }
                    data = CommsServerServiceFacade.getBufferPoolManager().allocate(totalAmount);
                    for (i2 = 0; i2 < dataArray.length; ++i2) {
                        originalPosition = dataArray[i2].position();
                        originalLimit = dataArray[i2].limit();
                        dataArray[i2].flip();
                        data.put(dataArray[i2]);
                        dataArray[i2].position(originalPosition);
                        dataArray[i2].limit(originalLimit);
                    }
                    data.flip();
                }
            }
            if (tc.isDebugEnabled()) {
                byte[] debugData = null;
                int start = 0;
                if (data.hasArray()) {
                    debugData = data.array();
                    start = data.arrayOffset() + data.position();
                } else {
                    debugData = new byte[32];
                    int pos = data.position();
                    data.get(debugData);
                    data.position(pos);
                    start = 0;
                }
                SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])debugData, (int)start, (int)32, (String)"Discrimination Data");
            }
            if (data.remaining() < EYECATCHER.length) {
                answer = -1;
                i = 0;
                while (data.remaining() > 0 && answer == -1) {
                    if (data.get() != EYECATCHER[i]) {
                        answer = 0;
                    }
                    ++i;
                }
            } else {
                answer = 1;
                for (i = 0; i < EYECATCHER.length && answer == 1; ++i) {
                    if (data.get() == EYECATCHER[i]) continue;
                    answer = 0;
                }
            }
            data.position(originalPosition);
            data.limit(originalLimit);
        }
        if (tc.isDebugEnabled()) {
            switch (answer) {
                case 1: {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"discriminate", (Object)"YES");
                    break;
                }
                case 0: {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"discriminate", (Object)"NO");
                    break;
                }
                case -1: {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"discriminate", (Object)"MAYBE");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"discriminate");
        }
        return answer;
    }

    public Class getDiscriminatoryDataType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDiscriminatorDataType");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDiscriminatorDataType");
        }
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getChannel");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getChannel", (Object)this.channel);
        }
        return this.channel;
    }

    public Map getProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProperties");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProperties");
        }
        return null;
    }

    public int getWeight() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWeight");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWeight");
        }
        return 0;
    }

    public void cleanUpState(VirtualConnection vc) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanUpState", (Object)vc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanUpState");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.server.impl/src/com/ibm/ws/sib/jfapchannel/impl/JFapDiscriminator.java, SIB.comms, WASX.SIB, aa1225.01 1.16");
        }
    }
}

