/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.EncodingLevel;
import com.ibm.ws.sib.api.jms.JmsDestInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.StringArrayWrapper;
import com.ibm.ws.sib.api.jms._FRPHelper;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsFactoryFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.api.jms.impl.URIDestinationCreator;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JmsDestinationImpl
implements JmsDestination,
ApiJmsConstants,
JmsInternalConstants,
_FRPHelper,
JmsDestInternals {
    private static TraceComponent tc;
    private static final long serialVersionUID = 1503547629070926432L;
    static final String NAME_SEPARATOR = "://";
    static final String DEST_PREFIX = "dest://";
    private static final JmsJcaReferenceUtils refUtils;
    private static MsgDestEncodingUtilsImpl destEncoder;
    protected Map<String, Object> properties = null;
    private byte replyReliabilityByte = (byte)-1;
    private transient String cachedEncodedString = null;
    private transient String cachedPartialEncodedString = null;
    private transient byte[][] cachedEncoding = new byte[EncodingLevel.values().length][];
    private transient SIDestinationAddress producerDestinationAddress = null;
    private transient SIDestinationAddress consumerDestinationAddress = null;

    JmsDestinationImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.properties = new HashMap<String, Object>();
        this.properties.put("readAhead", "AsConnection");
        this.properties.put("deliveryMode", "Application");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    JmsDestinationImpl(Reference ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)ref);
        }
        this.properties = refUtils.getMapFromReference(ref, MsgDestEncodingUtilsImpl.getDefaultJNDIProperties(this.getClass()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public String getDestName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestName");
        }
        String destName = (String)this.properties.get("DEST_NAME");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestName", (Object)destName);
        }
        return destName;
    }

    void setDestName(String destName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDestName", (Object)destName);
        }
        if (null == destName || "".equals(destName)) {
            throw (JMSException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"destName", destName}, tc);
        }
        this.updateProperty("DEST_NAME", destName);
        this.clearCachedProducerDestinationAddress();
        this.clearCachedConsumerDestinationAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDestName");
        }
    }

    @Override
    public String getDestDiscrim() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestDiscrim");
        }
        String destDiscrim = (String)this.properties.get("DEST_DISCRIM");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestDiscrim", (Object)destDiscrim);
        }
        return destDiscrim;
    }

    void setDestDiscrim(String destDiscrim) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDestDiscrim", (Object)destDiscrim);
        }
        this.updateProperty("DEST_DISCRIM", destDiscrim);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDestDiscrim");
        }
    }

    @Override
    public String getDeliveryMode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryMode");
        }
        String dm = (String)this.properties.get("deliveryMode");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryMode", (Object)dm);
        }
        return dm;
    }

    @Override
    public void setDeliveryMode(String x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)x);
        }
        if (!("Application".equals(x) || "NonPersistent".equals(x) || "Persistent".equals(x))) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"deliveryMode", x}, tc);
        }
        this.updateProperty("deliveryMode", x);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryMode");
        }
    }

    @Override
    public Long getTimeToLive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTimeToLive");
        }
        Long ttl = (Long)this.properties.get("timeToLive");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTimeToLive", (Object)ttl);
        }
        return ttl;
    }

    @Override
    public void setTimeToLive(Long x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)x);
        }
        if (x == null) {
            this.updateProperty("timeToLive", null);
        } else if (x == -2L) {
            this.updateProperty("timeToLive", null);
        } else if (x >= 0L && x <= 9191815209357175807L) {
            this.updateProperty("timeToLive", x);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"timeToLive", x}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
        }
    }

    @Override
    public Integer getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        Integer pri = (Integer)this.properties.get("priority");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)pri);
        }
        return pri;
    }

    @Override
    public void setPriority(Integer x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)x);
        }
        if (x == null) {
            this.updateProperty("priority", null);
        } else if (x == -2) {
            this.updateProperty("priority", null);
        } else if (0 <= x && x <= 9) {
            this.updateProperty("priority", x);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"priority", x}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    @Override
    public String getReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReadAhead");
        }
        String ra = (String)this.properties.get("readAhead");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReadAhead", (Object)ra);
        }
        return ra;
    }

    @Override
    public void setReadAhead(String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReadAhead", (Object)value);
        }
        if (value == null || "".equals(value) || !"AsConnection".equals(value) && !"AlwaysOn".equals(value) && !"AlwaysOff".equals(value)) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"readAhead", value}, tc);
        }
        this.updateProperty("readAhead", value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReadAhead");
        }
    }

    @Override
    public String getBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBusName");
        }
        String busName = (String)this.properties.get("busName");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBusName", (Object)busName);
        }
        return busName;
    }

    @Override
    public void setBusName(String busName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBusName", (Object)busName);
        }
        if (busName != null && busName.equals("")) {
            busName = null;
        }
        this.updateProperty("busName", busName);
        this.clearCachedProducerDestinationAddress();
        this.clearCachedConsumerDestinationAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBusName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference() throws NamingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReference");
        }
        Reference ref = new Reference(this.getClass().getName(), JmsFactoryFactoryImpl.class.getName(), null);
        Map<String, Object> map = this.properties;
        synchronized (map) {
            refUtils.populateReference(ref, this.properties, MsgDestEncodingUtilsImpl.getDefaultJNDIProperties(this.getClass()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReference", (Object)ref);
        }
        return ref;
    }

    protected Reliability getReplyReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReplyReliability");
        }
        Reliability result = null;
        if (this.replyReliabilityByte != -1) {
            result = Reliability.getReliability((int)this.replyReliabilityByte);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReplyReliability", (Object)result);
        }
        return result;
    }

    protected void setReplyReliability(Reliability replyReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyReliability", (Object)replyReliability);
        }
        this.replyReliabilityByte = replyReliability.toByte();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyReliability");
        }
    }

    @Override
    public boolean _getInhibitJMSDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_getInhibitJMSDestination");
        }
        boolean value = false;
        if (this.properties.get("inhibitJMSDest") != null) {
            value = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_getInhibitJMSDestination", (Object)value);
        }
        return value;
    }

    @Override
    public void _setInhibitJMSDestination(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setInhibitJMSDestination", (Object)value);
        }
        if (value) {
            this.properties.put("inhibitJMSDest", "yes");
        } else {
            this.properties.remove("inhibitJMSDest");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setInhibitJMSDestination");
        }
    }

    @Override
    public Integer getBlockedDestinationCode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBlockedDestinationCode");
        }
        Integer code = (Integer)this.properties.get("blockedDestinationCode");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBlockedDestinationCode", (Object)code);
        }
        return code;
    }

    @Override
    public void setBlockedDestinationCode(Integer code) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBlockedDestinationCode", (Object)code);
        }
        this.updateProperty("blockedDestinationCode", code);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBlockedDestinationCode");
        }
    }

    protected boolean isProducerTypeCheck() {
        List totalPath;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isProducerTypeCheck");
        }
        boolean checking = true;
        StringArrayWrapper frp = (StringArrayWrapper)this.properties.get("forwardRP");
        if (frp != null && (totalPath = frp.getMsgForwardRoutingPath()) != null && totalPath.size() > 0) {
            checking = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isProducerTypeCheck", (Object)checking);
        }
        return checking;
    }

    protected String getProducerDestName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducerDestName");
        }
        String pDestName = null;
        StringArrayWrapper frp = (StringArrayWrapper)this.properties.get("forwardRP");
        if (frp == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No forward routing path to examine");
            }
            pDestName = this.getDestName();
        } else {
            SIDestinationAddress producerAddr;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"There is a forward routing path to examine.");
            }
            if ((producerAddr = frp.getProducerSIDestAddress()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using first element of FRP as producer dest name");
                }
                pDestName = producerAddr.getDestinationName();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"FRP is empty - use original dest name");
                }
                pDestName = this.getDestName();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducerDestName", (Object)pDestName);
        }
        return pDestName;
    }

    protected String getConsumerDestName() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerDestName");
        }
        String cDestName = this.getDestName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerDestName", (Object)cDestName);
        }
        return cDestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getCopyOfProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCopyOfProperties");
        }
        HashMap<String, Object> temp = null;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            temp = new HashMap<String, Object>(this.properties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCopyOfProperties", temp);
        }
        return temp;
    }

    byte[] encodeToBytes(EncodingLevel encodingLevel) throws JMSException {
        if (this.cachedEncoding[encodingLevel.ordinal()] == null) {
            this.cachedEncoding[encodingLevel.ordinal()] = destEncoder.getMessageRepresentationFromDest(this, encodingLevel);
        }
        return this.cachedEncoding[encodingLevel.ordinal()];
    }

    @Override
    public void setForwardRoutingPath(String[] forwardPath) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath", forwardPath == null ? null : Arrays.asList(forwardPath));
        }
        if (forwardPath != null && forwardPath.length == 0) {
            forwardPath = null;
        }
        if (forwardPath != null) {
            for (int i = 0; i < forwardPath.length; ++i) {
                if (forwardPath[i] != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Element " + i + " of the array is null."));
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"forwardPath[" + i + "]", "null"}, tc);
            }
        }
        this.clearCachedEncodings();
        this.clearCachedProducerDestinationAddress();
        if (forwardPath != null) {
            this.properties.put("forwardRP", StringArrayWrapper.create(forwardPath, this.getDestName()));
        } else {
            this.properties.remove("forwardRP");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath");
        }
    }

    @Override
    public void setReverseRoutingPath(String[] reversePath) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath", reversePath == null ? null : Arrays.asList(reversePath));
        }
        if (reversePath != null && reversePath.length == 0) {
            reversePath = null;
        }
        if (reversePath != null) {
            for (int i = 0; i < reversePath.length; ++i) {
                if (reversePath[i] != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Element " + i + " of the array is null."));
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"reversePath[" + i + "]", "null"}, tc);
            }
        }
        this.clearCachedEncodings();
        if (reversePath != null) {
            this.properties.put("reverseRP", StringArrayWrapper.create(reversePath, this.getDestName()));
        } else {
            this.properties.remove("reverseRP");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath");
        }
    }

    protected List getConvertedFRP() {
        List theList = null;
        StringArrayWrapper saw = (StringArrayWrapper)this.properties.get("forwardRP");
        if (saw != null) {
            theList = saw.getMsgForwardRoutingPath();
        }
        return theList;
    }

    protected List getConvertedRRP() {
        List theList = null;
        StringArrayWrapper saw = (StringArrayWrapper)this.properties.get("reverseRP");
        if (saw != null) {
            theList = saw.getCorePath();
        }
        return theList;
    }

    protected SIDestinationAddress getProducerSIDestinationAddress() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducerSIDestinationAddress");
        }
        if (this.producerDestinationAddress == null) {
            StringArrayWrapper frp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No cached value");
            }
            if ((frp = (StringArrayWrapper)this.properties.get("forwardRP")) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Obtain from the frp data.");
                }
                this.producerDestinationAddress = frp.getProducerSIDestAddress();
            }
            if (this.producerDestinationAddress == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Either FRP was empty, or no FRP at all - create from big dest info.");
                }
                boolean localOnly = this.isLocalOnly();
                this.producerDestinationAddress = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(this.getProducerDestName(), localOnly, this.getBusName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducerSIDestinationAddress", (Object)this.producerDestinationAddress);
        }
        return this.producerDestinationAddress;
    }

    protected SIDestinationAddress getConsumerSIDestinationAddress() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSIDestinationAddress");
        }
        if (this.consumerDestinationAddress == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No cached value - create a new one.");
            }
            boolean localOnly = this.isLocalOnly();
            this.consumerDestinationAddress = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(this.getConsumerDestName(), localOnly, this.getBusName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSIDestinationAddress", (Object)this.consumerDestinationAddress);
        }
        return this.consumerDestinationAddress;
    }

    protected boolean isLocalOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isLocalOnly");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isLocalOnly", (Object)false);
        }
        return false;
    }

    static JmsDestinationImpl checkNativeInstance(Destination destination) throws InvalidDestinationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNativeInstance", (Object)destination);
        }
        JmsDestinationImpl castDest = null;
        if (destination == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"Destination", null}, tc);
        }
        if (!(destination instanceof JmsDestinationImpl)) {
            JMSException rootCause = null;
            String destToString = destination.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Dynamic proxy has been provided instead of a destination: " + destToString));
            }
            try {
                if (destination instanceof Queue) {
                    castDest = (JmsDestinationImpl)((Object)JmsFactoryFactory.getInstance().createQueue(destToString));
                } else if (destination instanceof Topic) {
                    castDest = (JmsDestinationImpl)((Object)JmsFactoryFactory.getInstance().createTopic(destToString));
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"A destination must be either a queue or a topic");
                }
            }
            catch (JMSException jmse) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Failed to convert the dynamic proxy to a JmsDestinationImpl object;");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)jmse));
                }
                rootCause = jmse;
            }
            if (castDest == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "FOREIGN_IMPLEMENTATION_CWSIA0046", new Object[]{destination}, rootCause, null, JmsDestinationImpl.class, tc);
            }
        } else {
            castDest = (JmsDestinationImpl)destination;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNativeInstance", (Object)castDest);
        }
        return castDest;
    }

    static void checkBlockedStatus(JmsDestinationImpl dest) throws JMSException {
        Integer code;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBlockedStatus", (Object)dest);
        }
        if ((code = dest.getBlockedDestinationCode()) != null) {
            if (code.equals(JmsInternalConstants.PSB_REPLY_DATA_MISSING)) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DESTINATION_BLOCKED_PSBREPLY_CWSIA0284", new Object[]{dest.toString()}, tc);
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DESTINATION_BLOCKED_CWSIA0283", new Object[]{code}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBlockedStatus");
        }
    }

    static JmsDestinationImpl getJMSReplyToInternal(JsJmsMessage _msg, List<SIDestinationAddress> rrp, SICoreConnection _siConn) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJMSReplyToInternal", (Object)new Object[]{_msg, rrp, _siConn});
        }
        JmsDestinationImpl tempReplyTo = null;
        byte[] replyURIBytes = _msg.getJmsReplyTo();
        if (replyURIBytes != null) {
            tempReplyTo = (JmsDestinationImpl)JmsInternalsFactory.getMessageDestEncodingUtils().getDestinationFromMsgRepresentation(replyURIBytes);
        }
        if (tempReplyTo == null) {
            SIDestinationAddress sida = null;
            if (rrp.size() > 0) {
                block12: {
                    int lastDestInRRP = rrp.size() - 1;
                    sida = rrp.get(lastDestInRRP);
                    if (_siConn != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Determine reply dest type using SICoreConnection");
                        }
                        try {
                            DestinationConfiguration destConfig = _siConn.getDestinationConfiguration(sida);
                            DestinationType destType = destConfig.getDestinationType();
                            tempReplyTo = destType == DestinationType.TOPICSPACE ? new JmsTopicImpl() : new JmsQueueImpl();
                        }
                        catch (SIException sice) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                            SibTr.debug((TraceComponent)tc, (String)("failed to look up dest type because of " + (Object)((Object)sice)));
                            SibTr.debug((TraceComponent)tc, (String)"detail ", (Object)((Object)sice));
                        }
                    }
                }
                if (tempReplyTo == null) {
                    String replyDiscrim;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Guess reply dest type using reply discriminator");
                    }
                    tempReplyTo = (replyDiscrim = _msg.getReplyDiscriminator()) == null || "".equals(replyDiscrim) ? new JmsQueueImpl() : new JmsTopicImpl();
                }
            }
        }
        if (tempReplyTo != null) {
            JmsDestinationImpl.populateReplyToFromHeader(tempReplyTo, _msg, rrp);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJMSReplyToInternal", (Object)tempReplyTo);
        }
        return tempReplyTo;
    }

    String fullEncode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"fullEncode");
        }
        String encoded = null;
        if (this.cachedEncodedString != null) {
            encoded = this.cachedEncodedString;
        } else {
            Map<String, Object> destProps = this.getCopyOfProperties();
            this.cachedEncodedString = encoded = this.encodeMap(destProps);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"fullEncode", (Object)encoded);
        }
        return encoded;
    }

    String partialEncode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"partialEncode()");
        }
        String encoded = null;
        if (this.cachedPartialEncodedString != null) {
            encoded = this.cachedPartialEncodedString;
        } else {
            Map<String, Object> destProps = this.getCopyOfProperties();
            destProps.remove("DEST_NAME");
            destProps.remove("DEST_DISCRIM");
            destProps.remove("priority");
            destProps.remove("timeToLive");
            destProps.remove("forwardRP");
            destProps.remove("reverseRP");
            this.cachedPartialEncodedString = encoded = this.encodeMap(destProps);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"partialEncode", (Object)encoded);
        }
        return encoded;
    }

    @Override
    public String[] getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getForwardRoutingPath");
        }
        String[] path = null;
        StringArrayWrapper saw = (StringArrayWrapper)this.properties.get("forwardRP");
        if (saw != null) {
            path = saw.getArray();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getForwardRoutingPath", path == null ? null : Arrays.asList(path));
        }
        return path;
    }

    @Override
    public String[] getReverseRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReverseRoutingPath");
        }
        String[] path = null;
        StringArrayWrapper saw = (StringArrayWrapper)this.properties.get("reverseRP");
        if (saw != null) {
            path = saw.getArray();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReverseRoutingPath", path == null ? null : Arrays.asList(path));
        }
        return path;
    }

    void configureDestinationFromRoutingPath(List fwdPath) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"configureDestinationFromRoutingPath", (Object)fwdPath);
        }
        this.clearCachedEncodings();
        this.clearCachedProducerDestinationAddress();
        if (fwdPath != null && fwdPath.size() > 0) {
            int lastEltIndex = fwdPath.size() - 1;
            SIDestinationAddress lastElt = (SIDestinationAddress)fwdPath.get(lastEltIndex);
            String destName = lastElt.getDestinationName();
            this.setDestName(destName);
            String destBusName = lastElt.getBusName();
            this.setBusName(destBusName);
            if (fwdPath.size() > 1) {
                this.properties.put("forwardRP", new StringArrayWrapper(fwdPath));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("caching producerDestinationAddress: " + lastElt));
                }
                this.producerDestinationAddress = lastElt;
            }
        } else {
            this.properties.remove("forwardRP");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"configureDestinationFromRoutingPath");
        }
    }

    protected void updateProperty(String key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateProperty", (Object)new Object[]{key, value});
        }
        if (this.isDifferent(key, value)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("new value for " + key + ": " + value));
            }
            this.clearCachedEncodings();
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("value for " + key + " same as existing"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateProperty");
        }
    }

    protected void clearCachedProducerDestinationAddress() {
        this.producerDestinationAddress = null;
    }

    protected void clearCachedConsumerDestinationAddress() {
        this.consumerDestinationAddress = null;
    }

    private void clearCachedEncodings() {
        this.cachedEncodedString = null;
        this.cachedPartialEncodedString = null;
        for (int i = 0; i < this.cachedEncoding.length; ++i) {
            this.cachedEncoding[i] = null;
        }
    }

    private boolean isDifferent(String key, Object value) {
        Object currentVal = this.properties.get(key);
        if (currentVal == null) {
            return value != null;
        }
        return !currentVal.equals(value);
    }

    private String encodeMap(Map<String, Object> destProps) {
        String destName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeMap", destProps);
        }
        StringBuffer result = new StringBuffer("");
        HashMap<String, Object> nonDefaultProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> nextProp : destProps.entrySet()) {
            Object propDefaultValue;
            String propName = nextProp.getKey();
            Object propValue = nextProp.getValue();
            if (propValue instanceof String) {
                propValue = URIDestinationCreator.escapeValueString((String)propValue);
            }
            if ((propDefaultValue = MsgDestEncodingUtilsImpl.getDefaultPropertyValue(propName)) == null && propValue == null || propDefaultValue != null && propDefaultValue.equals(propValue)) continue;
            if (this instanceof JmsQueue && !propName.equals("DEST_NAME")) {
                nonDefaultProps.put(propName, propValue);
                continue;
            }
            if (!(this instanceof JmsTopic) || "DEST_DISCRIM".equals(propName) || "DEST_NAME".equals(propName) || "Default.Topic.Space".equals(propValue) || propValue == null) continue;
            nonDefaultProps.put(propName, propValue);
        }
        Iterator iter = nonDefaultProps.entrySet().iterator();
        if (this instanceof JmsQueue) {
            result.append("queue://");
            destName = (String)destProps.get("DEST_NAME");
            if (destName == null) {
                destName = "";
            }
            destName = URIDestinationCreator.escapeDestName(destName);
            result.append(destName);
            if (iter.hasNext()) {
                result.append("?");
            }
        } else if (this instanceof JmsTopic) {
            result.append("topic://");
            destName = (String)destProps.get("DEST_DISCRIM");
            String topicSpace = (String)destProps.get("DEST_NAME");
            if (destName == null) {
                destName = "";
            }
            if (topicSpace == null) {
                topicSpace = "";
            }
            destName = URIDestinationCreator.escapeDestName(destName);
            topicSpace = URIDestinationCreator.escapeValueString(topicSpace);
            result.append(destName);
            if (!"Default.Topic.Space".equals(topicSpace)) {
                result.append("?topicSpace=");
                result.append(topicSpace);
                if (iter.hasNext()) {
                    result.append("&");
                }
            } else if (iter.hasNext()) {
                result.append("?");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination in question is neither a JmsQueue of JmsTopic");
        }
        while (iter.hasNext()) {
            Map.Entry nextProp = iter.next();
            if (((String)nextProp.getKey()).equals("busName")) continue;
            result.append((String)nextProp.getKey());
            result.append("=");
            result.append(nextProp.getValue());
            if (!iter.hasNext()) continue;
            result.append("&");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeMap", (Object)result);
        }
        return result.toString();
    }

    private static void populateReplyToFromHeader(JmsDestinationImpl tempReplyTo, JsJmsMessage _msg, List<SIDestinationAddress> rrp) throws JMSException {
        Reliability reliability;
        Long ttl;
        Integer pri;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateReplyToFromHeader", (Object)new Object[]{tempReplyTo, _msg, rrp});
        }
        tempReplyTo.configureDestinationFromRoutingPath(rrp);
        String replyDiscrim = _msg.getReplyDiscriminator();
        if (replyDiscrim != null) {
            tempReplyTo.setDestDiscrim(replyDiscrim);
        }
        if ((pri = _msg.getReplyPriority()) != null) {
            tempReplyTo.setPriority(pri);
        }
        if ((ttl = _msg.getReplyTimeToLive()) != null) {
            tempReplyTo.setTimeToLive(ttl);
        }
        if ((reliability = _msg.getReplyReliability()) != null && reliability != Reliability.NONE) {
            tempReplyTo.setReplyReliability(reliability);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateReplyToFromHeader", (Object)tempReplyTo);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        JmsDestinationImpl that = (JmsDestinationImpl)other;
        Map<String, Object> thisProps = this.properties;
        Map<String, Object> thatProps = that.properties;
        if (thisProps == thatProps) {
            return true;
        }
        if (thisProps == null) {
            return false;
        }
        if (thisProps.equals(thatProps)) {
            return true;
        }
        HashMap<String, Object> thisWithDefaults = new HashMap<String, Object>();
        HashMap<String, Object> thatWithDefaults = new HashMap<String, Object>();
        thisWithDefaults.putAll(MsgDestEncodingUtilsImpl.getDefaultJNDIProperties(this.getClass()));
        thatWithDefaults.putAll(MsgDestEncodingUtilsImpl.getDefaultJNDIProperties(that.getClass()));
        thisWithDefaults.putAll(thisProps);
        if (thatProps != null) {
            thatWithDefaults.putAll(thatProps);
        }
        return thisWithDefaults.equals(thatWithDefaults);
    }

    public int hashCode() {
        if (this.properties != null) {
            return this.properties.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.fullEncode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.cachedEncoding = new byte[EncodingLevel.values().length][];
    }

    static {
        block3: {
            tc = SibTr.register(JmsDestinationImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
            refUtils = JmsJcaReferenceUtils.getInstance();
            try {
                destEncoder = (MsgDestEncodingUtilsImpl)JmsInternalsFactory.getMessageDestEncodingUtils();
            }
            catch (JMSException jmse) {
                FFDCFilter.processException((Throwable)jmse, (String)"JmsDestinationImpl.<clinit>", (String)"JmsDestinationImpl.<clinit>#1");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Exception caught creating MsgDestEncodingUtilsImpl");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)jmse));
            }
        }
    }
}

