/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsMsgConsumer;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsConnInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;

public class JmsMsgConsumerImpl
implements JmsMsgConsumer,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsMsgConsumerImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private Consumer consumer;
    private ConsumerProperties props = null;
    private ConsumerSession coreConsumerSession = null;
    private SICoreConnection coreConn = null;
    private JmsSessionImpl session = null;
    private boolean closed = false;
    private Object closedLock = new Object();
    private final int sessionAckMode;
    private final Object sessionSyncLock;
    SelectionCriteriaFactory selectionCriteriaFactory = null;
    private String defaultBusName = null;

    protected JmsMsgConsumerImpl(SICoreConnection coreConnection, JmsSessionImpl newSession, ConsumerProperties newProps) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMsgConsumerImpl", (Object)new Object[]{coreConnection, newSession});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("theDest : " + newProps.getJmsDestination() + " sel : " + newProps.getSelector() + " noL : " + newProps.noLocal()));
        }
        this.defaultBusName = (String)newSession.getPassThruProps().get("busName");
        this.props = newProps;
        this.coreConn = coreConnection;
        this.session = newSession;
        this.sessionSyncLock = this.session.getSessionSyncLock();
        JmsDestination dest = this.props.getJmsDestination();
        try {
            this.selectionCriteriaFactory = JmsServiceFacade.getSelectionCriteriaFactory();
        }
        catch (SIErrorException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{e, "JmsMsgConsumerImpl.constructor"}, e, "JmsMsgConsumerImpl.constructor#1", this, tc);
        }
        if (dest instanceof Topic) {
            this.props.setDestinationType(DestinationType.TOPICSPACE);
            if (this.props.supportsMultipleConsumers()) {
                this.props.setReadAhead(false);
            } else {
                this.props.setReadAhead(true);
            }
        } else {
            this.props.setDestinationType(DestinationType.QUEUE);
            this.props.setReadAhead(false);
            JmsQueue jmsQueue = (JmsQueue)dest;
            String gatherStr = jmsQueue.getGatherMessages();
            if ("On".equals(gatherStr)) {
                this.props.setGatherMessages(true);
            }
        }
        String readAheadDestVal = dest.getReadAhead();
        if ("AsConnection".equals(readAheadDestVal)) {
            Map passThru;
            String cfVal;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Inherit readAhead from Connection");
            }
            if (!"Default".equals(cfVal = (String)(passThru = this.session.getPassThruProps()).get("readAhead"))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Connection explicitly set readAhead: " + readAheadDestVal));
                }
                if ("AlwaysOn".equals(cfVal)) {
                    this.props.setReadAhead(true);
                } else {
                    this.props.setReadAhead(false);
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Destination explicitly set readAhead: " + readAheadDestVal));
            }
            if ("AlwaysOn".equals(readAheadDestVal)) {
                this.props.setReadAhead(true);
            } else {
                this.props.setReadAhead(false);
            }
        }
        this.sessionAckMode = this.session.getAcknowledgeMode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("acknowledge mode: " + this.sessionAckMode));
        }
        this.props.setReliability(Reliability.ASSURED_PERSISTENT);
        boolean recovExpress = true;
        if (this.sessionAckMode == 1 || this.sessionAckMode == 3) {
            recovExpress = false;
        }
        this.props.setRecovExpress(recovExpress);
        this.coreConsumerSession = this.createCoreConsumer(this.coreConn, this.props);
        if (this.session.getState() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Start consumer because connection was already started.");
            }
            this.start();
        } else {
            this.stop();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMsgConsumerImpl");
        }
    }

    public String getMessageSelector() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageSelector");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageSelector", (Object)this.props.getSelector());
        }
        return this.props.getSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageListener");
        }
        this.checkClosed();
        if (this.session.isManaged()) {
            throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageConsumer.getMessageListener"}, tc);
        }
        MessageListener ml = null;
        if (this.consumer != null) {
            ml = this.consumer.getMessageListener();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageListener", (Object)ml);
        }
        return ml;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        boolean checkManaged = true;
        this._setMessageListener(listener, checkManaged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive");
        }
        Message msg = null;
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("receive");
            msg = this.receiveInboundMessage(true, 0L);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive", (Object)timeout);
        }
        Message msg = null;
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("receive");
            msg = this.receiveInboundMessage(true, timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveNoWait");
        }
        Message msg = null;
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("receiveNoWait");
            if (this.session.getState() == 2) {
                msg = this.receiveInboundMessage(false, -1L);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"consumer not started");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        boolean originallyClosed = false;
        Object object = this.closedLock;
        synchronized (object) {
            originallyClosed = this.closed;
            this.closed = true;
        }
        if (!originallyClosed) {
            this.stop();
            if (this.coreConsumerSession != null) {
                try {
                    this.coreConsumerSession.close();
                }
                catch (SIException sice) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.close"}, sice, null, this, tc);
                }
                this.coreConsumerSession = null;
                this.consumer = null;
            }
            this.session.removeConsumer(this);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"already closed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public Destination getDestination() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestination");
        }
        this.checkClosed();
        JmsDestination d = this.props.getJmsDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestination", (Object)d);
        }
        return d;
    }

    protected ConsumerSession createCoreConsumer(SICoreConnection _coreConn, ConsumerProperties _props) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createCoreConsumer", (Object)new Object[]{_coreConn});
        }
        ConsumerSession cs = null;
        JmsDestinationImpl dest = (JmsDestinationImpl)_props.getJmsDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("destName: " + dest.getConsumerDestName() + " type: " + _props.getDestinationType() + " discrim: " + dest.getDestDiscrim() + " selector: " + _props.getSelector() + " reliability: " + _props.getReliability() + " noLocal: " + _props.noLocal() + " unrecovRel: " + _props.getUnrecovReliability() + " gatherMsgs: " + _props.isGatherMessages()));
        }
        try {
            SelectionCriteria selectionCriteria = null;
            SIDestinationAddress consumerSIDA = null;
            try {
                selectionCriteria = this.selectionCriteriaFactory.createSelectionCriteria(dest.getDestDiscrim(), _props.getSelector(), SelectorDomain.JMS);
                SIDestinationAddress originalConsumerProps = dest.getConsumerSIDestinationAddress();
                consumerSIDA = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(originalConsumerProps.getDestinationName(), ((JsDestinationAddress)originalConsumerProps).isLocalOnly(), originalConsumerProps.getBusName());
            }
            catch (SIErrorException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.createCoreConsumer"}, sice, "JmsMsgConsumerImpl.createCoreConsumer#1", this, tc);
            }
            cs = _coreConn.createConsumerSession(consumerSIDA, _props.getDestinationType(), selectionCriteria, _props.getReliability(), _props.readAhead(), _props.noLocal(), _props.getUnrecovReliability(), false, null, true, _props.isGatherMessages(), null);
        }
        catch (SISelectorSyntaxException e) {
            throw (InvalidSelectorException)JmsErrorUtils.newThrowable(InvalidSelectorException.class, "INVALID_SELECTOR_CWSIA0083", null, e, null, this, tc);
        }
        catch (SINotAuthorizedException sidnfe) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "CONSUMER_AUTH_ERROR_CWSIA0090", new Object[]{dest.getDestName()}, sidnfe, null, this, tc);
        }
        catch (SINotPossibleInCurrentConfigurationException dwte) {
            String msgKey = "MC_CREATE_FAILED_CWSIA0086";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{dest}, dwte, null, this, tc);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            String msgKey = "MC_CREATE_FAILED_CWSIA0086";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{dest}, e, null, this, tc);
        }
        catch (SIIncorrectCallException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{e, "JmsMsgConsumerImpl.createCoreConsumer"}, e, "JmsMsgConsumerImpl.createCoreConsumer#6", this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.createCoreConsumer"}, sice, null, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createCoreConsumer", (Object)cs);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        if (this.coreConsumerSession != null) {
            try {
                Object object = this.closedLock;
                synchronized (object) {
                    if (!this.closed) {
                        this.coreConsumerSession.start(false);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Avoided starting a consumer that has been closed.");
                    }
                }
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.start"}, sice, null, this, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    protected void stop() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if (this.coreConsumerSession != null) {
            try {
                this.coreConsumerSession.stop();
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.stop"}, sice, null, this, tc);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"coreConsumerSession is null, already closed ?");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw (JMSException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "CONSUMER_CLOSED_CWSIA0081", null, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setMessageListener(MessageListener listener, boolean checkManaged) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setMessageListener", (Object)new Object[]{listener, checkManaged});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            if (checkManaged && this.session.isManaged()) {
                InvocationHandler handler;
                String name;
                boolean exceptionRequired = true;
                if (this.sessionAckMode == 1 && listener instanceof Proxy && (name = (handler = Proxy.getInvocationHandler(listener)).getClass().getName()).startsWith("com.ibm")) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"async beans, listener accepted");
                    }
                    exceptionRequired = false;
                }
                if (exceptionRequired) {
                    throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageConsumer.setMessageListener"}, tc);
                }
            }
            if (listener == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"application has asked to deregister listener");
                }
                this.removeAsyncListener();
                this.session.registerSyncConsumer(this);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"application has supplied a listener to register");
                }
                this.setAsyncListener(listener);
                this.session.registerAsyncConsumer(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setMessageListener");
        }
    }

    private void setAsyncListener(MessageListener listener) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsyncListener", (Object)listener);
        }
        this.consumer = new Consumer(listener, this.session, this.sessionAckMode);
        try {
            this.coreConsumerSession.stop();
            int batchSize = 1;
            boolean deliverImmediately = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Registering async callback for consumer" + this.consumer));
            }
            this.coreConsumerSession.registerAsynchConsumerCallback((AsynchConsumerCallback)this.consumer, 0, 0L, batchSize, this.session.getOrderingContext());
            if (this.session.getState() == 2) {
                this.coreConsumerSession.start(deliverImmediately);
            }
        }
        catch (SIIncorrectCallException sie) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sie, "JmsMsgConsumerImpl.setAsyncListener"}, sie, "JmsMsgConsumerImpl.setAsyncListener#1", this, tc);
        }
        catch (SIException sie) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sie, "JmsMsgConsumerImpl.setAsyncListener"}, sie, null, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsyncListener");
        }
    }

    private void removeAsyncListener() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeAsyncListener");
        }
        if (this.consumer != null) {
            try {
                this.coreConsumerSession.stop();
                this.coreConsumerSession.deregisterAsynchConsumerCallback();
                if (this.session.getState() == 2) {
                    this.coreConsumerSession.start(false);
                }
                this.consumer = null;
            }
            catch (SIIncorrectCallException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.removeAsyncListener"}, sice, "JmsMsgConsumerImpl.removeASyncListener#1", this, tc);
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sice, "JmsMsgConsumerImpl.removeAsyncListener"}, sice, null, this, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeAsyncListener");
        }
    }

    boolean getNoLocalFlag() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNoLocalFlag");
        }
        this.checkClosed();
        boolean nl = this.props.noLocal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNoLocalFlag", (Object)nl);
        }
        return nl;
    }

    private Message receiveInboundMessage(boolean waiting, long timeout) throws JMSException {
        ConsumerSession context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveInboundMessage", (Object)new Object[]{waiting, timeout});
        }
        Message msg = null;
        String bus = null;
        String destName = null;
        SIBusMessage coreMsg = null;
        SITransaction st = this.session.getTransaction();
        MessagePacingControl mpc = MessagePacingControlFactory.getInstance();
        if (mpc != null && mpc.isActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"about to call preSynchReceive");
            }
            context = this.coreConsumerSession;
            bus = this.coreConsumerSession.getDestinationAddress().getBusName();
            if (bus == null) {
                bus = this.defaultBusName;
            }
            destName = this.coreConsumerSession.getDestinationAddress().getDestinationName();
            if (waiting) {
                timeout = mpc.preSynchReceive(bus, destName, (Object)context, timeout);
            } else {
                mpc.preSynchReceive(bus, destName, (Object)context, -1L);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"preSynchReceive complete");
            }
        }
        try {
            JmsDestinationImpl dest;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to call receive method; transaction: " + st + (waiting ? " timeout: " + timeout : "")));
                if (this.session.getState() != 2) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING - APPLICATION CALLED RECEIVE BUT CONNECTION IS NOT STARTED");
                }
            }
            if (waiting) {
                coreMsg = this.coreConsumerSession.receiveWithWait(st, timeout);
                if (coreMsg == null && this.session.getState() != 2) {
                    String caller = JmsErrorUtils.getFirstApplicationStackString();
                    SibTr.warning((TraceComponent)tc, (String)"MC_CONN_STOPPED_CWSIA0087", (Object)caller);
                }
            } else {
                coreMsg = this.coreConsumerSession.receiveNoWait(st);
            }
            if ((msg = JmsInternalsFactory.getSharedUtils().inboundMessagePath(coreMsg, this.session, this.session.getPassThruProps())) != null && ((JmsMessageImpl)msg).getMsgReference().getJmsDestination() == null && !(dest = (JmsDestinationImpl)this.props.getJmsDestination())._getInhibitJMSDestination()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("This message was not sent by a JMS client, and so has no JmsDestination field set. Setting it to: " + this.props.getJmsDestination().getDestName()));
                }
                msg.setJMSDestination((Destination)dest);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("sessionAckMode : " + this.sessionAckMode));
            }
            if (msg != null && st != null) {
                this.session.notifyMessageConsumed(st);
            }
        }
        catch (SISessionUnavailableException oce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("caught SISessionUnavailableException: " + (Object)((Object)oce)));
            }
            this.close();
            String exceptionMsg = oce.getMessage();
            if (exceptionMsg != null && (exceptionMsg.contains("CWSIP0180E") || exceptionMsg.contains("CWSIP0194E"))) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INBOUND_MSG_ERROR_CWSIA0103", new Object[]{oce}, oce, null, this, tc);
            }
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INBOUND_MSG_ERROR_CWSIA0103", new Object[]{sice}, sice, null, this, tc);
        }
        if (mpc != null && mpc.isActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"about to call postSynchReceive");
            }
            context = this.coreConsumerSession;
            boolean msgReceived = msg != null;
            mpc.postSynchReceive(bus, destName, (Object)context, msgReceived);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"postSynchReceive complete");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveInboundMessage", (Object)msg);
        }
        return msg;
    }

    private void emergencyClose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emergencyClose");
        }
        try {
            if (this.coreConsumerSession != null) {
                this.coreConsumerSession.close();
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsMsgConsumerImpl", (String)"emergencyClose#1", (Object)this);
        }
        finally {
            this.coreConsumerSession = null;
            this.closed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emergencyClose");
        }
    }

    private class Consumer
    implements AsynchConsumerCallback {
        private MessageListener listener = null;
        private Object sessionLock = null;
        private JmsConnInternals excTarget = null;
        private JmsSessionImpl session = null;
        private int sessionAckMode = -1;

        public Consumer(MessageListener newListener, JmsSessionImpl theSession, int theSessionAckMode) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"Consumer", (Object)new Object[]{newListener, theSession, theSessionAckMode});
            }
            this.listener = newListener;
            this.sessionLock = theSession.getAsyncDeliveryLock();
            this.excTarget = (JmsConnInternals)theSession.getConnection();
            this.session = theSession;
            this.sessionAckMode = theSessionAckMode;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"Consumer", (Object)this.sessionLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeMessages(LockedMessageEnumeration lme) {
            Message jmsMsg;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages", (Object)lme);
            }
            if ((jmsMsg = this.obtainMessage(lme)) != null) {
                Object object = this.sessionLock;
                synchronized (object) {
                    block25: {
                        SITransaction st;
                        if (this.session.isManaged()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"async beans: using null trans");
                            }
                            st = null;
                        } else {
                            try {
                                st = this.session.getTransaction();
                            }
                            catch (JMSException e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"unrecoverable error, attempting to close this messageConsumer");
                                }
                                JmsMsgConsumerImpl.this.emergencyClose();
                                if (this.excTarget != null) {
                                    this.excTarget.reportException(e);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages", (Object)"early return");
                                }
                                return;
                            }
                        }
                        try {
                            if (st != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Delete under transaction: " + st));
                                }
                                lme.deleteCurrent(st);
                            }
                            this.session.notifyMessagePreConsume(st);
                            boolean onMessageSuccessful = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invoke app onMessage");
                            }
                            try {
                                this.listener.onMessage(jmsMsg);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"app onMessage complete");
                                }
                            }
                            catch (RuntimeException re) {
                                onMessageSuccessful = false;
                                this.dealWithRuntimeExceptionFromOnMessage(lme, st, re);
                            }
                            if (onMessageSuccessful) {
                                if (this.sessionAckMode == 3) {
                                    this.session.notifyMessagePostConsume();
                                }
                                this.deleteOrMakeAvailable(lme, st);
                            }
                        }
                        catch (Exception e) {
                            JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{e, "Consumer.consumeMessages"}, e, "JmsMsgConsumerImpl.Consumer.consumeMessages#6", this, tc);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"closing");
                            }
                            JmsMsgConsumerImpl.this.emergencyClose();
                            if (this.excTarget == null) break block25;
                            this.excTarget.reportException(jmse);
                        }
                    }
                }
            }
            this.stopConsumerIfAppropriate();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
            }
        }

        public MessageListener getMessageListener() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageListener");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageListener", (Object)this.listener);
            }
            return this.listener;
        }

        private final Message obtainMessage(LockedMessageEnumeration lme) {
            Message jmsMsg;
            block9: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"obtainMessage", (Object)lme);
                }
                jmsMsg = null;
                try {
                    int mc = lme.getRemainingMessageCount();
                    if (mc != 1) {
                        String key = "INTERNAL_ERROR_CWSIA0499";
                        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, key, new Object[]{"lme.messageCount", mc}, tc);
                    }
                    SIBusMessage msg = lme.nextLocked();
                    jmsMsg = JmsInternalsFactory.getSharedUtils().inboundMessagePath(msg, this.session, this.session.getPassThruProps());
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception obtaining message from ConsumerSession (async)", (Object)((Object)e));
                    }
                    this.unlockConsumerSession(lme, false);
                    JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{e, "Consumer.consumeMessages"}, e, "JmsMsgConsumerImpl.Consumer.consumeMessages#1", this, tc);
                    if (this.excTarget != null) {
                        this.excTarget.reportException(jmse);
                    }
                }
                catch (JMSException jmse) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught ", (Object)((Object)jmse));
                    }
                    this.unlockConsumerSession(lme, true);
                    if (this.excTarget == null) break block9;
                    this.excTarget.reportException(jmse);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"obtainMessage", (Object)jmsMsg);
            }
            return jmsMsg;
        }

        private final void unlockConsumerSession(LockedMessageEnumeration lme, boolean ffdcIfException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockConsumerSession", (Object)new Object[]{lme, ffdcIfException});
            }
            try {
                ConsumerSession cs = lme.getConsumerSession();
                if (cs != null) {
                    cs.unlockAll();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"couldn't get ConsumerSession, closing");
                    }
                    JmsMsgConsumerImpl.this.emergencyClose();
                }
            }
            catch (SIException e1) {
                if (ffdcIfException) {
                    FFDCFilter.processException((Throwable)e1, (String)"JmsMsgConsumerImpl.Consumer.consumeMessages", (String)"consumeMessages#2", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception trying to unlock the lme, closing", (Object)((Object)e1));
                }
                JmsMsgConsumerImpl.this.emergencyClose();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockConsumerSession");
            }
        }

        private final void dealWithRuntimeExceptionFromOnMessage(LockedMessageEnumeration lme, SITransaction st, RuntimeException re) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dealWithRuntimeExceptionFromOnMessage", (Object)new Object[]{lme, st, re});
            }
            try {
                if (this.sessionAckMode == 3) {
                    this.session.rollbackTransaction();
                }
                if (st == null) {
                    ConsumerSession cs = lme.getConsumerSession();
                    if (cs != null) {
                        cs.unlockAll();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"couldn't get ConsumerSession, closing");
                        }
                        JmsMsgConsumerImpl.this.close();
                    }
                }
                JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "ML_THREW_EXCPTN_CWSIA0089", null, re, "JmsMsgConsumerImpl.Consumer.consumeMessages#4", this, tc);
                if (this.excTarget != null) {
                    this.excTarget.reportException(jmse);
                }
            }
            catch (Exception e1) {
                FFDCFilter.processException((Throwable)e1, (String)"JmsMsgConsumerImpl.Consumer.consumeMessages", (String)"consumeMessages#7", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception in tidyup after failed onMessage, closing", (Object)e1);
                }
                JmsMsgConsumerImpl.this.emergencyClose();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dealWithRuntimeExceptionFromOnMessage");
            }
        }

        private void deleteOrMakeAvailable(LockedMessageEnumeration lme, SITransaction st) throws SIException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteOrMakeAvailable", (Object)new Object[]{lme, st});
            }
            if (st == null) {
                int tempCommitCount = this.session.getAndResetCommitCount();
                if (tempCommitCount == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"onMessage called recover");
                    }
                    lme.getConsumerSession().unlockAll();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Delete without transaction");
                    }
                    lme.deleteCurrent(null);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteOrMakeAvailable");
            }
        }

        private final void stopConsumerIfAppropriate() {
            int s = this.session.getState();
            switch (s) {
                case 3: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"session closed/closing, stopping this async consumer");
                    }
                    try {
                        JmsMsgConsumerImpl.this.stop();
                    }
                    catch (JMSException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring exception thrown by stop during close optimisation", (Object)((Object)e));
                    }
                    break;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"session stopped, so stopping this async consumer");
                    }
                    try {
                        JmsMsgConsumerImpl.this.stop();
                        break;
                    }
                    catch (JMSException jmse) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception thrown by stop during stop optimisation", (Object)((Object)jmse));
                        }
                        if (this.excTarget == null) break;
                        this.excTarget.reportException(jmse);
                    }
                }
            }
        }
    }
}

