/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.api.jms.EncodingLevel;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.ProducerProperties;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsMsgProducerImpl
implements JmsMsgProducer,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsMsgProducerImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private SICoreConnection coreConnection;
    private ProducerSession prod;
    private int defaultDeliveryMode = 2;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private JmsDestinationImpl dest = null;
    private JmsSessionImpl session = null;
    private boolean closed = false;
    private Object closedLock = new Object();
    private boolean disableTimestamp = false;
    private boolean disableMessageID = false;
    private Object sessionSyncLock;
    private ProducerProperties producerProperties = null;
    private Reliability nonPersistentReliability;
    private Reliability persistentReliability;
    private boolean propsOverriden = false;
    private String resolvedUserID;
    private OrderingContext orderingContext;
    private String busName;

    private JmsMsgProducerImpl() {
    }

    JmsMsgProducerImpl(Destination theDest, SICoreConnection coreConnection, JmsSessionImpl newSession) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMsgProducerImpl", (Object)new Object[]{theDest, coreConnection, newSession});
        }
        if (theDest != null) {
            this.dest = JmsDestinationImpl.checkNativeInstance(theDest);
            JmsDestinationImpl.checkBlockedStatus(this.dest);
        }
        this.coreConnection = coreConnection;
        this.prod = null;
        this.session = newSession;
        this.sessionSyncLock = this.session.getSessionSyncLock();
        try {
            this.resolvedUserID = coreConnection.getResolvedUserid();
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.<constructor>"}, sice, null, this, tc);
        }
        this.orderingContext = this.session.getOrderingContext();
        Map passThruProps = this.session.getPassThruProps();
        this.busName = (String)passThruProps.get("busName");
        String connPropVal = (String)passThruProps.get("nonPersistentMapping");
        if (connPropVal != null) {
            this.nonPersistentReliability = ProducerProperties.lookupReliability(connPropVal);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: no non-persistent mapping in passThruProps");
            }
            this.nonPersistentReliability = Reliability.EXPRESS_NONPERSISTENT;
        }
        connPropVal = (String)passThruProps.get("persistentMapping");
        if (connPropVal != null) {
            this.persistentReliability = ProducerProperties.lookupReliability(connPropVal);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: no persistent mapping in passThruProps");
            }
            this.persistentReliability = Reliability.RELIABLE_PERSISTENT;
        }
        if (this.dest != null) {
            this.producerProperties = new ProducerProperties(this.dest, this, passThruProps, this.persistentReliability, this.nonPersistentReliability);
            try {
                DestinationType dt = null;
                boolean producerBind = false;
                boolean preferLocalQP = true;
                if (this.dest.isProducerTypeCheck()) {
                    if (theDest instanceof Queue) {
                        String preferLocalQPStr;
                        dt = DestinationType.QUEUE;
                        String producerBindStr = ((JmsQueue)((Object)this.dest)).getProducerBind();
                        if (producerBindStr != null && "On".equals(producerBindStr)) {
                            producerBind = true;
                        }
                        if ((preferLocalQPStr = ((JmsQueue)((Object)this.dest)).getProducerPreferLocal()) != null && "Off".equals(preferLocalQPStr)) {
                            preferLocalQP = false;
                        }
                    } else {
                        dt = DestinationType.TOPICSPACE;
                    }
                }
                SIDestinationAddress sida = this.dest.getProducerSIDestinationAddress();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Creating producer session - destAddr: " + sida + " type: " + dt + " bind: " + producerBind + " preferLocl: " + preferLocalQP));
                }
                String destDiscrim = this.dest.getDestDiscrim();
                this.prod = coreConnection.createProducerSession(sida, destDiscrim, dt, this.orderingContext, null, producerBind, preferLocalQP);
            }
            catch (SINotAuthorizedException sinae) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
            }
            catch (SINotPossibleInCurrentConfigurationException dwte) {
                String msgKey = "MP_CREATE_FAILED_CWSIA0062";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{theDest}, dwte, null, this, tc);
            }
            catch (SITemporaryDestinationNotFoundException tdnf) {
                String msgKey = "MP_CREATE_FAILED_CWSIA0062";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{theDest}, tdnf, null, this, tc);
            }
            catch (SIIncorrectCallException e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.<constructor>"}, e, "JmsMsgProducerImpl#4", this, tc);
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.<constructor>"}, sice, null, this, tc);
            }
            catch (Exception e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.<constructor>"}, e, "JmsMsgProducerImpl#5", this, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMsgProducerImpl");
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageID", (Object)value);
        }
        this.checkClosed();
        this.disableMessageID = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageID");
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageID");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageID", (Object)this.disableMessageID);
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)value);
        }
        this.checkClosed();
        this.disableTimestamp = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp");
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)this.disableTimestamp);
        }
        return this.disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)deliveryMode);
        }
        this.checkClosed();
        this.validateDeliveryMode(deliveryMode);
        this.defaultDeliveryMode = deliveryMode;
        if (this.producerProperties != null) {
            this.producerProperties.setInDeliveryMode(deliveryMode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryMode");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryMode");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryMode", (Object)this.defaultDeliveryMode);
        }
        return this.defaultDeliveryMode;
    }

    public void setPriority(int x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)x);
        }
        this.checkClosed();
        this.validatePriority(x);
        this.defaultPriority = x;
        if (this.producerProperties != null) {
            this.producerProperties.setInPriority(x);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    public int getPriority() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)this.defaultPriority);
        }
        return this.defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)timeToLive);
        }
        this.checkClosed();
        this.validateTimeToLive(timeToLive);
        this.defaultTimeToLive = timeToLive;
        if (this.producerProperties != null) {
            this.producerProperties.setInTTL(timeToLive);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
        }
    }

    public long getTimeToLive() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTimeToLive");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)this.defaultTimeToLive);
        }
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestination");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestination", (Object)this.dest);
        }
        return this.dest;
    }

    public void close() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean tidyUp) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{tidyUp});
        }
        boolean originallyClosed = false;
        Object object = this.closedLock;
        synchronized (object) {
            originallyClosed = this.closed;
            this.closed = true;
        }
        if (!originallyClosed) {
            if (this.prod != null) {
                try {
                    if (!tidyUp) {
                        this.prod.close();
                    }
                }
                catch (SIException sice) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.close"}, sice, null, this, tc);
                }
            }
            this.session.removeProducer(this);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"already closed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)message);
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("send");
            if (this.dest == null) {
                throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
            }
            if (message == null) {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
            }
            if (this.propsOverriden) {
                this.producerProperties.setInDeliveryMode(this.defaultDeliveryMode);
                this.producerProperties.setInPriority(this.defaultPriority);
                this.producerProperties.setInTTL(this.defaultTimeToLive);
                this.propsOverriden = false;
            }
            this.sendMessage(this.producerProperties, message, this.dest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{message, deliveryMode, priority, timeToLive});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("send");
            if (this.dest == null) {
                throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
            }
            if (message == null) {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
            }
            this.validatePriority(priority);
            this.validateDeliveryMode(deliveryMode);
            this.validateTimeToLive(timeToLive);
            this.propsOverriden = true;
            this.producerProperties.setInDeliveryMode(deliveryMode);
            this.producerProperties.setInPriority(priority);
            this.producerProperties.setInTTL(timeToLive);
            this.sendMessage(this.producerProperties, message, this.dest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{destination, message});
        }
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{destination, message, deliveryMode, priority, timeToLive});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.checkClosed();
            this.session.checkSynchronousUsage("send");
            if (this.dest != null) {
                throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "DEST_SPECIFIED_ON_SEND_CWSIA0066", null, tc);
            }
            JmsDestinationImpl nativeDest = JmsDestinationImpl.checkNativeInstance(destination);
            if (this.dest == null) {
                JmsDestinationImpl.checkBlockedStatus(nativeDest);
            }
            if (message == null) {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
            }
            this.validatePriority(priority);
            this.validateDeliveryMode(deliveryMode);
            this.validateTimeToLive(timeToLive);
            ProducerProperties pp = new ProducerProperties(nativeDest, this, this.session.getPassThruProps(), null, null);
            pp.setInDeliveryMode(deliveryMode);
            pp.setInPriority(priority);
            pp.setInTTL(timeToLive);
            this.sendMessage(pp, message, nativeDest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "PRODUCER_CLOSED_CWSIA0061", null, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
    }

    private void sendMessage(ProducerProperties props, Message message, JmsDestinationImpl destRef) throws JMSException {
        SITransaction transaction;
        Object gID;
        Object gSeq;
        List rrpPath;
        JmsMessageImpl jmsMIref;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMessage(ProducerProps, Message, Destination)");
        }
        JsJmsMessage jsJmsMessage = null;
        JmsMessageImpl foreignMsgHelper = null;
        if (message instanceof JmsMessageImpl) {
            jmsMIref = (JmsMessageImpl)message;
            jsJmsMessage = jmsMIref.getMsgReference();
            jmsMIref.clearLocalProperties();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Create a JS message object for foreign message");
            }
            jmsMIref = foreignMsgHelper = JmsMessageImpl.messageToJmsMessageImpl(message);
            jsJmsMessage = foreignMsgHelper.getMsgReference();
        }
        PersistenceType deliveryMode = props.getEffectiveDeliveryMode();
        jsJmsMessage.setJmsDeliveryMode(deliveryMode);
        Integer priority = props.getEffectivePriority();
        jsJmsMessage.setPriority(priority.intValue());
        long timeToLive = props.getEffectiveTTL();
        List frpPath = props.getConvertedFRP();
        if (frpPath != null) {
            jsJmsMessage.uncheckedSetForwardRoutingPath(frpPath);
        }
        if ((rrpPath = props.getConvertedRRP_Part()) != null) {
            List existingRRP = jsJmsMessage.getReverseRoutingPath();
            if (existingRRP.size() > 0) {
                for (int i = 0; i < existingRRP.size(); ++i) {
                    rrpPath.add(existingRRP.get(i));
                }
            }
            jsJmsMessage.uncheckedSetReverseRoutingPath(rrpPath);
            String discrim = props.getDiscriminator();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Using discriminator from destination: " + discrim));
            }
            if (discrim != null && !discrim.equals(jsJmsMessage.getReplyDiscriminator())) {
                jsJmsMessage.setReplyDiscriminator(discrim);
            }
        }
        if (message instanceof JmsMessageImpl && ((JmsMessageImpl)message).isRrpBusNameNeedsUpdating()) {
            boolean changed = false;
            List rrp = jsJmsMessage.getReverseRoutingPath();
            if (rrp.size() > 0) {
                for (int i = 0; i < rrp.size(); ++i) {
                    JsDestinationAddress addr = (JsDestinationAddress)rrp.get(i);
                    if (addr.getBusName() != null) continue;
                    addr.setBusName(this.busName);
                    rrp.set(i, addr);
                    changed = true;
                }
            }
            if (changed) {
                jsJmsMessage.uncheckedSetReverseRoutingPath(rrp);
            }
            ((JmsMessageImpl)message).setRrpBusNameNeedsUpdating(false);
        }
        if (!destRef._getInhibitJMSDestination()) {
            byte[] destBytes = destRef.encodeToBytes(EncodingLevel.FULL);
            jsJmsMessage.setJmsDestination(destBytes);
            if (message instanceof JmsMessageImpl) {
                ((JmsMessageImpl)message).setDestReference(destRef);
            }
        }
        if (!this.disableMessageID) {
            jsJmsMessage.setApiMessageIdAsBytes(this.session.createMessageID());
        }
        jsJmsMessage.setJmsxAppId(MfpConstants.WPM_JMSXAPPID);
        jsJmsMessage.setApiUserId(this.resolvedUserID);
        if (!jsJmsMessage.alreadySent() && (gSeq = jsJmsMessage.getJMSXGroupSeq()) != null && (gID = jsJmsMessage.getObjectProperty("JMSXGroupID")) == null) {
            byte[] idBytes = this.session.createMessageID();
            StringBuffer sb = new StringBuffer("ID:");
            HexString.binToHex((byte[])idBytes, (int)0, (int)idBytes.length, (StringBuffer)sb);
            String newGroupID = sb.toString();
            jsJmsMessage.setObjectProperty("JMSXGroupID", (Object)newGroupID);
        }
        timeToLive = props.getEffectiveTTL();
        long timeNow = 0L;
        if (timeToLive != 0L || !this.disableTimestamp) {
            timeNow = System.currentTimeMillis();
        }
        if (timeToLive == 0L) {
            jsJmsMessage.setJmsExpiration(0L);
        } else {
            jsJmsMessage.setJmsExpiration(timeNow + timeToLive);
        }
        jsJmsMessage.uncheckedSetTimeToLive(timeToLive);
        if (!this.disableTimestamp) {
            jsJmsMessage.setTimestamp(timeNow);
        } else {
            jsJmsMessage.setTimestamp(0L);
        }
        Reliability rel = destRef.getReplyReliability();
        if (rel == null) {
            rel = props.getEffectiveReliability();
        }
        jsJmsMessage.setReliability(rel);
        jmsMIref.updateReplyReliability(this.nonPersistentReliability, this.persistentReliability);
        String discrim = props.getDiscriminator();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Setting discrim as '" + discrim + "'"));
            }
            if (this.prod != null) {
                jsJmsMessage.uncheckedSetDiscriminator(discrim);
            } else {
                jsJmsMessage.setDiscriminator(discrim);
            }
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"discriminator", discrim}, iae, null, this, tc);
        }
        jsJmsMessage.setRoutingDestination(null);
        switch (this.session.getAcknowledgeMode()) {
            case 0: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "SESSION_TRANSACTED";
                break;
            }
            case 2: {
                transaction = null;
                String acknowledgeMode = "CLIENT_ACKNOWLEDGE";
                break;
            }
            case 3: {
                transaction = null;
                String acknowledgeMode = "DUPS_OK_ACKNOWLEDGE";
                break;
            }
            case 1: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "AUTO_ACKNOWLEDGE";
                break;
            }
            default: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "NONE";
            }
        }
        jmsMIref.invalidateToStringCache();
        if (this.prod != null) {
            try {
                this.prod.send((SIBusMessage)jsJmsMessage, transaction);
            }
            catch (SINotAuthorizedException sinae) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
            }
            catch (SINotPossibleInCurrentConfigurationException dwte) {
                String msgKey = "SEND_FAILED_CWSIA0063";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, dwte, null, this, tc);
            }
            catch (SIIncorrectCallException e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.sendMessage (#4)"}, e, "JmsMsgProducerImpl.sendMessage#4", this, tc);
            }
            catch (SIException simpe) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{simpe, "JmsMsgProducerImpl.sendMessage (#4)"}, simpe, null, this, tc);
            }
        }
        try {
            DestinationType dt = null;
            if (destRef.isProducerTypeCheck()) {
                if (destRef instanceof Queue) {
                    dt = DestinationType.QUEUE;
                } else if (destRef instanceof Topic) {
                    dt = DestinationType.TOPICSPACE;
                }
            }
            SIDestinationAddress sida = destRef.getProducerSIDestinationAddress();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to do core unidentified send - transaction: " + transaction + " destAddr: " + sida + " destType: " + dt));
            }
            this.coreConnection.send((SIBusMessage)jsJmsMessage, transaction, sida, dt, this.orderingContext, null);
        }
        catch (SINotAuthorizedException sinae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
        }
        catch (SINotPossibleInCurrentConfigurationException dwte) {
            String msgKey = "SEND_FAILED_CWSIA0063";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, dwte, null, this, tc);
        }
        catch (SITemporaryDestinationNotFoundException tdnf) {
            String msgKey = "SEND_FAILED_CWSIA0063";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, tdnf, null, this, tc);
        }
        catch (SIIncorrectCallException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.sendMessage (#7)"}, sice, "JmsMsgProducerImpl.sendMessage#7", this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.sendMessage (#7)"}, sice, null, this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.sendMessage (#8)"}, e, "JmsMsgProducerImpl.sendMessage#8", this, tc);
        }
        if (!(message instanceof JmsMessageImpl)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting properties back into foreign message");
            }
            message.setJMSDeliveryMode(foreignMsgHelper.getJMSDeliveryMode());
            message.setJMSDestination(foreignMsgHelper.getJMSDestination());
            message.setJMSExpiration(foreignMsgHelper.getJMSExpiration());
            message.setJMSMessageID(foreignMsgHelper.getJMSMessageID());
            message.setJMSPriority(foreignMsgHelper.getJMSPriority());
            message.setJMSTimestamp(foreignMsgHelper.getJMSTimestamp());
            Enumeration propertyNames = foreignMsgHelper.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (!name.startsWith("JMSX") && !name.startsWith("JMS_IBM")) continue;
                Object value = foreignMsgHelper.getObjectProperty(name);
                try {
                    message.setObjectProperty(name, value);
                }
                catch (JMSException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("foreign message refused setObjProperty(" + name + "): " + (Object)((Object)e)));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMessage(ProducerProps, Message, Destination)");
        }
    }

    private void validateDeliveryMode(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSDeliveryMode", "" + deliveryMode}, tc);
            }
        }
    }

    private void validatePriority(int x) throws JMSException {
        if (x < 0 || x > 9) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSPriority", "" + x}, tc);
        }
    }

    private void validateTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L || timeToLive > 9191815209357175807L) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"timeToLive", "" + timeToLive}, tc);
        }
    }
}

