/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.MessageConversionFailed;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class JmsQueueBrowserImpl
implements QueueBrowser,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsQueueBrowserImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private JmsSessionImpl theSession = null;
    private JmsDestinationImpl theDestination = null;
    private String theSelector = null;
    private String jsDestName = null;
    private SICoreConnection coreConnection = null;
    private int state = 2;
    private boolean createdFirst = false;
    private Enumeration firstEnumeration = null;
    private List<EnumImpl> enums = null;
    private SelectionCriteriaFactory selectionCriteriaFactory = null;

    public JmsQueueBrowserImpl(JmsSessionImpl newSession, JmsDestinationImpl newDest, String newSelector) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsQueueBrowserImpl", (Object)new Object[]{newSession, newDest, newSelector});
        }
        this.theSession = newSession;
        this.theDestination = newDest;
        this.theSelector = newSelector;
        this.jsDestName = this.theDestination.getConsumerDestName();
        this.enums = new Vector<EnumImpl>();
        this.coreConnection = newSession.getCoreConnection();
        try {
            this.selectionCriteriaFactory = JmsServiceFacade.getSelectionCriteriaFactory();
        }
        catch (SIErrorException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{e, "JmsMsgConsumerImpl.constructor"}, e, "JmsMsgConsumerImpl.constructor#1", this, tc);
        }
        try {
            this.firstEnumeration = this.instantiateBrowser();
            this.createdFirst = true;
        }
        catch (JMSException jmse) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"instantiateBrowser generated ", (Object)((Object)jmse));
            }
            throw jmse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsQueueBrowserImpl");
        }
    }

    public Queue getQueue() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQueue");
        }
        Queue q = (Queue)this.theDestination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQueue", (Object)q);
        }
        return q;
    }

    public String getMessageSelector() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageSelector");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageSelector", (Object)this.theSelector);
        }
        return this.theSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getEnumeration() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getEnumeration");
        }
        Enumeration vEnum = null;
        List<EnumImpl> list = this.enums;
        synchronized (list) {
            if (this.state == 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Called getEnumeration on a closed Browser");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BROWSER_CLOSED_CWSIA0142", null, tc);
            }
            if (this.createdFirst) {
                if (this.firstEnumeration != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using the enumeration that was created by the constructor");
                    }
                    vEnum = this.firstEnumeration;
                    this.firstEnumeration = null;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a new enumeration");
                    }
                    vEnum = this.instantiateBrowser();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating the first Enumeration (to check existence etc)");
                }
                this.firstEnumeration = this.instantiateBrowser();
                this.createdFirst = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getEnumeration", (Object)vEnum);
        }
        return vEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        int originalState = 0;
        Object[] enumCopy = null;
        List<EnumImpl> list = this.enums;
        synchronized (list) {
            originalState = this.state;
            this.state = 3;
            enumCopy = this.enums.toArray();
        }
        if (originalState != 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to close " + enumCopy.length + " enums."));
            }
            for (int i = 0; i < enumCopy.length; ++i) {
                EnumImpl anEnum = (EnumImpl)enumCopy[i];
                anEnum.close();
            }
            this.theSession.removeBrowser(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JmsQueueBrowserImpl)) {
            return false;
        }
        JmsQueueBrowserImpl qbi = (JmsQueueBrowserImpl)obj;
        if (!this.theDestination.equals(qbi.theDestination)) {
            return false;
        }
        if (this.theSelector == null && qbi.theSelector == null) {
            return true;
        }
        return this.theSelector != null && this.theSelector.equals(qbi.theSelector);
    }

    public int hashCode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hashCode");
        }
        int val = 0;
        if (this.theDestination != null) {
            val += this.theDestination.hashCode();
        }
        if (this.theSelector != null) {
            val += 11 * this.theSelector.hashCode();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hashCode", (Object)val);
        }
        return val;
    }

    private Enumeration instantiateBrowser() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateBrowser");
        }
        EnumImpl vEnum = null;
        try {
            DestinationType dt = DestinationType.QUEUE;
            String discrim = null;
            String mediation = null;
            boolean gather = false;
            String gatherStr = ((JmsQueue)((Object)this.theDestination)).getGatherMessages();
            if ("On".equals(gatherStr)) {
                gather = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)(" destName: " + this.jsDestName + ", destType: " + dt + ", discrim: " + discrim + ", mediation: " + mediation + ", gather: " + gather));
            }
            SelectionCriteria selectionCriteria = null;
            try {
                selectionCriteria = this.selectionCriteriaFactory.createSelectionCriteria(discrim, this.theSelector, SelectorDomain.JMS);
            }
            catch (SIErrorException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0144", new Object[]{sice, "JmsQueueBrowserImpl.instantiateBrowser"}, sice, "JmsQueueBrowserImpl.instantiateBrowser#1", this, tc);
            }
            BrowserSession bs = this.coreConnection.createBrowserSession(this.theDestination.getConsumerSIDestinationAddress(), dt, selectionCriteria, null, gather);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("core BrowserSession created: " + bs));
            }
            if (bs == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"createBrowserSession returned null - internal error for coreAPI");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "FAILED_TO_CREATE_BSESSION_CWSIA0143", null, tc);
            }
            vEnum = new EnumImpl(bs);
            this.enums.add(vEnum);
        }
        catch (SISelectorSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"An invalid selector was supplied to createBrowser", (Object)((Object)e));
            }
            throw (InvalidSelectorException)JmsErrorUtils.newThrowable(InvalidSelectorException.class, "INVALID_SELECTOR_CWSIA0147", null, e, null, this, tc);
        }
        catch (SINotAuthorizedException sinae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "BROWSER_AUTH_ERROR_CWSIA0149", null, sinae, null, this, tc);
        }
        catch (SINotPossibleInCurrentConfigurationException dwte) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"failed to create browserSession", (Object)((Object)dwte));
            }
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "BROWSE_FAILED_CWSIA0145", new Object[]{this.jsDestName}, dwte, null, this, tc);
        }
        catch (SITemporaryDestinationNotFoundException tdnf) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"failed to create browserSession", (Object)((Object)tdnf));
            }
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "BROWSE_FAILED_CWSIA0145", new Object[]{this.jsDestName}, tdnf, null, this, tc);
        }
        catch (SIException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception creating browser session", (Object)((Object)e));
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0144", new Object[]{e, "createBrowserSession"}, e, "JmsQueueBrowserImpl.instantiateBrowser#7", this, tc);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception creating browser session", (Object)e);
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0144", new Object[]{e, "createBrowserSession"}, e, "JmsQueueBrowserImpl.instantiateBrowser#8", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateBrowser", (Object)vEnum);
        }
        return vEnum;
    }

    class EnumImpl
    implements Enumeration,
    ApiJmsConstants {
        private BrowserSession bs = null;
        private int state = 2;
        private static final int DISCONNECTED = 171079;
        private SIBusMessage nextMsg = null;

        EnumImpl(BrowserSession newBs) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"EnumImpl", (Object)newBs);
            }
            this.bs = newBs;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"EnumImpl");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasMoreElements");
            }
            boolean ret = false;
            BrowserSession browserSession = this.bs;
            synchronized (browserSession) {
                if (this.state == 3 || this.state == 171079) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Enumeration in disconnected or closed state: " + this.state + " so no more elements are available"));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasMoreElements", (Object)false);
                    }
                    return false;
                }
                if (this.nextMsg == null) {
                    try {
                        this.nextMsg = this.bs.next();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Received message: " + this.nextMsg));
                        }
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsQueueBrowserImpl.EnumImpl", (String)"hasMoreElements#1", (Object)this);
                    }
                    if (this.nextMsg == null) {
                        this.state = 171079;
                        ret = false;
                    } else {
                        ret = true;
                    }
                } else {
                    ret = true;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasMoreElements", (Object)ret);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"nextElement");
            }
            Message jmsMsg = null;
            BrowserSession browserSession = this.bs;
            synchronized (browserSession) {
                if (this.state == 3) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Called nextElement on a closed Browser Enumeration");
                    }
                    throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "BROWSER_CLOSED_CWSIA0142", null, tc);
                }
                boolean msgAvailable = false;
                msgAvailable = this.nextMsg == null ? this.hasMoreElements() : true;
                if (msgAvailable) {
                    try {
                        jmsMsg = JmsInternalsFactory.getSharedUtils().inboundMessagePath(this.nextMsg, null, JmsQueueBrowserImpl.this.theSession.getPassThruProps());
                    }
                    catch (JMSException jmse) {
                        this.nextMsg = null;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message could not be converted to a JMS message type", (Object)((Object)jmse));
                        }
                        throw (MessageConversionFailed)JmsErrorUtils.newThrowable(MessageConversionFailed.class, "INBOUND_MSG_ERROR_CWSIA0148", null, jmse, "JmsQueueBrowserImpl.Enum.nextElement#2", this, tc);
                    }
                    this.nextMsg = null;
                }
            }
            if (jmsMsg == null) {
                throw (NoSuchElementException)JmsErrorUtils.newThrowable(NoSuchElementException.class, "NO_MESSAGE_AVAILABLE_CWSIA0141", null, tc);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"nextElement", (Object)jmsMsg);
            }
            return jmsMsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
            }
            BrowserSession browserSession = this.bs;
            synchronized (browserSession) {
                try {
                    this.bs.close();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsQueueBrowserImpl.EnumImpl", (String)"close#1", (Object)this);
                }
                this.state = 3;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
        }
    }
}

