/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class JmsTextMessageImpl
extends JmsMessageImpl
implements TextMessage {
    private static final long serialVersionUID = -5270175349556840160L;
    private JsJmsTextMessage txtMsg;
    private static TraceComponent tc = SibTr.register(JmsTextMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsTextMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl");
        }
    }

    public JmsTextMessageImpl(String txt) throws JMSException {
        this();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl", (Object)txt);
        }
        this.txtMsg.setText(txt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl");
        }
    }

    JmsTextMessageImpl(JsJmsTextMessage newMsg, JmsSessionImpl newSess) {
        super((JsJmsMessage)newMsg, newSess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl", (Object)new Object[]{newMsg, newSess});
        }
        this.txtMsg = newMsg;
        this.messageClass = "jms_text";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl");
        }
    }

    JmsTextMessageImpl(TextMessage textMessage) throws JMSException {
        super((Message)textMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl", (Object)textMessage);
        }
        this.setText(textMessage.getText());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTextMessageImpl");
        }
    }

    public void setText(String txt) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (txt == null || txt.length() < 257) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setText", (Object)txt);
            } else {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setText", (Object)new Object[]{txt.length(), txt.substring(0, 200) + "..."});
            }
        }
        this.checkBodyWriteable("setText");
        this.txtMsg.setText(txt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setText");
        }
    }

    public String getText() throws JMSException {
        String txt;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getText");
        }
        try {
            txt = this.txtMsg.getText();
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsTextMessageImpl.getText"}, e, "JmsTextMessageImpl#3", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (txt == null || txt.length() < 257) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getText", (Object)txt);
            } else {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getText", (Object)new Object[]{txt.length(), txt.substring(0, 200) + "..."});
            }
        }
        return txt;
    }

    @Override
    public String toString() {
        String val = super.toString();
        try {
            String thisText = this.getText();
            if (thisText == null) {
                thisText = "<null>";
            } else if (thisText.length() > 100) {
                thisText = thisText.substring(0, 100) + " ...";
            }
            val = val + "\n" + thisText;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return val;
    }

    public int hashCode() {
        if (this.txtMsg == null) {
            return 0;
        }
        return this.txtMsg.hashCode();
    }

    @Override
    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsTextMessage newMsg = null;
        try {
            newMsg = jmfact.createJmsTextMessage();
            this.messageClass = "jms_text";
        }
        catch (MessageCreateFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        this.txtMsg = newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }
}

