/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class JmsQueueSenderImpl
extends JmsMsgProducerImpl
implements QueueSender {
    private static TraceComponent tc = SibTr.register(JmsQueueSenderImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    JmsQueueSenderImpl(Destination theDest, SICoreConnection coreConnection, JmsSessionImpl newSession) throws JMSException {
        super(theDest, coreConnection, newSession);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsQueueSenderImpl", (Object)new Object[]{theDest, coreConnection, newSession});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsQueueSenderImpl");
        }
    }

    public Queue getQueue() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQueue");
        }
        this.checkClosed();
        Queue queue = (Queue)this.getDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQueue", (Object)queue);
        }
        return queue;
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{queue, message});
        }
        super.send((Destination)queue, message);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{queue, message, deliveryMode, priority, timeToLive});
        }
        super.send((Destination)queue, message, deliveryMode, priority, timeToLive);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }
}

