/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractCollection;
import com.ibm.ws.objectManager.AbstractCollectionView;
import com.ibm.ws.objectManager.Collection;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.Map;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import java.util.NoSuchElementException;

public abstract class AbstractMap
extends AbstractCollection
implements Map {
    private static final Class cclass = AbstractMap.class;
    volatile transient Collection keyCollection = null;
    volatile transient Collection values = null;

    protected AbstractMap() {
    }

    @Override
    public long size(Transaction transaction) throws ObjectManagerException {
        return this.entrySet().size(transaction);
    }

    @Override
    public long size() throws ObjectManagerException {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty(Transaction transaction) throws ObjectManagerException {
        return this.size(transaction) == 0L;
    }

    @Override
    public boolean containsValue(Token value, Transaction transaction) throws ObjectManagerException {
        try {
            Map.Entry entry;
            Token entryValue;
            Iterator iterator = this.entrySet().iterator();
            while (value != (entryValue = (entry = (Map.Entry)iterator.next(transaction)).getValue())) {
            }
            return true;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    @Override
    public boolean containsKey(Object key, Transaction transaction) throws ObjectManagerException {
        try {
            Map.Entry entry;
            Object entryKey;
            Iterator iterator = this.entrySet().iterator();
            while (key != (entryKey = (entry = (Map.Entry)iterator.next(transaction)).getKey()) && !key.equals(entryKey)) {
            }
            return true;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    @Override
    public Token get(Object key, Transaction transaction) throws ObjectManagerException {
        try {
            Map.Entry entry;
            Object entryKey;
            Iterator iterator = this.entrySet().iterator();
            while (key != (entryKey = (entry = (Map.Entry)iterator.next(transaction)).getKey()) && !key.equals(entryKey)) {
            }
            return entry.getValue();
        }
        catch (NoSuchElementException exception) {
            return null;
        }
    }

    @Override
    public Token put(Object key, Token value, Transaction transaction) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Token remove(Object key, Transaction transaction) throws ObjectManagerException {
        Token returnToken = null;
        try {
            Map.Entry entry;
            Object entryKey;
            Iterator iterator = this.entrySet().iterator();
            while (key != (entryKey = (entry = (Map.Entry)iterator.next(transaction)).getKey()) && !key.equals(entryKey)) {
            }
            returnToken = entry.getValue();
            iterator.remove(transaction);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return returnToken;
    }

    @Override
    public void putAll(Map otherMap, Transaction transaction) throws ObjectManagerException {
        Iterator iterator = otherMap.entrySet().iterator();
        while (iterator.hasNext(transaction)) {
            Map.Entry entry = (Map.Entry)iterator.next(transaction);
            this.put(entry.getKey(), entry.getValue(), transaction);
        }
    }

    @Override
    public void clear(Transaction transaction) throws ObjectManagerException {
        this.entrySet().clear(transaction);
    }

    @Override
    public Collection keyCollection() {
        if (this.keyCollection == null) {
            this.keyCollection = new AbstractCollectionView(){

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    return new Iterator(){
                        private Iterator iterator;
                        {
                            this.iterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            return this.iterator.hasNext(transaction);
                        }

                        @Override
                        public boolean hasNext() throws ObjectManagerException {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            return ((Map.Entry)this.iterator.next(transaction)).getKey();
                        }

                        @Override
                        public Object next() throws ObjectManagerException {
                            return ((Map.Entry)this.iterator.next()).getKey();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            return this.iterator.remove(transaction);
                        }
                    };
                }

                @Override
                public long size(Transaction transaction) throws ObjectManagerException {
                    return AbstractMap.this.size(transaction);
                }

                @Override
                public long size() throws ObjectManagerException {
                    return AbstractMap.this.size();
                }

                public boolean contains(Object key, Transaction transaction) throws ObjectManagerException {
                    return AbstractMap.this.containsKey(key, transaction);
                }
            };
        }
        return this.keyCollection;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollectionView(){

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            return this.i.hasNext(transaction);
                        }

                        @Override
                        public boolean hasNext() throws ObjectManagerException {
                            return this.i.hasNext();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            return ((Map.Entry)this.i.next(transaction)).getValue();
                        }

                        @Override
                        public Object next() throws ObjectManagerException {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            return this.i.remove(transaction);
                        }
                    };
                }

                @Override
                public long size(Transaction transaction) throws ObjectManagerException {
                    return AbstractMap.this.size(transaction);
                }

                @Override
                public long size() throws ObjectManagerException {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Token value, Transaction transaction) throws ObjectManagerException {
                    return AbstractMap.this.containsValue(value, transaction);
                }
            };
        }
        return this.values;
    }

    @Override
    public abstract Set entrySet() throws ObjectManagerException;

    @Override
    public String toString() {
        try {
            return new String("AbstractMap(size()=" + this.size() + " size(null)=" + this.size(null) + ") " + super.toString());
        }
        catch (ObjectManagerException exception) {
            ObjectManager.ffdc.processException(this, cclass, "toString", exception, "1:408:1.8");
            return super.toString() + "(" + exception + ")";
        }
    }
}

