/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ManagedObjectInputStream;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public final class Token
implements Externalizable,
SimplifiedSerialization {
    private static final Class cclass = Token.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerObjects");
    private static final long serialVersionUID = -6508104910374719410L;
    int objectStoreIdentifier;
    long storedObjectIdentifier;
    protected transient WeakReference managedObjectReference;
    protected transient ObjectStore objectStore;
    private static final byte simpleSerialVersion = 0;
    private static final byte externalVersion = 0;

    protected Token(ManagedObject underlyingObject, ObjectStore objectStore, long storedObjectIdentifier) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{underlyingObject, objectStore, new Long(storedObjectIdentifier)});
        }
        this.objectStore = objectStore;
        this.storedObjectIdentifier = storedObjectIdentifier;
        this.objectStoreIdentifier = objectStore.getIdentifier();
        underlyingObject.owningToken = this;
        this.managedObjectReference = new WeakReference<ManagedObject>(underlyingObject);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected Token(ObjectStore objectStore, long storedObjectIdentifier) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", " objectStore=" + objectStore + "(ObjectStore) storedObjectIdentifier=" + storedObjectIdentifier + "(long)");
        }
        this.managedObjectReference = null;
        this.objectStore = objectStore;
        this.storedObjectIdentifier = storedObjectIdentifier;
        this.objectStoreIdentifier = objectStore.getIdentifier();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected Token current() {
        String methodName = "current";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "current" + this.toString());
        }
        Token currentToken = this.objectStore.like(this);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "current", new Object[]{currentToken, Integer.toHexString(currentToken.hashCode())});
        }
        return currentToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedObject getManagedObject() throws ObjectManagerException {
        ManagedObject managedObject = null;
        if (this.managedObjectReference != null) {
            managedObject = (ManagedObject)this.managedObjectReference.get();
        }
        if (managedObject == null) {
            Token token = this;
            synchronized (token) {
                if (this.managedObjectReference != null) {
                    managedObject = (ManagedObject)this.managedObjectReference.get();
                }
                if (managedObject == null && (managedObject = this.objectStore.get(this)) != null) {
                    managedObject.owningToken = this;
                    this.managedObjectReference = new WeakReference<ManagedObject>(managedObject);
                }
            }
        }
        return managedObject;
    }

    protected synchronized ManagedObject setManagedObject(ManagedObject managedObject) throws ObjectManagerException {
        ManagedObject managedObjectSet;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "setManagedObjectmanagedObject=" + managedObject + "(ManagedObject)" + this.toString());
        }
        if (this.managedObjectReference == null) {
            managedObject.owningToken = this;
            this.managedObjectReference = new WeakReference<ManagedObject>(managedObject);
            managedObjectSet = managedObject;
        } else {
            ManagedObject existingManagedObject = (ManagedObject)this.managedObjectReference.get();
            if (existingManagedObject == null) {
                managedObject.owningToken = this;
                this.managedObjectReference = new WeakReference<ManagedObject>(managedObject);
                managedObjectSet = managedObject;
            } else {
                existingManagedObject.becomeCloneOf(managedObject);
                managedObjectSet = existingManagedObject;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setManagedObject", new Object[]{managedObjectSet});
        }
        return managedObjectSet;
    }

    void invalidate() {
        ManagedObject managedObject;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "invalidate");
        }
        this.objectStore = null;
        if (this.managedObjectReference != null && (managedObject = (ManagedObject)this.managedObjectReference.get()) != null) {
            managedObject.state = 0;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "invalidate");
        }
    }

    public long getStoredObjectIdentifier() {
        return this.storedObjectIdentifier;
    }

    public final ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public static long maximumSerializedSize() {
        return 13L;
    }

    protected final void writeSerializedBytes(ObjectManagerByteArrayOutputStream buffer) {
        buffer.write(0);
        buffer.writeInt(this.objectStoreIdentifier);
        buffer.writeLong(this.storedObjectIdentifier);
    }

    @Override
    public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", "dataOutputStream=" + dataOutputStream + "(java.io.DataOutputStream)");
        }
        try {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(this.objectStoreIdentifier);
            dataOutputStream.writeLong(this.storedObjectIdentifier);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:326:1.14");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public final void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "dataInputStream=" + dataInputStream + "(java.io.DataInputStream) objectManagerState=" + objectManagerState + "(ObjectManagerState)");
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "readObject", "via UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    public static final Token restore(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        long storedObjectIdentifier;
        int objectStoreIdentifier;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "restore", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug(cclass, "restore", new Object[]{new Byte(version)});
            }
            objectStoreIdentifier = dataInputStream.readInt();
            storedObjectIdentifier = dataInputStream.readLong();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "restore", exception, "1:400:1.14");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "restore", (Object)"via PermanentIOException");
            }
            throw new PermanentIOException(cclass, exception);
        }
        Token tokenToReturn = new Token(objectManagerState.getObjectStore(objectStoreIdentifier), storedObjectIdentifier);
        tokenToReturn = tokenToReturn.current();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "restore", (Object)("returns token=" + tokenToReturn + "(Token)"));
        }
        return tokenToReturn;
    }

    public Token() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeExternal", "objectOutput=" + objectOutput + "(java.io.ObjectOutput)");
        }
        objectOutput.writeByte(0);
        objectOutput.writeInt(this.objectStoreIdentifier);
        objectOutput.writeLong(this.storedObjectIdentifier);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeExternal");
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readExternal", "objectInput=" + objectInput + "(java.io.ObjectInput)");
        }
        byte version = objectInput.readByte();
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug(cclass, "readExternal", (Object)("version=" + version + "(byte)"));
        }
        this.objectStoreIdentifier = objectInput.readInt();
        this.storedObjectIdentifier = objectInput.readLong();
        try {
            this.objectStore = ((ManagedObjectInputStream)objectInput).objectManagerState.getObjectStore(this.objectStoreIdentifier);
        }
        catch (ObjectManagerException exception) {
            IOException ioException;
            block8: {
                ObjectManager.ffdc.processException(this, cclass, "readExternal", exception, "1:488:1.14");
                ioException = new IOException();
                try {
                    Method initCauseMethod = Throwable.class.getMethod("initCause", Throwable.class);
                    initCauseMethod.invoke((Object)this, exception);
                }
                catch (Exception exception2) {
                    if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) break block8;
                    trace.event(this, cclass, "readExternal", exception2);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readExternal", new Object[]{exception, new Integer(this.objectStoreIdentifier)});
            }
            throw ioException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readExternal");
        }
    }

    public final String toString() {
        return new String("Token(" + this.objectStoreIdentifier + "/" + this.storedObjectIdentifier + ")/" + Integer.toHexString(this.hashCode()));
    }
}

