/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class TransactionCheckpointLogRecord
extends LogRecord {
    private static final Class cclass = TransactionCheckpointLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 1869839597051819424L;
    protected LogicalUnitOfWork logicalUnitOfWork;
    protected int transactionState;
    private Collection tokensToAdd;
    private Collection tokensToReplace;
    private Collection serializedBytesToReplace;
    private Collection tokensToOptimisticReplace;
    private Collection tokensToDelete;
    private Collection tokensToNotify;

    protected TransactionCheckpointLogRecord(InternalTransaction internalTransaction, Collection tokensToAdd, Collection tokensToReplace, Collection serializedBytesToReplace, Collection tokensToOptimisticReplace, Collection tokensToDelete, Collection tokensToNotify) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction, tokensToAdd, tokensToReplace, serializedBytesToReplace, tokensToOptimisticReplace, tokensToDelete, tokensToNotify});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.transactionState = internalTransaction.getState();
        this.tokensToAdd = tokensToAdd;
        this.tokensToReplace = tokensToReplace;
        this.serializedBytesToReplace = serializedBytesToReplace;
        this.tokensToOptimisticReplace = tokensToOptimisticReplace;
        this.tokensToDelete = tokensToDelete;
        this.tokensToNotify = tokensToNotify;
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionCheckpointLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "DataInputStream=" + dataInputStream + ", ObjectManagerState=" + objectManagerState);
        }
        try {
            Token token;
            int i;
            this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
            this.transactionState = dataInputStream.readInt();
            int numberOfTokensToAdd = dataInputStream.readInt();
            this.tokensToAdd = new ArrayList(numberOfTokensToAdd);
            int numberOfTokensToReplace = dataInputStream.readInt();
            this.tokensToReplace = new ArrayList(numberOfTokensToReplace);
            this.serializedBytesToReplace = new ArrayList(numberOfTokensToReplace);
            int numberOfTokensToOptimisticReplace = dataInputStream.readInt();
            this.tokensToOptimisticReplace = new ArrayList(numberOfTokensToOptimisticReplace);
            int numberOfTokensToDelete = dataInputStream.readInt();
            this.tokensToDelete = new ArrayList(numberOfTokensToDelete);
            int numberOfTokensToNotify = dataInputStream.readInt();
            this.tokensToNotify = new ArrayList(numberOfTokensToNotify);
            for (int i2 = 0; i2 < numberOfTokensToAdd; ++i2) {
                Token token2 = Token.restore(dataInputStream, objectManagerState);
                this.tokensToAdd.add(token2);
            }
            int[] serializedByteLength = new int[numberOfTokensToReplace];
            for (i = 0; i < numberOfTokensToReplace; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToReplace.add(token);
                serializedByteLength[i] = dataInputStream.readInt();
            }
            for (i = 0; i < numberOfTokensToOptimisticReplace; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToOptimisticReplace.add(token);
            }
            for (i = 0; i < numberOfTokensToDelete; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToDelete.add(token);
            }
            for (i = 0; i < numberOfTokensToNotify; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToNotify.add(token);
            }
            for (i = 0; i < numberOfTokensToReplace; ++i) {
                byte[] serializedBytes = new byte[serializedByteLength[i]];
                dataInputStream.read(serializedBytes);
                this.serializedBytesToReplace.add(serializedBytes);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "<init>", exception, "1:190:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        String methodName = "getBuffers";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getBuffers", new Object[]{byteArrayOutputStream});
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[1 + this.tokensToReplace.size()];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(10);
            this.logicalUnitOfWork.writeObject(dataOutputStream);
            dataOutputStream.writeInt(this.transactionState);
            dataOutputStream.writeInt(this.tokensToAdd.size());
            dataOutputStream.writeInt(this.tokensToReplace.size());
            dataOutputStream.writeInt(this.tokensToOptimisticReplace.size());
            dataOutputStream.writeInt(this.tokensToDelete.size());
            dataOutputStream.writeInt(this.tokensToNotify.size());
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "getBuffers", exception, "1:240:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getBuffers", new Object[]{exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        for (Token token : this.tokensToAdd) {
            token.writeObject(dataOutputStream);
        }
        Iterator serializedBytesIterator = this.serializedBytesToReplace.iterator();
        int ibuffer = 1;
        for (Token token : this.tokensToReplace) {
            token.writeObject(dataOutputStream);
            ObjectManagerByteArrayOutputStream managedObjectBytes = (ObjectManagerByteArrayOutputStream)serializedBytesIterator.next();
            try {
                dataOutputStream.writeInt(managedObjectBytes.getCount());
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "getBuffers", exception, "1:267:1.8");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "getBuffers", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            buffers[ibuffer++] = managedObjectBytes;
        }
        for (Token token : this.tokensToOptimisticReplace) {
            token.writeObject(dataOutputStream);
        }
        for (Token token : this.tokensToDelete) {
            token.writeObject(dataOutputStream);
        }
        for (Token token : this.tokensToNotify) {
            token.writeObject(dataOutputStream);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        ManagedObject existingManagedObject;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", objectManagerState);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug(this, cclass, "logicalUnitOfWork=" + this.logicalUnitOfWork + "(LogicalUnitOfWork)\n transactionState=" + this.transactionState + "(int)\n tokensToAdd=" + this.tokensToAdd + "(java.util.Collection)\n tokensToReplace=" + this.tokensToReplace + "(java.util.Collecton)\n serializedBytesToReplace=" + this.serializedBytesToReplace + "(java.util.Collection)\n tokensToOptimisticReplace=" + this.tokensToOptimisticReplace + "(java.util.Collection)\n tokensToDelete=" + this.tokensToDelete + "(java.util.Collection)\n tokensToNotify=" + this.tokensToNotify + "(java.util.Collection)");
        }
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        for (Token token : this.tokensToAdd) {
            ManagedObject existingManagedObject2 = token.getManagedObject();
            if (existingManagedObject2 == null) continue;
            existingManagedObject2.state = 1;
            transactionForRecovery.addFromCheckpoint(existingManagedObject2);
        }
        Iterator serializedBytesIterator = this.serializedBytesToReplace.iterator();
        for (Token token : this.tokensToReplace) {
            existingManagedObject = token.getManagedObject();
            byte[] managedObjectBytes = (byte[])serializedBytesIterator.next();
            ManagedObject replacementManagedObject = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, objectManagerState);
            if (existingManagedObject == null) continue;
            transactionForRecovery.lock(existingManagedObject);
            token.setManagedObject(replacementManagedObject);
            transactionForRecovery.replaceFromCheckpoint(existingManagedObject, managedObjectBytes);
        }
        for (Token token : this.tokensToOptimisticReplace) {
            existingManagedObject = token.getManagedObject();
            if (existingManagedObject == null) continue;
            transactionForRecovery.optimisticReplaceFromCheckpoint(existingManagedObject);
        }
        for (Token token : this.tokensToDelete) {
            existingManagedObject = token.getManagedObject();
            if (existingManagedObject == null) continue;
            transactionForRecovery.deleteFromCheckpoint(existingManagedObject);
        }
        for (Token token : this.tokensToNotify) {
            existingManagedObject = token.getManagedObject();
            if (existingManagedObject == null) continue;
            transactionForRecovery.notifyFromCheckpoint(token);
        }
        transactionForRecovery.internalTransaction.resetState(this.transactionState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 4L + LogicalUnitOfWork.maximumSerializedSize() + 4L + 4L + 4L + 4L + 4L + 4L;
    }
}

