/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager.utils;

import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.objectManager.utils.FFDC;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import com.ibm.ws.objectManager.utils.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Objects;

public class FFDCImpl
extends FFDC {
    private static final Class cclass = FFDCImpl.class;
    private static Trace trace = Utils.traceFactory.getTrace(cclass, "ObjectManagerUtils");
    private static Diagnostics diagnostics;

    @Override
    public void processException(Class sourceClass, String methodName, Throwable throwable, String probe) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{sourceClass, methodName, throwable, probe});
        }
        this.print(null, sourceClass, methodName, throwable, probe, null, null);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    @Override
    public void processException(Class sourceClass, String methodName, Throwable throwable, String probe, Object[] objects) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{sourceClass, methodName, throwable, probe, objects});
        }
        this.print(null, sourceClass, methodName, throwable, probe, null, objects);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object[])objects);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    @Override
    public void processException(Object source, Class sourceClass, String methodName, Throwable throwable, String probe) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{source, sourceClass, methodName, throwable, probe});
        }
        this.print(source, sourceClass, methodName, throwable, probe, null, null);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object)source);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    @Override
    public void processException(Object source, Class sourceClass, String methodName, Throwable throwable, String probe, Object[] objects) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{source, sourceClass, methodName, throwable, probe, objects});
        }
        this.print(source, sourceClass, methodName, throwable, probe, null, objects);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object)source, (Object[])objects);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    @Override
    public void processException(Object source, Class sourceClass, String methodName, Throwable throwable, String probe, String fileInformation, Object[] objects) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{source, sourceClass, methodName, throwable, probe, objects});
        }
        this.print(source, sourceClass, methodName, throwable, probe, fileInformation, objects);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object)source, (Object[])objects);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    static {
        FFDCImpl fFDCImpl = new FFDCImpl();
        Objects.requireNonNull(fFDCImpl);
        diagnostics = fFDCImpl.new Diagnostics();
    }

    public class Diagnostics
    extends DiagnosticModule {
        private Diagnostics() {
            if (diagnostics == null) {
                com.ibm.ws.ffdc.FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)"com.ibm.ws.objectManager");
                com.ibm.ws.ffdc.FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)"com.ibm.ws.objectManager.utils");
            }
        }

        public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object caller, Object[] objects, String sourceId) {
            int i;
            String methodName = "ffdcDumpDefault";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "ffdcDumpDefault", new Object[]{throwable, incidentStream, caller, objects, sourceId});
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            HashSet<String> classNames = new HashSet<String>();
            for (i = 0; i < stackTraceElements.length; ++i) {
                final String elementClassName = stackTraceElements[i].getClassName();
                if (elementClassName.indexOf(".objectManager.") < 0 || classNames.contains(elementClassName)) continue;
                Object sccsid = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> elementClass = Class.forName(elementClassName);
                            Field declaredField = elementClass.getDeclaredField("Ssccid");
                            if (declaredField != null) {
                                declaredField.setAccessible(true);
                                return declaredField.get(null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                if (sccsid != null) {
                    incidentStream.writeLine(elementClassName, sccsid.toString());
                }
                classNames.add(elementClassName);
            }
            if (caller != null) {
                this.dump(caller, incidentStream);
            }
            if (objects != null) {
                for (i = 0; i < objects.length; ++i) {
                    this.dump(objects[i], incidentStream);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "ffdcDumpDefault");
            }
        }

        private void dump(Object object, IncidentStream incidentStream) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (object instanceof Printable) {
                try {
                    ((Printable)object).print(printWriter);
                }
                catch (Exception exception) {
                    printWriter.print(object);
                    printWriter.println();
                    printWriter.print(exception);
                }
            } else {
                printWriter.print(object);
            }
            incidentStream.write(object.getClass().getName(), stringWriter.toString());
        }
    }
}

