/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemCollection;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MismatchedMessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.msgstore.list.PrioritizedCursor;
import com.ibm.ws.sib.msgstore.list.PrioritizedList;
import com.ibm.ws.sib.msgstore.list.UnprioritizedNonlockingCursor;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ItemStreamLink
extends LinkOwner
implements ItemCollection {
    private static TraceComponent tc = Tr.register(ItemStreamLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private PrioritizedList _items;
    private LinkedList _itemStreams;
    private LinkedList _referenceStreams;
    private long _nextSequenceToIssue = 0L;
    private final ListStatistics _statistics;

    public ItemStreamLink(ItemStream item, LinkOwner owningStreamLink, Persistable persistable) throws OutOfCacheSpace {
        super((AbstractItem)item, owningStreamLink, persistable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, item, persistable});
        }
        this._items = new PrioritizedList();
        this._itemStreams = new LinkedList();
        this._referenceStreams = new LinkedList();
        this._statistics = new ListStatistics(this);
        this._setWatermarks(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public ItemStreamLink(LinkOwner owningStreamLink, Persistable tuple) {
        super(owningStreamLink, tuple);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, tuple});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
        this._statistics = new ListStatistics(this);
    }

    private final void _ensureReferencesAreLoaded() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_ensureReferencesAreLoaded");
        }
        ReferenceStreamLink rs = (ReferenceStreamLink)this._referenceStreams.getHead();
        while (null != rs) {
            rs.ensureReferencesLoaded();
            rs = (ReferenceStreamLink)this._referenceStreams.getNextLink(rs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_ensureReferencesAreLoaded");
        }
    }

    final void _initializeChildren(HashMap map) throws SevereMessageStoreException {
        this._itemStreams = new LinkedList();
        this._referenceStreams = new LinkedList();
        MessageStoreImpl messageStore = this.getMessageStoreImpl();
        ArrayList children = (ArrayList)map.remove(this.getID());
        for (int i = 0; null != children && i < children.size(); ++i) {
            long seq;
            Persistable tuple = (Persistable)children.get(i);
            LinkOwner childLink = null;
            tuple.setContainingStream(this.getTuple());
            if (tuple.getTupleType().equals(TupleTypeEnum.ITEM_STREAM)) {
                childLink = new ItemStreamLink(this, tuple);
                childLink.restoreState(tuple);
                if (childLink.isInStore()) {
                    messageStore.register(childLink);
                }
                if (childLink.isItemStreamLink()) {
                    ((ItemStreamLink)childLink)._initializeChildren(map);
                }
            } else if (tuple.getTupleType().equals(TupleTypeEnum.REFERENCE_STREAM)) {
                childLink = new ReferenceStreamLink(this, tuple);
                childLink.restoreState(tuple);
                if (childLink.isInStore()) {
                    messageStore.register(childLink);
                }
            } else {
                throw new SevereMessageStoreException("Wrong tuple type in ItemStream:" + tuple.getTupleType());
            }
            if ((seq = tuple.getSequence()) < this._nextSequenceToIssue) continue;
            this._nextSequenceToIssue = seq + 1L;
        }
    }

    private final void _initializeItems() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_initializeItems");
        }
        this._items = new PrioritizedList();
        MessageStoreImpl messageStore = this.getMessageStoreImpl();
        PersistentMessageStore pm = messageStore.getPersistentMessageStore();
        try {
            List list = pm.readNonStreamItems(this.getTuple());
            for (Persistable tuple : list) {
                ItemLink link = null;
                if (tuple.getTupleType().equals(TupleTypeEnum.ITEM)) {
                    link = new ItemLink(this, tuple);
                    link.restoreState(tuple);
                    if (link.isInStore()) {
                        messageStore.register(link);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeItems");
                    }
                    throw new SevereMessageStoreException("Wrong tuple type in ItemStream:" + tuple.getTupleType());
                }
                long seq = tuple.getSequence();
                if (seq < this._nextSequenceToIssue) continue;
                this._nextSequenceToIssue = seq + 1L;
            }
        }
        catch (PersistenceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink._initializeItems", (String)"217", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeItems");
            }
            throw new SevereMessageStoreException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeItems");
        }
    }

    private final PrioritizedList _items() throws SevereMessageStoreException {
        if (null == this._items) {
            this._initializeItems();
            this._ensureReferencesAreLoaded();
        }
        return this._items;
    }

    private final void _setWatermarks(ItemStream itemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)itemStream);
        }
        long countLow = itemStream.getCountLowWaterMark();
        long countHigh = itemStream.getCountHighWaterMark();
        long byteLow = itemStream.getByteLowWaterMark();
        long byteHigh = itemStream.getByteHighWaterMark();
        this._statistics.setWatermarks(countLow, countHigh, byteLow, byteHigh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)this._statistics);
        }
    }

    public final void addItem(Item item, long lockID, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItem", (Object)new Object[]{item, lockID, transaction});
        }
        this._items();
        MessageStoreImpl messageStore = this.getMessageStoreImpl();
        MessageStore tranStore = ((PersistentTransaction)transaction).getOwningMessageStore();
        if (messageStore != tranStore) {
            MismatchedMessageStoreException mmse = new MismatchedMessageStoreException("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore), (Object)mmse);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
            }
            throw mmse;
        }
        int strategy = item.getStorageStrategy();
        long itemID = messageStore.getUniqueValue(strategy);
        TupleTypeEnum type = TupleTypeEnum.ITEM;
        Persistable childPersistable = this.getTuple().createPersistable(itemID, type);
        ItemLink link = new ItemLink((AbstractItem)item, this, childPersistable);
        link.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStore.registerLink(link, (AbstractItem)item);
        link.cmdAdd(this, lockID, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem", (Object)new Object[]{"Item:      " + item, "Item Link: " + link});
        }
    }

    public final void addItemStream(ItemStream itemStream, long lockID, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        MessageStore tranStore;
        MessageStoreImpl messageStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItemStream", (Object)new Object[]{itemStream, lockID, transaction});
        }
        if ((messageStore = this.getMessageStoreImpl()) != (tranStore = ((PersistentTransaction)transaction).getOwningMessageStore())) {
            MismatchedMessageStoreException mmse = new MismatchedMessageStoreException("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore), (Object)mmse);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
            }
            throw mmse;
        }
        int strategy = itemStream.getStorageStrategy();
        long itemID = messageStore.getUniqueValue(strategy);
        TupleTypeEnum type = TupleTypeEnum.ITEM_STREAM;
        Persistable childPersistable = this.getTuple().createPersistable(itemID, type);
        ItemStreamLink link = new ItemStreamLink(itemStream, (LinkOwner)this, childPersistable);
        link.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStore.registerLink(link, (AbstractItem)itemStream);
        link.cmdAdd(this, lockID, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream", (Object)new Object[]{"Stream:      " + itemStream, "Stream Link: " + link});
        }
    }

    public final void addReferenceStream(ReferenceStream referenceStream, long lockID, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        MessageStore tranStore;
        MessageStoreImpl messageStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReferenceStream", (Object)new Object[]{referenceStream, lockID, transaction});
        }
        if ((messageStore = this.getMessageStoreImpl()) != (tranStore = ((PersistentTransaction)transaction).getOwningMessageStore())) {
            MismatchedMessageStoreException mmse = new MismatchedMessageStoreException("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)("Transaction supplied on add does not originate from this MessageStore! MS: " + (Object)((Object)messageStore) + ", Tran.MS: " + tranStore), (Object)mmse);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
            }
            throw mmse;
        }
        int strategy = referenceStream.getStorageStrategy();
        long itemID = messageStore.getUniqueValue(strategy);
        TupleTypeEnum type = TupleTypeEnum.REFERENCE_STREAM;
        Persistable childPersistable = this.getTuple().createPersistable(itemID, type);
        ReferenceStreamLink link = new ReferenceStreamLink(referenceStream, (LinkOwner)this, childPersistable);
        link.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStore.registerLink(link, (AbstractItem)referenceStream);
        link.cmdAdd(this, lockID, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream", (Object)new Object[]{"Stream:      " + referenceStream, "Stream Link: " + link});
        }
    }

    @Override
    public final void append(AbstractItemLink link) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"append", (Object)link);
        }
        if (link.isItemStreamLink()) {
            this._itemStreams.append(link);
        } else if (link.isReferenceStreamLink()) {
            this._referenceStreams.append(link);
        } else {
            this._items().append(link);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"append");
        }
    }

    @Override
    public final SevereMessageStoreException assertCanDelete(PersistentTransaction transaction) {
        SevereMessageStoreException ex = super.assertCanDelete(transaction);
        if (null != ex) {
            return ex;
        }
        int removesFromMeUnderThisTransaction = 0;
        TaskList taskList = (TaskList)transaction.getWorkList();
        if (null != taskList) {
            removesFromMeUnderThisTransaction = taskList.countRemovingItems(this);
            boolean canDelete = this.getListStatistics().canDelete(removesFromMeUnderThisTransaction);
            if (!canDelete) {
                long itemCount = this.getListStatistics().getTotalItemCount();
                String className = null;
                try {
                    AbstractItem item = this.getItem();
                    if (item != null) {
                        className = item.getClass().getName();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("Cannot delete non-empty stream! Items on Stream=" + itemCount + ", Removes in this transaction=" + removesFromMeUnderThisTransaction + ", Stream class=" + className));
                    }
                    ex = new SevereMessageStoreException("STREAM_NOT_EMPTY_SIMS0507", new Object[]{itemCount, className});
                }
                catch (SevereMessageStoreException smse) {
                    FFDCFilter.processException((Throwable)smse, (String)"com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink.assertCanDelete", (String)"1:506:1.112", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Severe exception caught during assertCanDelete!", (Object)((Object)smse));
                    }
                    ex = smse;
                }
            }
        }
        return ex;
    }

    final void assertReadyForReferenceInitialisation() throws SevereMessageStoreException {
        this._items();
    }

    @Override
    public final void checkSpillLimits() {
        this._statistics.checkSpillLimits();
    }

    protected final boolean canSoftenReference() {
        return false;
    }

    public final void ensureItemsLoaded() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureItemsLoaded");
        }
        this._items();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureItemsLoaded");
        }
    }

    @Override
    public final void eventWatermarkBreached() throws SevereMessageStoreException {
        ItemStream itemStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        if (null != (itemStream = (ItemStream)this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notifying eventWatermarkBreached: " + itemStream));
            }
            itemStream.eventWatermarkBreached();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notified eventWatermarkBreached: " + itemStream));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no itemStream to notify");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    @Override
    public final boolean expirableExpire(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        boolean allowed = true;
        if (this._statistics.getTotalItemCount() > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"cannot expire a non-empty stream");
            }
            allowed = false;
        } else {
            allowed = super.expirableExpire(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)allowed);
        }
        return allowed;
    }

    public final AbstractItem findById(long itemId) throws SevereMessageStoreException {
        this.getStatistics();
        return this.getMessageStoreImpl()._findById(itemId);
    }

    public AbstractItem findFirstMatchingItem(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        PrioritizedList items = this._items();
        AbstractItem item = items.findFirstMatching(filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)item);
        }
        return item;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        ItemStream item = (ItemStream)this._itemStreams.findFirstMatching(filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)item);
        }
        return item;
    }

    public final ReferenceStream findFirstMatchingReferenceStream(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)filter);
        }
        ReferenceStream item = (ReferenceStream)this._referenceStreams.findFirstMatching(filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)item);
        }
        return item;
    }

    public AbstractItem findOldestItem() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        this._items();
        AbstractItem item = this._items().findOldestItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)item);
        }
        return item;
    }

    final ItemStream getItemStream() throws SevereMessageStoreException {
        return (ItemStream)this.getItem();
    }

    @Override
    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final ItemStream getOwningItemStream() throws SevereMessageStoreException {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    final ReferenceStream getReferenceStream() {
        return null;
    }

    public final Statistics getStatistics() throws SevereMessageStoreException {
        this._items();
        return this.getListStatistics();
    }

    @Override
    public final boolean isItemStreamLink() {
        return true;
    }

    public final boolean isSpilling() {
        boolean spilling = false;
        if (1 != this.getTuple().getStorageStrategy()) {
            spilling = this.getListStatistics().isSpilling();
        }
        return spilling;
    }

    @Override
    protected final void itemHasBeenRestored(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored", (Object)item);
        }
        super.itemHasBeenRestored(item);
        this._setWatermarks((ItemStream)item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored");
        }
    }

    @Override
    public final void linkAvailable(AbstractItemLink link) throws SevereMessageStoreException {
        this._items().linkAvailable(link);
    }

    @Override
    public final boolean loadOwnedLinks() throws SevereMessageStoreException {
        boolean loaded = false;
        if (null == this._items) {
            this._items();
            loaded = true;
        }
        return loaded;
    }

    public LockingCursor newLockingItemCursor(Filter filter, boolean jumpbackEnabled) throws PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)new Object[]{filter, jumpbackEnabled});
        }
        AbstractItem item = this.getItem();
        int storageStrategy = item.getStorageStrategy();
        long lockID = this.getMessageStoreImpl().getUniqueLockID(storageStrategy);
        PrioritizedCursor cursor = this._items().newCursor(filter, lockID, jumpbackEnabled);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    public NonLockingCursor newNonLockingItemCursor(Filter filter) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)filter);
        }
        PrioritizedCursor cursor = this._items().newCursor(filter, -2L, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)filter);
        }
        UnprioritizedNonlockingCursor cursor = new UnprioritizedNonlockingCursor(this._itemStreams, filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingReferenceStreamCursor(Filter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)filter);
        }
        UnprioritizedNonlockingCursor cursor = new UnprioritizedNonlockingCursor(this._referenceStreams, filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public final synchronized long nextSequence() {
        return this._nextSequenceToIssue++;
    }

    public AbstractItem removeFirstMatchingItem(Filter filter, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        PrioritizedList items = this._items();
        AbstractItem item = items.removeFirstMatching(filter, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)item);
        }
        return item;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream");
        }
        ItemStream item = (ItemStream)this._itemStreams.removeFirstMatching(filter, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)item);
        }
        return item;
    }

    public final ReferenceStream removeFirstMatchingReferenceStream(Filter filter, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream");
        }
        ReferenceStream item = (ReferenceStream)this._referenceStreams.removeFirstMatching(filter, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)item);
        }
        return item;
    }

    public final void setWatermarks(long countLow, long countHigh, long bytesLow, long bytesHigh) {
        this._statistics.setWatermarks(countLow, countHigh, bytesLow, bytesHigh);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ItemStreamLink(");
        buf.append(this.getID());
        buf.append(")");
        buf.append(super.toString());
        buf.append(" state=");
        buf.append(this.getState());
        return buf.toString();
    }

    protected boolean xmlHasChildren() {
        if (null != this._items) {
            return this._items.xmlHasChildren();
        }
        return false;
    }

    @Override
    protected final String xmlTagName() {
        return "itemStream";
    }

    @Override
    protected void xmlWriteChildrenOn(FormattedWriter writer) throws IOException {
        super.xmlWriteChildrenOn(writer);
        if (null != this._items) {
            this._items.xmlWriteChildrenOn(writer, "items");
        }
        if (null != this._itemStreams) {
            this._itemStreams.xmlWriteOn(writer, "itemStreams");
        }
        if (null != this._referenceStreams) {
            this._referenceStreams.xmlWriteOn(writer, "referenceStreams");
        }
    }
}

