/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public final class ItemLinkMap
implements Map,
XmlConstants {
    private final int _capacityMask;
    private final int _lockMask;
    private volatile AbstractItemLink[] _entry;
    private final Integer _linkCapacity;
    private final Object _entryCreationLock = new Object(){};
    private final Lock[] _lock;
    private AtomicInteger _size;

    ItemLinkMap(int magnitude) {
        this(magnitude, 8);
    }

    ItemLinkMap(int magnitude, int parallelism) {
        if (magnitude > 30) {
            magnitude = 30;
        } else if (magnitude < 8) {
            magnitude = 8;
        }
        if (parallelism > 15) {
            parallelism = 15;
        } else if (parallelism < 0) {
            parallelism = 0;
        }
        int capacity = 2 << magnitude;
        this._entry = null;
        this._capacityMask = capacity - 1;
        this._linkCapacity = new Integer(capacity);
        capacity = 2 << parallelism;
        this._lock = new Lock[capacity];
        this._lockMask = capacity - 1;
        this._size = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Lock _getLock(long key) {
        int i = (int)((long)this._lockMask & key);
        Lock lock = this._lock[i];
        if (null != lock) return lock;
        Lock[] lockArray = this._lock;
        synchronized (this._lock) {
            lock = this._lock[i];
            if (null != lock) return lock;
            this._lock[i] = lock = new Lock();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return lock;
        }
    }

    private final int _indexOfKey(long key) {
        int i = (int)(key & (long)this._capacityMask);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AbstractItemLink get(long key) {
        AbstractItemLink link = null;
        Lock lock = this._getLock(key);
        synchronized (lock) {
            if (null != this._entry) {
                int i = this._indexOfKey(key);
                AbstractItemLink entry = this._entry[i];
                while (null == link && null != entry) {
                    if (key == entry.getID()) {
                        link = entry;
                        continue;
                    }
                    entry = entry.getNextMappedLink();
                }
            }
        }
        return link;
    }

    public final int getSize() {
        return this._size.get();
    }

    public final boolean isEmpty() {
        return this._size.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(long key, AbstractItemLink link) {
        Object object;
        if (null == this._entry) {
            object = this._entryCreationLock;
            synchronized (object) {
                if (null == this._entry) {
                    this._entry = new AbstractItemLink[this._linkCapacity.intValue()];
                }
            }
        }
        object = this._getLock(key);
        synchronized (object) {
            int i = this._indexOfKey(key);
            AbstractItemLink nextEntry = this._entry[i];
            this._entry[i] = link;
            link.setNextMappedLink(nextEntry);
            this._size.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AbstractItemLink remove(long key) {
        AbstractItemLink link = null;
        Lock lock = this._getLock(key);
        synchronized (lock) {
            if (null != this._entry) {
                AbstractItemLink previousEntry;
                int i = this._indexOfKey(key);
                AbstractItemLink thisEntry = previousEntry = this._entry[i];
                while (null != thisEntry && null == link) {
                    AbstractItemLink nextEntry = thisEntry.getNextMappedLink();
                    if (key == thisEntry.getID()) {
                        link = thisEntry;
                        this._size.decrementAndGet();
                        if (previousEntry == thisEntry) {
                            this._entry[i] = nextEntry;
                        } else {
                            previousEntry.setNextMappedLink(nextEntry);
                        }
                    }
                    previousEntry = thisEntry;
                    thisEntry = nextEntry;
                }
            }
        }
        return link;
    }

    @Override
    public final void clear() {
        for (int i = 0; null != this._entry && i < this._entry.length; ++i) {
            this._entry[i] = null;
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("itemMap");
        writer.indent();
        for (int i = 0; null != this._entry && i < this._entry.length; ++i) {
            for (AbstractItemLink ail = this._entry[i]; null != ail; ail = ail.getNextMappedLink()) {
                writer.newLine();
                ail.xmlShortWriteOn(writer);
            }
        }
        writer.outdent();
        writer.newLine();
        writer.endTag("itemMap");
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

