/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.task.TaskListException;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkList;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public final class TaskList
implements WorkList {
    private static final String STATE_BEGIN_ABORT = "Aborting";
    private static final String STATE_BEGIN_COMMIT = "Committing";
    private static final String STATE_BEGIN_POSTABORT = "PostAborting";
    private static final String STATE_BEGIN_POSTCOMMIT = "PostCommitting";
    private static final String STATE_BEGIN_PRECOMMIT = "Precommitting";
    private static final String STATE_END_ABORT = "Aborted";
    private static final String STATE_END_COMMIT = "Committed";
    private static final String STATE_END_POSTABORT = "PostAborted";
    private static final String STATE_END_POSTCOMMIT = "PostCommitted";
    private static final String STATE_END_PRECOMMIT = "Precommitted";
    private static final String STATE_UNTOUCHED = "Untouched";
    private static TraceComponent tc = SibTr.register(TaskList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Task _firstTask;
    private boolean _hasStoreAlways = false;
    private boolean _hasStoreEventually = false;
    private boolean _hasStoreMaybe = false;
    private boolean _hasStoreNever = false;
    private Task _lastTask;
    private boolean _requiresPersistence = false;
    private String _state = "Untouched";
    private int _taskCount = 0;

    @Override
    public final void addWork(WorkItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + item));
        }
        Task task = (Task)item;
        int storageStrategy = task.getStorageStrategy();
        switch (storageStrategy) {
            case 4: {
                this._hasStoreAlways = true;
                break;
            }
            case 3: {
                this._hasStoreEventually = true;
                break;
            }
            case 2: {
                this._hasStoreMaybe = true;
                break;
            }
            case 1: {
                this._hasStoreNever = true;
            }
        }
        if (null == this._firstTask || null == this._lastTask) {
            this._firstTask = task;
            this._lastTask = task;
            task._nextTask = null;
        } else {
            this._lastTask._nextTask = task;
            this._lastTask = task;
            this._lastTask._nextTask = null;
        }
        ++this._taskCount;
        Persistable tuple = task.getPersistable();
        if (null != tuple) {
            this._requiresPersistence |= tuple.requiresPersistence();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    @Override
    public final void commit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)("Transaction=" + transaction));
        }
        if (STATE_END_PRECOMMIT != this._state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new TaskListException(this._state);
        }
        this._state = STATE_BEGIN_COMMIT;
        Task task = this._firstTask;
        while (null != task) {
            task.commitInternal(transaction);
            task = task._nextTask;
        }
        task = this._firstTask;
        while (null != task) {
            task.commitExternal(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_COMMIT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public final int countLinks() {
        return this._taskCount;
    }

    public final int countRemovingItems(LinkOwner list) {
        int count = 0;
        Task task = this._firstTask;
        while (null != task) {
            if (task.isRemoveFromList(list)) {
                ++count;
            }
            task = task._nextTask;
        }
        return count;
    }

    public final void declareAlreadyPrecommitted() throws TaskListException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"declareAlreadyPrecommitted");
        }
        if (STATE_UNTOUCHED == this._state) {
            this._state = STATE_END_PRECOMMIT;
        } else if (STATE_END_PRECOMMIT != this._state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"declareAlreadyPrecommitted");
            }
            throw new TaskListException(this._state);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"declareAlreadyPrecommitted");
        }
    }

    public final boolean hasStoreAlways() {
        return this._hasStoreAlways;
    }

    public final boolean hasStoreEventually() {
        return this._hasStoreEventually;
    }

    public final boolean hasStoreMaybe() {
        return this._hasStoreMaybe;
    }

    public final boolean hasStoreNever() {
        return this._hasStoreNever;
    }

    public final java.util.Iterator iterator() {
        return new Iterator();
    }

    public final java.util.Iterator iterator(int storageStrategy) {
        return new FilteredIterator(storageStrategy);
    }

    @Override
    public final void postComplete(PersistentTransaction transaction, boolean committed) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postComplete", (Object)("Transaction=" + transaction + ", Committed=" + committed));
        }
        if (committed) {
            if (STATE_END_COMMIT != this._state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"postComplete");
                }
                throw new TaskListException(this._state);
            }
            this._state = STATE_BEGIN_POSTCOMMIT;
        } else {
            if (STATE_BEGIN_ABORT != this._state && STATE_END_ABORT != this._state && STATE_END_PRECOMMIT != this._state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"postComplete");
                }
                throw new TaskListException(this._state);
            }
            this._state = STATE_BEGIN_POSTABORT;
        }
        if (committed) {
            Task task = this._firstTask;
            while (null != task) {
                task.postCommit(transaction);
                task = task._nextTask;
            }
        } else {
            Task task = this._firstTask;
            while (null != task) {
                task.postAbort(transaction);
                task = task._nextTask;
            }
        }
        this._state = committed ? STATE_END_POSTCOMMIT : STATE_END_POSTABORT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postComplete");
        }
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"preCommit", (Object)("Transaction=" + transaction));
        }
        if (STATE_UNTOUCHED != this._state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"preCommit");
            }
            throw new TaskListException(this._state);
        }
        this._state = STATE_BEGIN_PRECOMMIT;
        Task task = this._firstTask;
        while (null != task) {
            task.preCommit(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_PRECOMMIT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"preCommit");
        }
    }

    public final boolean requiresPersistence() {
        return this._requiresPersistence;
    }

    @Override
    public final void rollback(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback", (Object)("Transaction=" + transaction));
        }
        if (STATE_UNTOUCHED != this._state && STATE_END_PRECOMMIT != this._state && STATE_BEGIN_PRECOMMIT != this._state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new TaskListException(this._state);
        }
        this._state = STATE_BEGIN_ABORT;
        Task task = this._firstTask;
        while (null != task) {
            task.abort(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_ABORT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TaskList (");
        buf.append(this._state);
        buf.append(" ");
        int count = this._taskCount;
        buf.append(Integer.toString(count));
        if (1 == count) {
            buf.append(" link) {");
        } else {
            buf.append(" links) {");
        }
        if (count != 0) {
            Task task = this._firstTask;
            while (null != task) {
                buf.append("\n  " + task);
                task = task._nextTask;
            }
        }
        buf.append("\n)");
        return buf.toString();
    }

    @Override
    public String toXmlString() {
        StringBuffer retval = new StringBuffer();
        retval.append("<work-list>\n");
        Task task = this._firstTask;
        while (null != task) {
            retval.append("<work-item>");
            retval.append(task);
            retval.append("</work-item>\n");
            task = task._nextTask;
        }
        retval.append("</work-list>\n");
        return retval.toString();
    }

    private final class Iterator
    implements java.util.Iterator {
        private Task _nextTask;

        private Iterator() {
            this._nextTask = TaskList.this._firstTask;
        }

        @Override
        public final boolean hasNext() {
            return null != this._nextTask;
        }

        public final Object next() {
            if (null == this._nextTask) {
                throw new NoSuchElementException();
            }
            Task replyTask = this._nextTask;
            this._nextTask = this._nextTask._nextTask;
            return replyTask;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private final class FilteredIterator
    implements java.util.Iterator {
        private Task _nextTask;
        private final int _storageStrategy;

        FilteredIterator(int storageStrategy) {
            this._nextTask = TaskList.this._firstTask;
            this._storageStrategy = storageStrategy;
            while (null != this._nextTask && this._storageStrategy != this._nextTask.getStorageStrategy()) {
                this._nextTask = this._nextTask._nextTask;
            }
        }

        @Override
        public final boolean hasNext() {
            return null != this._nextTask;
        }

        public final Object next() {
            if (null == this._nextTask) {
                throw new NoSuchElementException();
            }
            Task replyTask = this._nextTask;
            if (null != this._nextTask) {
                this._nextTask = this._nextTask._nextTask;
            }
            while (null != this._nextTask && this._storageStrategy != this._nextTask.getStorageStrategy()) {
                this._nextTask = this._nextTask._nextTask;
            }
            return replyTask;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

