/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkList;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class MSAutoCommitTransaction
implements ExternalAutoCommitTransaction,
PersistentTransaction {
    private static TraceComponent tc = SibTr.register(MSAutoCommitTransaction.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private XidManager _xidManager;
    private AtomicReference<TransactionState> _state = new AtomicReference<TransactionState>(TransactionState.STATE_ACTIVE);
    private PersistentTranId _ptid;
    private AtomicReference<WorkList> _workList = new AtomicReference();
    private List<TransactionCallback> _callbacks = Collections.synchronizedList(new ArrayList(5));
    private int _maxSize;
    private int _size = 0;
    private BatchingContext _bc;

    public MSAutoCommitTransaction(MessageStoreImpl ms, PersistenceManager persistence, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"AutoCommitTransaction", (Object)("MessageStore=" + (Object)((Object)ms) + ", Persistence=" + persistence + ", MaxSize=" + maxSize));
        }
        this._ms = ms;
        this._persistence = persistence;
        this._maxSize = maxSize;
        if (this._ms != null) {
            this._xidManager = this._ms.getXidManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"AutoCommitTransaction");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void addWork(WorkItem item) throws ProtocolException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + item));
        }
        if (this._state.get() != TransactionState.STATE_ACTIVE) {
            ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)pe);
            }
            if (!TraceComponent.isAnyTracingEnabled()) throw pe;
            if (!tc.isEntryEnabled()) throw pe;
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            throw pe;
        }
        if (item != null) {
            block36: {
                this._state.set(TransactionState.STATE_COMMITTING_1PC);
                this._workList.set(new TaskList());
                this._workList.get().addWork(item);
                for (int i = 0; i < this._callbacks.size(); ++i) {
                    TransactionCallback callback = this._callbacks.get(i);
                    callback.beforeCompletion((TransactionCommon)this);
                }
                try {
                    try {
                        this._workList.get().preCommit(this);
                    }
                    catch (Throwable t) {
                        block33: {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:186:1.10", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during work list preCommit!", (Object)t);
                            }
                            try {
                                this._state.set(TransactionState.STATE_ROLLINGBACK);
                                this._workList.get().rollback(this);
                            }
                            catch (Throwable t2) {
                                FFDCFilter.processException((Throwable)t2, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:203:1.10", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block33;
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)t2);
                            }
                        }
                        this._state.set(TransactionState.STATE_ROLLEDBACK);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)t);
                        }
                        throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{t}, t);
                    }
                    this._persistence.commit(this, true);
                    this._workList.get().commit(this);
                    this._state.set(TransactionState.STATE_COMMITTED);
                }
                catch (RollbackException rbe) {
                    try {
                        throw rbe;
                        catch (SeverePersistenceException spe) {
                            FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:233:1.10", (Object)this);
                            if (this._ms != null) {
                                this._ms.reportLocalError();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)spe));
                            }
                            throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{spe}, (Throwable)spe);
                        }
                        catch (PersistenceException pe) {
                            block34: {
                                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:247:1.10", (Object)this);
                                try {
                                    this._workList.get().rollback(this);
                                    this._state.set(TransactionState.STATE_ROLLEDBACK);
                                }
                                catch (Throwable t) {
                                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:263:1.10", (Object)this);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block34;
                                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling-back WorkList after Commit failure!", (Object)t);
                                }
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction rolled-back due to Exception in Commit!", (Object)((Object)pe));
                            }
                            throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{pe}, (Throwable)pe);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:272:1.10", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during commit phase of transaction!", (Object)t);
                            }
                            throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{t}, t);
                        }
                    }
                    catch (Throwable throwable) {
                        block35: {
                            try {
                                boolean committed;
                                boolean bl = committed = this._state.get() == TransactionState.STATE_COMMITTED;
                                if (this._workList.get() != null) {
                                    this._workList.get().postComplete(this, committed);
                                }
                                for (int i = 0; i < this._callbacks.size(); ++i) {
                                    TransactionCallback callback = this._callbacks.get(i);
                                    callback.afterCompletion((TransactionCommon)this, committed);
                                }
                            }
                            catch (Throwable t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:298:1.10", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block35;
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)t);
                            }
                        }
                        this._callbacks.clear();
                        this._workList.set(null);
                        this._state.set(TransactionState.STATE_ACTIVE);
                        this._ptid = null;
                        if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                        if (!tc.isEntryEnabled()) throw throwable;
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
                        throw throwable;
                    }
                }
                try {
                    boolean committed;
                    boolean bl = committed = this._state.get() == TransactionState.STATE_COMMITTED;
                    if (this._workList.get() != null) {
                        this._workList.get().postComplete(this, committed);
                    }
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        TransactionCallback callback = this._callbacks.get(i);
                        callback.afterCompletion((TransactionCommon)this, committed);
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.addWork", (String)"1:298:1.10", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block36;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)t);
                }
            }
            this._callbacks.clear();
            this._workList.set(null);
            this._state.set(TransactionState.STATE_ACTIVE);
            this._ptid = null;
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            return;
        }
        this._state.set(TransactionState.STATE_ACTIVE);
        ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)pe);
        }
        if (!TraceComponent.isAnyTracingEnabled()) throw pe;
        if (!tc.isEntryEnabled()) throw pe;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
        throw pe;
    }

    @Override
    public WorkList getWorkList() {
        WorkList snapshot = this._workList.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWorkList", (Object)("return=" + snapshot));
        }
        return snapshot;
    }

    public void registerCallback(TransactionCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + callback));
        }
        this._callbacks.add(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerCallback");
        }
    }

    public boolean isAutoCommit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAutoCommit", (Object)"return=true");
        }
        return true;
    }

    public synchronized PersistentTranId getPersistentTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentTranId");
        }
        if (this._ptid == null) {
            this._ptid = this._xidManager != null ? new PersistentTranId(this._xidManager.generateLocalTranId()) : new PersistentTranId(this.hashCode());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws SIResourceException {
        if (++this._size > this._maxSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new SIResourceException((Throwable)new TransactionMaxSizeExceededException());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    public boolean isAlive() {
        boolean retval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAlive");
        }
        boolean bl = retval = this._state.get() == TransactionState.STATE_ACTIVE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAlive", (Object)("return=" + retval));
        }
        return retval;
    }

    public boolean hasSubordinates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasSubordinates");
        }
        boolean retval = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasSubordinates", (Object)("return=" + retval));
        }
        return retval;
    }

    @Override
    public final int getTransactionType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_AUTO_COMMIT");
        }
        return 0;
    }

    @Override
    public void setTransactionState(TransactionState state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionState", (Object)("State=" + state));
        }
        this._state.set(state);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionState");
        }
    }

    @Override
    public TransactionState getTransactionState() {
        TransactionState snapshot = this._state.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionState");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionState", (Object)("return=" + snapshot));
        }
        return snapshot;
    }

    @Override
    public BatchingContext getBatchingContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    @Override
    public void setBatchingContext(BatchingContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + bc));
        }
        this._bc = bc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBatchingContext");
        }
    }

    @Override
    public MessageStore getOwningMessageStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore", (Object)("return=" + (Object)((Object)this._ms)));
        }
        return this._ms;
    }
}

