/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.service;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMain;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsProcessComponent;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.internal.JsMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={JsAdminService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JsAdminServiceImpl
extends JsAdminService {
    private static TraceComponent tc = SibTr.register(JsAdminServiceImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private JsMainImpl _jsmain = null;
    private boolean _multipleSet = false;

    public String quoteJmxPropertyValue(String s) {
        if (JsAdminService.isValidJmxPropertyValue((String)s)) {
            return s;
        }
        return ObjectName.quote(s);
    }

    public String unquoteJmxPropertyValue(String s) {
        return ObjectName.unquote(s);
    }

    public synchronized void setAdminMain(JsMain o) {
        if (this._jsmain != null) {
            this._multipleSet = true;
            SibTr.info((TraceComponent)tc, (String)"ME_INITIALIZING_SIAS0001");
        } else {
            this._jsmain = (JsMainImpl)o;
        }
    }

    public boolean isInitialized() {
        return this._jsmain != null;
    }

    private synchronized void validateEnvironment() throws Exception {
        if (this._multipleSet) {
            throw new Exception("Invalid object instance for admin service; multiple sets received");
        }
        if (this._jsmain == null) {
            throw new Exception("Object instance for the admin service was never set");
        }
    }

    public synchronized JsMain getAdminMain() throws Exception {
        this.validateEnvironment();
        return this._jsmain;
    }

    public JsBus getBus(String name) throws SIBExceptionBusNotFound {
        if (!this.isInitialized()) {
            return null;
        }
        return this._jsmain.getBus(name);
    }

    public JsBus getDefinedBus(String name) throws SIBExceptionBusNotFound {
        if (!this.isInitialized()) {
            return null;
        }
        return this._jsmain.getDefinedBus(name);
    }

    public List<String> listDefinedBuses() {
        if (!this.isInitialized()) {
            return new ArrayList<String>();
        }
        return this._jsmain.listDefinedBuses();
    }

    public JsProcessComponent getProcessComponent(String className) {
        if (!this.isInitialized()) {
            return null;
        }
        return this._jsmain.getProcessComponent(className);
    }

    public Enumeration listMessagingEngines() {
        if (!this.isInitialized()) {
            Vector v = new Vector();
            return v.elements();
        }
        return this._jsmain.listMessagingEngines();
    }

    public Enumeration listMessagingEngines(String busName) {
        if (!this.isInitialized()) {
            Vector v = new Vector();
            return v.elements();
        }
        return this._jsmain.listMessagingEngines(busName);
    }

    public Set getMessagingEngineSet(String busName) {
        if (!this.isInitialized()) {
            HashSet s = new HashSet();
            return s;
        }
        return this._jsmain.getMessagingEngineSet(busName);
    }

    public JsMessagingEngine getMessagingEngine(String busName, String engine) {
        if (!this.isInitialized()) {
            return null;
        }
        return this._jsmain.getMessagingEngine(busName, engine);
    }

    public void activateJMSResource() {
    }

    public void deactivateJMSResource() {
    }

    public Object getService(Class c) {
        if (!this.isInitialized()) {
            return null;
        }
        return this._jsmain.getService(c);
    }

    public boolean isStandaloneServer() {
        return true;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: com/ibm/ws/messaging/service/JsAdminServiceImpl.java");
        }
    }
}

