/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.internal.BaseDestinationImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;

public class SIBDestinationImpl
extends BaseDestinationImpl
implements SIBDestination {
    private static final TraceComponent tc = SibTr.register(SIBDestinationImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private DestinationType destinationType = null;
    private boolean overrideOfQOSByProducerAllowed = true;
    private String defaultReliability = "ASSURED_PERSISTENT";
    private String maximumReliability = "ASSURED_PERSISTENT";
    private int defaultPriority = 0;
    private String exceptionDestination = "_SYSTEM.Exception.Destination";
    private long blockedRetryTimeout = -1L;
    private int maxFailedDeliveries = 5;
    private boolean sendAllowed = true;
    private boolean receiveAllowed = true;
    private boolean receiveExclusive = false;
    private boolean maintainStrictOrder = false;
    private long highMessageThreshold = 50000L;
    private boolean persistRedeliveryCount = true;
    private String exceptionDiscardReliability = "BEST_EFFORT_NONPERSISTENT";
    private boolean topicAccessCheckRequired = true;
    private String faileddeliveryPolicy = "SEND_TO_EXCEPTION_DESTINATION";

    public SIBDestinationImpl() {
    }

    public SIBDestinationImpl(String name, DestinationType destinationType) {
        super(name, false, true);
        this.destinationType = destinationType;
    }

    public boolean equals(Object o) {
        SIBDestination oldDestination = (SIBDestination)o;
        boolean isEqual = true;
        isEqual = this.isEqual(oldDestination);
        if (isEqual && this.getDestinationType().toString().equals(DestinationType.TOPICSPACE.toString()) && this.isTopicAccessCheckRequired() != oldDestination.isTopicAccessCheckRequired()) {
            isEqual = false;
        }
        return isEqual;
    }

    private boolean isEqual(SIBDestination oldDest) {
        if (this.isMaintainStrictOrder() != oldDest.isMaintainStrictOrder()) {
            return false;
        }
        if (this.isOverrideOfQOSByProducerAllowed() != oldDest.isOverrideOfQOSByProducerAllowed()) {
            return false;
        }
        if (this.isPersistRedeliveryCount() != oldDest.isPersistRedeliveryCount()) {
            return false;
        }
        if (this.isReceiveAllowed() != oldDest.isReceiveAllowed()) {
            return false;
        }
        if (this.isReceiveExclusive() != oldDest.isReceiveExclusive()) {
            return false;
        }
        if (this.isSendAllowed() != oldDest.isSendAllowed()) {
            return false;
        }
        if (this.getBlockedRetryTimeout() != oldDest.getBlockedRetryTimeout()) {
            return false;
        }
        if (this.getDefaultPriority() != oldDest.getDefaultPriority()) {
            return false;
        }
        if (!this.getDefaultReliability().equals(oldDest.getDefaultReliability())) {
            return false;
        }
        if (this.getExceptionDestination() != null || oldDest.getExceptionDestination() != null) {
            if (this.getExceptionDestination() != null && oldDest.getExceptionDestination() == null) {
                return false;
            }
            if (this.getExceptionDestination() == null && oldDest.getExceptionDestination() != null) {
                return false;
            }
            if (!this.getExceptionDestination().equals(oldDest.getExceptionDestination())) {
                return false;
            }
        }
        if (!this.getExceptionDiscardReliability().equals(oldDest.getExceptionDiscardReliability())) {
            return false;
        }
        if (this.getHighMessageThreshold() != oldDest.getHighMessageThreshold()) {
            return false;
        }
        if (this.getMaxFailedDeliveries() != oldDest.getMaxFailedDeliveries()) {
            return false;
        }
        return this.getMaximumReliability().equals(oldDest.getMaximumReliability());
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        return this.overrideOfQOSByProducerAllowed;
    }

    public void setOverrideOfQOSByProducerAllowed(boolean overrideOfQOSByProducerAllowed) {
        this.overrideOfQOSByProducerAllowed = overrideOfQOSByProducerAllowed;
    }

    public String getDefaultReliability() {
        return this.defaultReliability;
    }

    public void setDefaultReliability(String defaultReliability) {
        this.defaultReliability = this.getDestinationReliability(defaultReliability);
    }

    public String getMaximumReliability() {
        return this.maximumReliability;
    }

    public void setMaximumReliability(String maximumReliability) {
        this.maximumReliability = this.getDestinationReliability(maximumReliability);
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public String getExceptionDestination() {
        return this.exceptionDestination;
    }

    public void setExceptionDestination(String exceptionDestination) {
        this.exceptionDestination = exceptionDestination;
    }

    public long getBlockedRetryTimeout() {
        return this.blockedRetryTimeout;
    }

    public void setBlockedRetryTimeout(long blockedRetryTimeout) {
        this.blockedRetryTimeout = blockedRetryTimeout;
    }

    public int getMaxFailedDeliveries() {
        return this.maxFailedDeliveries;
    }

    public void setMaxFailedDeliveries(int maxFailedDeliveries) {
        this.maxFailedDeliveries = maxFailedDeliveries;
    }

    public boolean isSendAllowed() {
        return this.sendAllowed;
    }

    public void setSendAllowed(boolean sendAllowed) {
        this.sendAllowed = sendAllowed;
    }

    public boolean isReceiveAllowed() {
        return this.receiveAllowed;
    }

    public void setReceiveAllowed(boolean receiveAllowed) {
        this.receiveAllowed = receiveAllowed;
    }

    public boolean isReceiveExclusive() {
        return this.receiveExclusive;
    }

    public void setReceiveExclusive(boolean receiveExclusive) {
        this.receiveExclusive = receiveExclusive;
    }

    public boolean isMaintainStrictOrder() {
        return this.maintainStrictOrder;
    }

    public void setMaintainStrictOrder(boolean maintainStrictOrder) {
        this.maintainStrictOrder = maintainStrictOrder;
    }

    public long getHighMessageThreshold() {
        return this.highMessageThreshold;
    }

    public void setHighMessageThreshold(long highMessageThreshold) {
        this.highMessageThreshold = highMessageThreshold;
    }

    public boolean isPersistRedeliveryCount() {
        return this.persistRedeliveryCount;
    }

    public void setPersistRedeliveryCount(boolean persistRedeliveryCount) {
        this.persistRedeliveryCount = persistRedeliveryCount;
    }

    public String getExceptionDiscardReliability() {
        return this.exceptionDiscardReliability;
    }

    public void setExceptionDiscardReliability(String exceptionDiscardReliability) {
        this.exceptionDiscardReliability = this.getDestinationReliability(exceptionDiscardReliability);
    }

    public boolean isTopicAccessCheckRequired() {
        return this.topicAccessCheckRequired;
    }

    public void setTopicAccessCheckRequired(boolean topicAccessCheckRequired) {
        this.topicAccessCheckRequired = topicAccessCheckRequired;
    }

    private String getDestinationReliability(String reliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationReliability", (Object)new Object[]{reliability});
        }
        String rel = null;
        if (reliability.equals("BestEffortNonPersistent")) {
            rel = "BEST_EFFORT_NONPERSISTENT";
        } else if (reliability.equals("ExpressNonPersistent")) {
            rel = "EXPRESS_NONPERSISTENT";
        } else if (reliability.equals("ReliableNonPersistent")) {
            rel = "RELIABLE_NONPERSISTENT";
        } else if (reliability.equals("ReliablePersistent")) {
            rel = "RELIABLE_PERSISTENT";
        } else if (reliability.equals("AssuredPersistent")) {
            rel = "ASSURED_PERSISTENT";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationReliability", (Object)new Object[]{rel});
        }
        return rel;
    }

    public void setDefaultAndMaxReliability(String defaultReliability, String maxReliability, JsMEConfig oldJsmeConfig, boolean modified) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefaultAndMaxRelaibility", (Object)new Object[]{defaultReliability, maxReliability, modified});
        }
        int iDefaultRel = this.getReliabilityInt(defaultReliability);
        int iMaxRel = this.getReliabilityInt(maxReliability);
        this.setDefaultReliability(defaultReliability);
        this.setMaximumReliability(maxReliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefaultAndMaxRelaibility");
        }
    }

    private int getReliabilityInt(String reliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliabilityInt", (Object)new Object[]{reliability});
        }
        int iRel = -1;
        if (reliability.equals("BestEffortNonPersistent")) {
            iRel = 0;
        } else if (reliability.equals("ExpressNonPersistent")) {
            iRel = 1;
        } else if (reliability.equals("ReliableNonPersistent")) {
            iRel = 2;
        } else if (reliability.equals("ReliablePersistent")) {
            iRel = 3;
        } else if (reliability.equals("AssuredPersistent")) {
            iRel = 4;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliabilityInt", (Object)new Object[]{iRel});
        }
        return iRel;
    }

    public void setFailedDeliveryPolicy(String failedDeliveryPolicy) {
        this.faileddeliveryPolicy = failedDeliveryPolicy;
    }

    public String getFailedDeliveryPolicy() {
        return this.faileddeliveryPolicy;
    }
}

