/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPath10EvaluatorImpl
extends EvaluatorImpl {
    private static Trace tc = TraceUtils.getTrace(XPath10EvaluatorImpl.class, (String)"SIBMatchSpace");
    private static final Class cclass = XPath10EvaluatorImpl.class;

    @Override
    protected String getStringFromNode(Object inNode) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getStringFromNode", inNode);
        }
        String strValue = null;
        if (inNode instanceof Node) {
            Node theNode = (Node)inNode;
            short nodeType = theNode.getNodeType();
            if (nodeType == 2) {
                strValue = theNode.getNodeValue();
            } else {
                Node firstChild = theNode.getFirstChild();
                if (firstChild != null) {
                    strValue = firstChild.getNodeValue();
                }
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "getStringFromNode", strValue);
        }
        return strValue;
    }

    @Override
    public String getNodeText(Object inNode) {
        String strValue = null;
        if (inNode instanceof Node) {
            String firstChildStr;
            Node firstChild;
            Node theNode = (Node)inNode;
            String nodeName = theNode.getNodeName();
            if (nodeName == null) {
                nodeName = "null";
            }
            StringBuffer wholeString = new StringBuffer(nodeName);
            StringBuffer nodeDetailStr = null;
            NamedNodeMap nodeMap = theNode.getAttributes();
            if (nodeMap != null) {
                for (int i = 0; i < nodeMap.getLength(); ++i) {
                    Node attrNode = nodeMap.item(i);
                    if (nodeDetailStr == null) {
                        nodeDetailStr = new StringBuffer("");
                    }
                    nodeDetailStr.append(" ");
                    nodeDetailStr.append(attrNode.getNodeName());
                    nodeDetailStr.append(":");
                    nodeDetailStr.append(attrNode.getNodeValue());
                    if (i >= nodeMap.getLength() - 1) continue;
                    nodeDetailStr.append(", ");
                }
            }
            if (nodeDetailStr == null && (firstChild = theNode.getFirstChild()) != null && (firstChildStr = firstChild.getNodeValue()) != null) {
                nodeDetailStr = new StringBuffer(firstChildStr);
            }
            if (nodeDetailStr == null) {
                wholeString.append("(null)");
            } else {
                wholeString.append("(");
                wholeString.append(nodeDetailStr);
                wholeString.append(")");
            }
            strValue = wholeString.toString();
        }
        return strValue;
    }

    @Override
    public Object getDocumentRoot(MatchSpaceKey msg) throws BadMessageFormatMatchingException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getDocumentRoot", (Object)msg);
        }
        Node docRoot = (Node)msg.getRootContext();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "getDocumentRoot", (Object)docRoot);
        }
        return docRoot;
    }

    @Override
    protected Boolean compareList(ArrayList firstList, Object val1, boolean lessThan, boolean permissive, boolean overallTrue) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "compareList", new Object[]{firstList, val1, new Boolean(lessThan), new Boolean(permissive), new Boolean(overallTrue)});
        }
        ArrayList secondList = null;
        if (val1 instanceof ArrayList) {
            secondList = (ArrayList)val1;
        }
        Boolean finalReturn = null;
        if (firstList != null) {
            for (Object firstListVal : firstList) {
                Object secondVal;
                String firstVal;
                String firstStrVal = this.getStringFromNode(firstListVal);
                if (secondList != null) {
                    for (Object secListVal : secondList) {
                        String secondVal2;
                        String firstVal2;
                        String secStrVal = null;
                        if (secListVal instanceof Node) {
                            secStrVal = this.getStringFromNode((Node)secListVal);
                        }
                        if ((finalReturn = this.compareListValues(firstVal2 = firstStrVal != null ? firstStrVal : firstListVal, secondVal2 = secStrVal != null ? secStrVal : secListVal, lessThan, permissive, overallTrue)) == null) continue;
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compareList", (Object)finalReturn);
                        }
                        return finalReturn;
                    }
                    continue;
                }
                String secStrVal = null;
                if (val1 instanceof Node) {
                    secStrVal = this.getStringFromNode((Node)val1);
                }
                if ((finalReturn = this.compareListValues(firstVal = firstStrVal != null ? firstStrVal : firstListVal, secondVal = secStrVal != null ? secStrVal : val1, lessThan, permissive, overallTrue)) == null) continue;
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "compareList", (Object)finalReturn);
                }
                return finalReturn;
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "compareList", finalReturn);
        }
        return finalReturn;
    }

    private Boolean compareListValues(Object firstVal, Object secondVal, boolean lessThan, boolean permissive, boolean overallTrue) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "compareListValues", new Object[]{firstVal, secondVal, new Boolean(lessThan), new Boolean(permissive), new Boolean(overallTrue)});
        }
        Boolean finalReturn = null;
        Boolean compReturn = XPath10EvaluatorImpl.compare(firstVal, secondVal, lessThan, permissive);
        if (compReturn != null) {
            if (overallTrue) {
                if (compReturn.equals(Boolean.TRUE)) {
                    finalReturn = Boolean.TRUE;
                }
            } else if (compReturn.equals(Boolean.FALSE)) {
                finalReturn = Boolean.TRUE;
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "compareListValues", (Object)finalReturn);
        }
        return finalReturn;
    }
}

