/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.utils.ras.SibTr;

public class AIValueTick {
    private static final TraceComponent tc = SibTr.register(AIValueTick.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long tick;
    private Reliability msgReliability;
    private int msgPriority;
    private AIMessageItem msgItem;
    private boolean delivered;
    private RemoteDispatchableKey ck;
    private long originalTimeout;
    private long issueTime;
    private long unlockCount;

    public AIValueTick(long tick, AIMessageItem msgItem, boolean delivered, RemoteDispatchableKey ck, long originalTimeout, long issueTime, int redeliveredCount) {
        this.tick = tick;
        JsMessage jsMsg = msgItem.getMessage();
        this.msgReliability = jsMsg.getReliability();
        this.msgPriority = jsMsg.getPriority();
        this.msgItem = delivered ? null : msgItem;
        this.delivered = delivered;
        this.ck = delivered ? null : ck;
        this.originalTimeout = originalTimeout;
        this.issueTime = issueTime;
    }

    public AIValueTick(long tick, Reliability rel) {
        this.tick = tick;
        this.msgReliability = rel;
        this.msgPriority = 0;
        this.msgItem = null;
        this.delivered = true;
        this.ck = null;
        this.originalTimeout = 0L;
        this.issueTime = 0L;
    }

    public long getTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)this.tick);
        }
        return this.tick;
    }

    public Reliability getMsgReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMsgReliability");
            SibTr.exit((TraceComponent)tc, (String)"getMsgReliability", (Object)this.msgReliability);
        }
        return this.msgReliability;
    }

    public int getMsgPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMsgPriority");
            SibTr.exit((TraceComponent)tc, (String)"getMsgPriority", (Object)this.msgPriority);
        }
        return this.msgPriority;
    }

    public AIMessageItem getMsg() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMsg");
            SibTr.exit((TraceComponent)tc, (String)"getMsg", (Object)this.msgItem);
        }
        return this.msgItem;
    }

    public boolean isDelivered() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDelivered");
            SibTr.exit((TraceComponent)tc, (String)"isDelivered", (Object)this.delivered);
        }
        return this.delivered;
    }

    public void setDelivered(boolean delivered) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDelivered", (Object)delivered);
            SibTr.exit((TraceComponent)tc, (String)"isDelivered");
        }
        this.delivered = delivered;
        this.msgItem = null;
    }

    public RemoteDispatchableKey getRemoteDispatchableKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteDispatchableKey");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteDispatchableKey", (Object)this.ck);
        }
        return this.ck;
    }

    public long getOriginalTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOriginalTimeout");
            SibTr.exit((TraceComponent)tc, (String)"getOriginalTimeout", (Object)this.originalTimeout);
        }
        return this.originalTimeout;
    }

    public long getIssueTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIssueTime");
            SibTr.exit((TraceComponent)tc, (String)"getIssueTime", (Object)this.issueTime);
        }
        return this.issueTime;
    }

    public void incRMEUnlockCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incRMEUnlockCount");
        }
        ++this.unlockCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incRMEUnlockCount", (Object)this.unlockCount);
        }
    }

    public long getRMEUnlockCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRMEUnlockCount");
            SibTr.exit((TraceComponent)tc, (String)"getRMEUnlockCount", (Object)this.unlockCount);
        }
        return this.unlockCount;
    }
}

