/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.processor.gd.ARangeList;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.utils.BlockVector;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class StateStream {
    private static TraceComponent tc = SibTr.register(StateStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static byte Unknown = 0;
    private static byte Requested = 1;
    private static byte Uncommitted = (byte)2;
    private static byte Value = (byte)3;
    private static byte Discarded = (byte)4;
    private static byte Accepted = (byte)5;
    private static byte Rejected = (byte)6;
    private static byte Completed = (byte)7;
    private static byte Error = (byte)8;
    private static byte[][] nextState = new byte[][]{{Unknown, Unknown, Error, Error, Error, Error, Error, Error, Error}, {Requested, Requested, Error, Error, Error, Error, Error, Error, Error}, {Uncommitted, Uncommitted, Error, Error, Error, Error, Error, Error, Error}, {Value, Value, Value, Value, Error, Error, Error, Completed, Error}, {Discarded, Discarded, Discarded, Error, Error, Error, Error, Error, Error}, {Accepted, Accepted, Error, Accepted, Error, Error, Error, Error, Error}, {Rejected, Rejected, Error, Rejected, Error, Error, Error, Error, Error}, {Completed, Completed, Completed, Completed, Completed, Completed, Completed, Completed, Error}, {Error, Error, Error, Error, Error, Error, Error, Error, Error}};
    private long completedPrefix;
    private ARangeList list;
    private Object mark = null;

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"init");
        }
        TickRange tr = new TickRange(0, 0L, Long.MAX_VALUE);
        this.list = new ARangeList();
        this.list.init(tr);
        tr = new TickRange(7, 0L, 0L);
        this.list.setCursor(0L);
        this.list.replacePrefix(tr);
        this.completedPrefix = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"init");
        }
    }

    public boolean writeRange(TickRange r) {
        TickRange tr1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeRange", (Object)new Object[]{r, this.completedPrefix});
        }
        boolean streamChanged = false;
        byte newState = r.type;
        this.list.setCursor(r.startstamp);
        TickRange tr2 = (TickRange)this.list.getCurr();
        do {
            tr1 = tr2;
            newState = this.changeState(r.type, tr1.type);
            if (newState != tr1.type) {
                if (tr1.startstamp < r.startstamp) {
                    this.list.splitStart(r.startstamp);
                    tr1 = tr2 = (TickRange)this.list.getCurr();
                }
                if (tr1.endstamp > r.endstamp) {
                    this.list.splitEnd(r.endstamp);
                    tr1 = tr2 = (TickRange)this.list.getCurr();
                }
                tr1.type = newState;
                tr1.value = r.value;
                tr1.valuestamp = r.valuestamp;
                tr1.itemStreamIndex = r.itemStreamIndex;
                streamChanged = true;
            }
            if (tr1.type == 7 && tr1.startstamp <= this.completedPrefix + 1L) {
                this.setCompletedPrefix(tr1.endstamp);
            }
            this.list.getNext();
            tr2 = (TickRange)this.list.getCurr();
        } while (tr2.startstamp <= r.endstamp && tr1 != tr2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRange", (Object)new Boolean(streamChanged));
        }
        return streamChanged;
    }

    public boolean containsRequested(TickRange r) {
        return this.containsState(r, (byte)1);
    }

    public boolean containsState(TickRange r, byte state) {
        TickRange tr1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"containsState", (Object)new Object[]{r, new Byte(state)});
        }
        boolean containsState = false;
        this.list.setCursor(r.startstamp);
        TickRange tr2 = (TickRange)this.list.getNext();
        do {
            if (tr2.type != state) continue;
            containsState = true;
            break;
        } while ((tr1 = tr2) != (tr2 = (TickRange)this.list.getNext()) && tr2.endstamp < r.endstamp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsState", (Object)new Boolean(containsState));
        }
        return containsState;
    }

    public boolean isRequested(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isRequested", (Object)new Long(stamp));
        }
        boolean isRequested = false;
        this.list.setCursor(stamp);
        TickRange tr = (TickRange)this.list.getNext();
        if (tr.type == 1) {
            isRequested = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRequested", (Object)new Boolean(isRequested));
        }
        return isRequested;
    }

    public boolean writeCombinedRange(TickRange r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeCombinedRange", (Object)new Object[]{r, this.completedPrefix});
        }
        boolean streamChanged = false;
        TickRange tr = null;
        if (r.endstamp <= this.completedPrefix && r.valuestamp <= this.completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCombinedRange", (Object)new Boolean(streamChanged));
            }
            return streamChanged;
        }
        long startstamp = StateStream.max(this.completedPrefix + 1L, r.startstamp);
        if (startstamp < r.valuestamp) {
            tr = new TickRange(7, startstamp, r.valuestamp - 1L);
            this.writeCompletedRange(tr);
        }
        tr = new TickRange(r.type, r.valuestamp, r.valuestamp);
        tr.itemStreamIndex = r.itemStreamIndex;
        tr.value = r.value;
        tr.valuestamp = r.valuestamp;
        streamChanged = this.writeRange(tr);
        if (r.endstamp > r.valuestamp) {
            tr = new TickRange(7, r.valuestamp + 1L, r.endstamp);
            this.writeCompletedRange(tr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCombinedRange", (Object)new Boolean(streamChanged));
        }
        return streamChanged;
    }

    public TickRange findCompletedRange(TickRange r) {
        long stamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findCompletedRange", (Object)r);
        }
        long starts = stamp = r.valuestamp;
        long ends = stamp;
        this.list.setCursor(stamp);
        this.mark = this.list.getMark(this.mark);
        TickRange tr1 = (TickRange)this.list.getNext();
        ends = this.discoverNextCompleted(ends, tr1);
        this.list.setCursor(this.mark);
        tr1 = (TickRange)this.list.getPrev();
        r.startstamp = starts = this.discoverPrevCompleted(starts, tr1);
        r.endstamp = ends;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findCompletedRange", (Object)r);
        }
        return r;
    }

    private long discoverNextCompleted(long ends, TickRange tr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverNextCompleted", (Object)new Object[]{new Long(ends), tr});
        }
        TickRange tr2 = tr;
        if (tr2.endstamp == ends) {
            tr2 = (TickRange)this.list.getNext();
        }
        while (tr2.type == 7) {
            ends = tr2.endstamp;
            TickRange tr1 = tr2;
            if (tr1 != (tr2 = (TickRange)this.list.getNext())) continue;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverNextCompleted", (Object)new Long(ends));
        }
        return ends;
    }

    private long discoverPrevCompleted(long starts, TickRange tr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Object[]{new Long(starts), tr});
        }
        TickRange tr2 = tr;
        if (tr2.startstamp == starts) {
            tr2 = (TickRange)this.list.getPrev();
        }
        while (tr2.type == 7) {
            starts = tr2.startstamp;
            TickRange tr1 = tr2;
            if (tr1 != (tr2 = (TickRange)this.list.getPrev())) continue;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Long(starts));
        }
        return starts;
    }

    public long discoverPrevCompleted(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Object[]{new Long(stamp)});
        }
        long prevCompleted = stamp;
        this.list.setCursor(stamp);
        TickRange tr = (TickRange)this.list.getPrev();
        prevCompleted = this.discoverPrevCompleted(stamp, tr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Long(prevCompleted));
        }
        return prevCompleted;
    }

    public TickRange writeCompleted(TickRange r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeCompleted", (Object)new Object[]{r, this.completedPrefix});
        }
        long starts = r.startstamp;
        long ends = r.startstamp;
        if (r.endstamp <= this.completedPrefix && r.valuestamp <= this.completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompleted", (Object)r);
            }
            return r;
        }
        this.list.setCursor(r.startstamp);
        TickRange tr1 = (TickRange)this.list.getCurr();
        byte newState = this.changeState(r.type, tr1.type);
        if (newState != tr1.type) {
            if (newState == 7) {
                TickRange tr2;
                if (starts == tr1.startstamp) {
                    this.list.getPrev();
                    tr2 = (TickRange)this.list.getNext();
                    if (tr2.type == 7) {
                        starts = tr2.startstamp;
                    }
                }
                if (ends == tr1.endstamp) {
                    this.list.getNext();
                    tr2 = (TickRange)this.list.getCurr();
                    if (tr2.type == 7) {
                        ends = tr2.endstamp;
                    }
                }
                r.startstamp = starts;
                r.endstamp = ends;
                if (starts <= this.completedPrefix + 1L) {
                    this.completedPrefix = ends;
                }
            }
            TickRange tr = new TickRange(newState, starts, ends);
            BlockVector bVector = new BlockVector();
            bVector.add(tr);
            this.list.replace(bVector);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompleted", (Object)r);
        }
        return r;
    }

    public TickRange writeCompletedRange(TickRange r) {
        TickRange tr1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeCompletedRange", (Object)new Object[]{r, this.completedPrefix});
        }
        if (r.endstamp <= this.completedPrefix && r.valuestamp <= this.completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)r);
            }
            return r;
        }
        boolean stateChangeError = false;
        long starts = r.startstamp;
        long ends = r.endstamp;
        this.list.setCursor(r.startstamp);
        this.mark = this.list.getMark(this.mark);
        TickRange tr2 = (TickRange)this.list.getNext();
        do {
            tr1 = tr2;
            int changed = 7;
            changed = this.changeState(r.type, tr1.type);
            if (changed != 7) {
                stateChangeError = true;
                break;
            }
            tr2 = (TickRange)this.list.getNext();
        } while (tr2.startstamp <= r.endstamp && tr1 != tr2);
        if (!stateChangeError) {
            if (tr1.type == 7 && tr1.endstamp > r.endstamp) {
                ends = tr1.endstamp;
            }
            if (tr1.endstamp == r.endstamp && tr2.type == 7) {
                ends = tr2.endstamp;
            }
            this.list.setCursor(this.mark);
            tr1 = (TickRange)this.list.getPrev();
            if (tr1.type == 7 && tr1.startstamp < r.startstamp) {
                starts = tr1.startstamp;
            }
            if (tr1.startstamp == r.startstamp) {
                tr2 = (TickRange)this.list.getPrev();
                if (tr2.type == 7) {
                    starts = tr2.startstamp;
                }
            }
            if (starts <= this.completedPrefix + 1L) {
                this.completedPrefix = ends;
            }
            TickRange tr = new TickRange(7, starts, ends);
            BlockVector bVector = new BlockVector();
            bVector.add(tr);
            this.list.replace(bVector);
            r.startstamp = starts;
            r.endstamp = ends;
        } else {
            this.writeRange(r);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)r);
        }
        return r;
    }

    public TickRange writeCompletedRangeForced(TickRange r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)new Object[]{r, this.completedPrefix});
        }
        if (r.endstamp <= this.completedPrefix && r.valuestamp <= this.completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)r);
            }
            return r;
        }
        long starts = r.startstamp;
        long ends = r.endstamp;
        this.list.setCursor(r.startstamp);
        TickRange tr1 = (TickRange)this.list.getPrev();
        if (tr1.type == 7 && tr1.startstamp < r.startstamp) {
            starts = tr1.startstamp;
        }
        if (tr1.startstamp == r.startstamp) {
            tr1 = (TickRange)this.list.getPrev();
            if (tr1.type == 7) {
                starts = tr1.startstamp;
            }
        }
        this.list.setCursor(r.endstamp);
        tr1 = (TickRange)this.list.getNext();
        if (tr1.type == 7 && tr1.endstamp > r.endstamp) {
            ends = tr1.endstamp;
        }
        if (tr1.endstamp == r.endstamp) {
            tr1 = (TickRange)this.list.getNext();
            if (tr1.type == 7) {
                ends = tr1.endstamp;
            }
        }
        if (starts <= this.completedPrefix + 1L) {
            this.completedPrefix = ends;
        }
        TickRange tr = new TickRange(7, starts, ends);
        BlockVector bVector = new BlockVector();
        bVector.add(tr);
        this.list.replace(bVector);
        r.startstamp = starts;
        r.endstamp = ends;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)r);
        }
        return r;
    }

    private byte changeState(byte toState, byte fromState) {
        byte newState = nextState[toState][fromState];
        if (newState == Error) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0008", new Object[]{"com.ibm.ws.sib.processor.gd.StateStream", "1:893:1.51", new Byte(fromState), new Byte(toState)}, null));
        }
        return newState;
    }

    private static final long max(long a, long b) {
        return a > b ? a : b;
    }

    public final void lookup(long startstamp, long endstamp, BlockVector readList) {
        this.list.get(startstamp, endstamp, readList);
    }

    public final void setCursor(long stamp) {
        this.list.setCursor(stamp);
    }

    public final TickRange getNext() {
        return (TickRange)this.list.getNext();
    }

    public final TickRange getPrev() {
        return (TickRange)this.list.getPrev();
    }

    public final long getCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCompletedPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)this.completedPrefix);
        }
        return this.completedPrefix;
    }

    public final boolean setCompletedPrefix(long newprefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCompletedPrefix", (Object)newprefix);
        }
        boolean returnValue = false;
        if (newprefix > this.completedPrefix) {
            TickRange tr;
            this.completedPrefix = newprefix;
            if (this.completedPrefix < Long.MAX_VALUE) {
                this.list.setCursor(this.completedPrefix);
                TickRange tr2 = (TickRange)this.list.getNext();
                do {
                    tr = tr2;
                    if (tr.type != 7) break;
                    this.completedPrefix = tr.endstamp;
                } while (tr != (tr2 = (TickRange)this.list.getNext()));
            }
            tr = new TickRange(7, 0L, this.completedPrefix);
            this.list.setCursor(0L);
            this.list.replacePrefix(tr);
            returnValue = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCompletedPrefix", (Object)new Object[]{returnValue, this.completedPrefix});
        }
        return returnValue;
    }

    public String stateString(String str) {
        TickRange ro2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stateString", (Object)new Object[]{this, str});
        }
        String ret = "Elements in stream " + str + ": Completedpre=" + this.completedPrefix + ":\n";
        this.setCursor(0L);
        TickRange ro = this.getNext();
        do {
            ret = ret + ro.toString() + "\n";
            ro2 = ro;
        } while ((ro = this.getNext()) != ro2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stateString", (Object)ret);
        }
        return ret;
    }
}

