/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.processor.impl.AbstractDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.IOException;
import java.util.HashMap;

abstract class AbstractBaseDestinationHandler
extends AbstractDestinationHandler {
    private static final TraceComponent tc = SibTr.register(AbstractBaseDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected DestinationDefinition definition;
    private volatile boolean _isReceiveAllowed = true;
    protected int _maxFailedDeliveries = -1;
    protected boolean _isRedeliveryCountPersisted = false;
    protected long _blockedRetryInterval = -1L;

    public AbstractBaseDestinationHandler() {
    }

    public AbstractBaseDestinationHandler(MessageProcessor messageProcessor, DestinationDefinition destinationDefinition, String busName) {
        super(messageProcessor, busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractBaseDestinationHandler", (Object)new Object[]{messageProcessor, destinationDefinition, busName});
        }
        this.definition = destinationDefinition;
        if (this.definition != null) {
            this._blockedRetryInterval = this.definition.getBlockedRetryTimeout();
            if (this._blockedRetryInterval < 0L) {
                this._blockedRetryInterval = messageProcessor.getCustomProperties().get_blocked_retry_timeout();
            }
        }
        this._isReceiveAllowed = this.definition != null ? destinationDefinition.isReceiveAllowed() : true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractBaseDestinationHandler", (Object)this);
        }
    }

    public void addPersistentData(HashMap hm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentData", (Object)hm);
        }
        hm.put("name", this.definition.getName());
        hm.put("uuid", this.definition.getUUID().toByteArray());
        hm.put("maxReliability", this.definition.getMaxReliability().toInt());
        hm.put("defaultReliability", this.definition.getDefaultReliability().toInt());
        hm.put("destinationType", this.definition.getDestinationType().toInt());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentData");
        }
    }

    @Override
    public long getAlterationTime() {
        return this.definition.getAlterationTime();
    }

    @Override
    public int getDefaultPriority() {
        return this.definition.getDefaultPriority();
    }

    @Override
    public Reliability getDefaultReliability() {
        return this.definition.getDefaultReliability();
    }

    @Override
    public DestinationType getDestinationType() {
        return this.definition.getDestinationType();
    }

    @Override
    public String getExceptionDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDestination");
        }
        String exDest = this.definition.getExceptionDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDestination", (Object)exDest);
        }
        return exDest;
    }

    @Override
    public Reliability getExceptionDiscardReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDiscardReliability");
        }
        Reliability exDiscardRel = this.definition.getExceptionDiscardReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDiscardReliability", (Object)exDiscardRel);
        }
        return exDiscardRel;
    }

    @Override
    public int getMaxFailedDeliveries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxFailedDeliveries");
        }
        if (this._maxFailedDeliveries < 0) {
            this._maxFailedDeliveries = this.definition.getMaxFailedDeliveries();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaxFailedDeliveries", (Object)this._maxFailedDeliveries);
        }
        return this._maxFailedDeliveries;
    }

    public boolean isRedeliveryCountPersisted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRedeliveryCountPersisted");
        }
        this._isRedeliveryCountPersisted = this.definition.isRedeliveryCountPersisted();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRedeliveryCountPersisted", (Object)this._isRedeliveryCountPersisted);
        }
        return this._isRedeliveryCountPersisted;
    }

    @Override
    public long getBlockedRetryInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBlockedRetryInterval");
        }
        if (this._blockedRetryInterval < 0L) {
            this._blockedRetryInterval = this.definition.getBlockedRetryTimeout();
        }
        if (this._blockedRetryInterval < 0L) {
            this._blockedRetryInterval = this.messageProcessor.getCustomProperties().get_blocked_retry_timeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBlockedRetryInterval", (Object)this._blockedRetryInterval);
        }
        return this._blockedRetryInterval;
    }

    @Override
    public Reliability getMaxReliability() {
        return this.definition.getMaxReliability();
    }

    @Override
    public BaseDestinationDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public boolean isForeign() {
        return false;
    }

    @Override
    public boolean isReceiveAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed");
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)this._isReceiveAllowed);
        }
        return this._isReceiveAllowed;
    }

    @Override
    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean isSendAllowed = this.definition.isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)isSendAllowed);
        }
        return isSendAllowed;
    }

    @Override
    public boolean isOverrideOfQOSByProducerAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed");
        }
        boolean isOverrideOfQOSByProducerAllowed = this.definition.isOverrideOfQOSByProducerAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)isOverrideOfQOSByProducerAllowed);
        }
        return isOverrideOfQOSByProducerAllowed;
    }

    @Override
    public boolean isReceiveExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveExclusive");
        }
        boolean isReceiveExclusive = this.definition.isReceiveExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReceiveExclusive", (Object)isReceiveExclusive);
        }
        return isReceiveExclusive;
    }

    public void restorePersistentData(HashMap hm) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentData", (Object)hm);
        }
        int destType = (Integer)hm.get("destinationType");
        DestinationType destinationType = DestinationType.getDestinationType((int)destType);
        String name = (String)hm.get("name");
        JsAdminFactory jsAdminFactory = JsAdminFactory.getInstance();
        this.definition = jsAdminFactory.createDestinationDefinition(destinationType, name);
        this.definition.setUUID(new SIBUuid12((byte[])hm.get("uuid")));
        int maxReliability = (Integer)hm.get("maxReliability");
        this.definition.setMaxReliability(Reliability.getReliability((int)maxReliability));
        int defaultReliability = (Integer)hm.get("defaultReliability");
        this.definition.setDefaultReliability(Reliability.getReliability((int)defaultReliability));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentData");
        }
    }

    @Override
    public void updateDefinition(BaseDestinationDefinition destinationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)new Object[]{destinationDefinition});
        }
        DestinationDefinition oldDefinition = this.definition;
        DestinationDefinition newDefinition = (DestinationDefinition)destinationDefinition;
        this._maxFailedDeliveries = -1;
        this._blockedRetryInterval = -1L;
        if (!(this.isPubSub() || oldDefinition != null && oldDefinition.isReceiveExclusive() == newDefinition.isReceiveExclusive())) {
            this.notifyAOHReceiveExclusiveChange(newDefinition.isReceiveExclusive());
            ConsumerDispatcher cm = (ConsumerDispatcher)this.getLocalPtoPConsumerManager();
            if (cm != null) {
                cm.closeAllConsumersForReceiveExclusive();
            }
            this.notifyRCDReceiveExclusiveChange(newDefinition.isReceiveExclusive());
        }
        this.definition = (DestinationDefinition)destinationDefinition;
        if (oldDefinition == null || oldDefinition.isReceiveAllowed() != newDefinition.isReceiveAllowed()) {
            this._isReceiveAllowed = newDefinition.isReceiveAllowed();
            this.notifyReceiveAllowed(this);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    protected abstract void notifyAOHReceiveExclusiveChange(boolean var1);

    protected abstract void notifyRCDReceiveExclusiveChange(boolean var1);

    @Override
    public void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        if (this.isPubSub()) {
            SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
            filter.LOCAL = Boolean.TRUE;
            SIMPIterator itr = this.getSubscriptionIndex().iterator(filter);
            while (itr.hasNext()) {
                ControllableSubscription subscription = (ControllableSubscription)itr.next();
                ConsumerDispatcher cd = (ConsumerDispatcher)subscription.getOutputHandler();
                if (cd == null) continue;
                cd.notifyReceiveAllowed(destinationHandler);
            }
            itr.finished();
        } else {
            ConsumerDispatcher cm = (ConsumerDispatcher)this.getLocalPtoPConsumerManager();
            if (cm != null) {
                cm.notifyReceiveAllowed(destinationHandler);
            }
        }
        this.notifyReceiveAllowedRCD(destinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("name", (Object)this.definition.getName());
        writer.newLine();
        writer.taggedValue("uuid", (Object)this.definition.getUUID());
    }

    @Override
    public boolean isTopicAccessCheckRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired");
        }
        boolean ret = this.definition.isTopicAccessCheckRequired();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)ret);
        }
        return ret;
    }
}

